package org.openqa.selenium.devtools.v141.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when direct_socket.UDPSocket connection is opened.
 */
@org.openqa.selenium.Beta()
public class DirectUDPSocketOpened {

    private final org.openqa.selenium.devtools.v141.network.model.RequestId identifier;

    private final java.lang.String localAddr;

    private final java.lang.Integer localPort;

    private final org.openqa.selenium.devtools.v141.network.model.MonotonicTime timestamp;

    private final java.util.Optional<java.lang.String> remoteAddr;

    private final java.util.Optional<java.lang.Integer> remotePort;

    public DirectUDPSocketOpened(org.openqa.selenium.devtools.v141.network.model.RequestId identifier, java.lang.String localAddr, java.lang.Integer localPort, org.openqa.selenium.devtools.v141.network.model.MonotonicTime timestamp, java.util.Optional<java.lang.String> remoteAddr, java.util.Optional<java.lang.Integer> remotePort) {
        this.identifier = java.util.Objects.requireNonNull(identifier, "identifier is required");
        this.localAddr = java.util.Objects.requireNonNull(localAddr, "localAddr is required");
        this.localPort = java.util.Objects.requireNonNull(localPort, "localPort is required");
        this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
        this.remoteAddr = remoteAddr;
        this.remotePort = remotePort;
    }

    public org.openqa.selenium.devtools.v141.network.model.RequestId getIdentifier() {
        return identifier;
    }

    public java.lang.String getLocalAddr() {
        return localAddr;
    }

    /**
     * Expected to be unsigned integer.
     */
    public java.lang.Integer getLocalPort() {
        return localPort;
    }

    public org.openqa.selenium.devtools.v141.network.model.MonotonicTime getTimestamp() {
        return timestamp;
    }

    public java.util.Optional<java.lang.String> getRemoteAddr() {
        return remoteAddr;
    }

    /**
     * Expected to be unsigned integer.
     */
    public java.util.Optional<java.lang.Integer> getRemotePort() {
        return remotePort;
    }

    private static DirectUDPSocketOpened fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v141.network.model.RequestId identifier = null;
        java.lang.String localAddr = null;
        java.lang.Integer localPort = 0;
        org.openqa.selenium.devtools.v141.network.model.MonotonicTime timestamp = null;
        java.util.Optional<java.lang.String> remoteAddr = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> remotePort = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "identifier":
                    identifier = input.read(org.openqa.selenium.devtools.v141.network.model.RequestId.class);
                    break;
                case "localAddr":
                    localAddr = input.nextString();
                    break;
                case "localPort":
                    localPort = input.nextNumber().intValue();
                    break;
                case "timestamp":
                    timestamp = input.read(org.openqa.selenium.devtools.v141.network.model.MonotonicTime.class);
                    break;
                case "remoteAddr":
                    remoteAddr = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "remotePort":
                    remotePort = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DirectUDPSocketOpened(identifier, localAddr, localPort, timestamp, remoteAddr, remotePort);
    }
}
