package org.openqa.selenium.devtools.v141.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum UnencodedDigestError {

    MALFORMEDDICTIONARY("MalformedDictionary"), UNKNOWNALGORITHM("UnknownAlgorithm"), INCORRECTDIGESTTYPE("IncorrectDigestType"), INCORRECTDIGESTLENGTH("IncorrectDigestLength");

    private String value;

    UnencodedDigestError(String value) {
        this.value = value;
    }

    public static UnencodedDigestError fromString(String s) {
        return java.util.Arrays.stream(UnencodedDigestError.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within UnencodedDigestError "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static UnencodedDigestError fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
