package org.openqa.selenium.devtools.v140.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Configuration for dual screen hinge
 */
public class HingeConfig {

    private final org.openqa.selenium.devtools.v140.dom.model.Rect rect;

    private final java.util.Optional<org.openqa.selenium.devtools.v140.dom.model.RGBA> contentColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v140.dom.model.RGBA> outlineColor;

    public HingeConfig(org.openqa.selenium.devtools.v140.dom.model.Rect rect, java.util.Optional<org.openqa.selenium.devtools.v140.dom.model.RGBA> contentColor, java.util.Optional<org.openqa.selenium.devtools.v140.dom.model.RGBA> outlineColor) {
        this.rect = java.util.Objects.requireNonNull(rect, "rect is required");
        this.contentColor = contentColor;
        this.outlineColor = outlineColor;
    }

    /**
     * A rectangle represent hinge
     */
    public org.openqa.selenium.devtools.v140.dom.model.Rect getRect() {
        return rect;
    }

    /**
     * The content box highlight fill color (default: a dark color).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v140.dom.model.RGBA> getContentColor() {
        return contentColor;
    }

    /**
     * The content box highlight outline color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v140.dom.model.RGBA> getOutlineColor() {
        return outlineColor;
    }

    private static HingeConfig fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v140.dom.model.Rect rect = null;
        java.util.Optional<org.openqa.selenium.devtools.v140.dom.model.RGBA> contentColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v140.dom.model.RGBA> outlineColor = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "rect":
                    rect = input.read(org.openqa.selenium.devtools.v140.dom.model.Rect.class);
                    break;
                case "contentColor":
                    contentColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v140.dom.model.RGBA.class));
                    break;
                case "outlineColor":
                    outlineColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v140.dom.model.RGBA.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new HingeConfig(rect, contentColor, outlineColor);
    }
}
