package org.openqa.selenium.devtools.v140.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public enum TrustTokenOperationType {

    ISSUANCE("Issuance"), REDEMPTION("Redemption"), SIGNING("Signing");

    private String value;

    TrustTokenOperationType(String value) {
        this.value = value;
    }

    public static TrustTokenOperationType fromString(String s) {
        return java.util.Arrays.stream(TrustTokenOperationType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within TrustTokenOperationType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static TrustTokenOperationType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
