/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v140.overlay.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v140.dom.model.RGBA;
import org.openqa.selenium.devtools.v140.dom.model.Rect;
import org.openqa.selenium.json.JsonInput;

public class HingeConfig {
    private final Rect rect;
    private final Optional<RGBA> contentColor;
    private final Optional<RGBA> outlineColor;

    public HingeConfig(Rect rect, Optional<RGBA> contentColor, Optional<RGBA> outlineColor) {
        this.rect = Objects.requireNonNull(rect, "rect is required");
        this.contentColor = contentColor;
        this.outlineColor = outlineColor;
    }

    public Rect getRect() {
        return this.rect;
    }

    public Optional<RGBA> getContentColor() {
        return this.contentColor;
    }

    public Optional<RGBA> getOutlineColor() {
        return this.outlineColor;
    }

    private static HingeConfig fromJson(JsonInput input) {
        Rect rect = null;
        Optional<RGBA> contentColor = Optional.empty();
        Optional<RGBA> outlineColor = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "rect": {
                    rect = (Rect)input.read(Rect.class);
                    continue block10;
                }
                case "contentColor": {
                    contentColor = Optional.ofNullable((RGBA)input.read(RGBA.class));
                    continue block10;
                }
                case "outlineColor": {
                    outlineColor = Optional.ofNullable((RGBA)input.read(RGBA.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new HingeConfig(rect, contentColor, outlineColor);
    }
}

