/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v133.filesystem.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v133.storage.model.SerializedStorageKey;
import org.openqa.selenium.json.JsonInput;

public class BucketFileSystemLocator {
    private final SerializedStorageKey storageKey;
    private final Optional<String> bucketName;
    private final List<String> pathComponents;

    public BucketFileSystemLocator(SerializedStorageKey storageKey, Optional<String> bucketName, List<String> pathComponents) {
        this.storageKey = Objects.requireNonNull(storageKey, "storageKey is required");
        this.bucketName = bucketName;
        this.pathComponents = Objects.requireNonNull(pathComponents, "pathComponents is required");
    }

    public SerializedStorageKey getStorageKey() {
        return this.storageKey;
    }

    public Optional<String> getBucketName() {
        return this.bucketName;
    }

    public List<String> getPathComponents() {
        return this.pathComponents;
    }

    private static BucketFileSystemLocator fromJson(JsonInput input) {
        SerializedStorageKey storageKey = null;
        Optional<String> bucketName = Optional.empty();
        List pathComponents = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "storageKey": {
                    storageKey = (SerializedStorageKey)input.read(SerializedStorageKey.class);
                    continue block10;
                }
                case "bucketName": {
                    bucketName = Optional.ofNullable(input.nextString());
                    continue block10;
                }
                case "pathComponents": {
                    pathComponents = input.readArray(String.class);
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new BucketFileSystemLocator(storageKey, bucketName, pathComponents);
    }
}

