/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v115.preload.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v115.page.model.FrameId;
import org.openqa.selenium.devtools.v115.preload.model.PrefetchStatus;
import org.openqa.selenium.devtools.v115.preload.model.PreloadingAttemptKey;
import org.openqa.selenium.devtools.v115.preload.model.PreloadingStatus;
import org.openqa.selenium.json.JsonInput;

public class PrefetchStatusUpdated {
    private final PreloadingAttemptKey key;
    private final FrameId initiatingFrameId;
    private final String prefetchUrl;
    private final PreloadingStatus status;
    private final PrefetchStatus prefetchStatus;

    public PrefetchStatusUpdated(PreloadingAttemptKey key, FrameId initiatingFrameId, String prefetchUrl, PreloadingStatus status, PrefetchStatus prefetchStatus) {
        this.key = Objects.requireNonNull(key, "key is required");
        this.initiatingFrameId = Objects.requireNonNull(initiatingFrameId, "initiatingFrameId is required");
        this.prefetchUrl = Objects.requireNonNull(prefetchUrl, "prefetchUrl is required");
        this.status = Objects.requireNonNull(status, "status is required");
        this.prefetchStatus = Objects.requireNonNull(prefetchStatus, "prefetchStatus is required");
    }

    public PreloadingAttemptKey getKey() {
        return this.key;
    }

    public FrameId getInitiatingFrameId() {
        return this.initiatingFrameId;
    }

    public String getPrefetchUrl() {
        return this.prefetchUrl;
    }

    public PreloadingStatus getStatus() {
        return this.status;
    }

    public PrefetchStatus getPrefetchStatus() {
        return this.prefetchStatus;
    }

    private static PrefetchStatusUpdated fromJson(JsonInput input) {
        PreloadingAttemptKey key = null;
        FrameId initiatingFrameId = null;
        String prefetchUrl = null;
        PreloadingStatus status = null;
        PrefetchStatus prefetchStatus = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "key": {
                    key = (PreloadingAttemptKey)input.read(PreloadingAttemptKey.class);
                    continue block14;
                }
                case "initiatingFrameId": {
                    initiatingFrameId = (FrameId)input.read(FrameId.class);
                    continue block14;
                }
                case "prefetchUrl": {
                    prefetchUrl = input.nextString();
                    continue block14;
                }
                case "status": {
                    status = (PreloadingStatus)((Object)input.read(PreloadingStatus.class));
                    continue block14;
                }
                case "prefetchStatus": {
                    prefetchStatus = (PrefetchStatus)((Object)input.read(PrefetchStatus.class));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PrefetchStatusUpdated(key, initiatingFrameId, prefetchUrl, status, prefetchStatus);
    }
}

