package org.openqa.selenium.devtools.v105.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * An inspector issue reported from the back-end.
 */
public class InspectorIssue {

    private final org.openqa.selenium.devtools.v105.audits.model.InspectorIssueCode code;

    private final org.openqa.selenium.devtools.v105.audits.model.InspectorIssueDetails details;

    private final java.util.Optional<org.openqa.selenium.devtools.v105.audits.model.IssueId> issueId;

    public InspectorIssue(org.openqa.selenium.devtools.v105.audits.model.InspectorIssueCode code, org.openqa.selenium.devtools.v105.audits.model.InspectorIssueDetails details, java.util.Optional<org.openqa.selenium.devtools.v105.audits.model.IssueId> issueId) {
        this.code = java.util.Objects.requireNonNull(code, "code is required");
        this.details = java.util.Objects.requireNonNull(details, "details is required");
        this.issueId = issueId;
    }

    public org.openqa.selenium.devtools.v105.audits.model.InspectorIssueCode getCode() {
        return code;
    }

    public org.openqa.selenium.devtools.v105.audits.model.InspectorIssueDetails getDetails() {
        return details;
    }

    /**
     * A unique id for this issue. May be omitted if no other entity (e.g.
     * exception, CDP message, etc.) is referencing this issue.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v105.audits.model.IssueId> getIssueId() {
        return issueId;
    }

    private static InspectorIssue fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v105.audits.model.InspectorIssueCode code = null;
        org.openqa.selenium.devtools.v105.audits.model.InspectorIssueDetails details = null;
        java.util.Optional<org.openqa.selenium.devtools.v105.audits.model.IssueId> issueId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "code":
                    code = input.read(org.openqa.selenium.devtools.v105.audits.model.InspectorIssueCode.class);
                    break;
                case "details":
                    details = input.read(org.openqa.selenium.devtools.v105.audits.model.InspectorIssueDetails.class);
                    break;
                case "issueId":
                    issueId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v105.audits.model.IssueId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new InspectorIssue(code, details, issueId);
    }
}
