/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.chromium.ChromiumDriverLogLevel;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverService;

public class ChromeDriverService
extends DriverService {
    public static final String CHROME_DRIVER_NAME = "chromedriver";
    public static final String CHROME_DRIVER_EXE_PROPERTY = "webdriver.chrome.driver";
    public static final String CHROME_DRIVER_READABLE_TIMESTAMP = "webdriver.chrome.readableTimestamp";
    public static final String CHROME_DRIVER_LOG_PROPERTY = "webdriver.chrome.logfile";
    public static final String CHROME_DRIVER_LOG_LEVEL_PROPERTY = "webdriver.chrome.loglevel";
    public static final String CHROME_DRIVER_APPEND_LOG_PROPERTY = "webdriver.chrome.appendLog";
    public static final String CHROME_DRIVER_VERBOSE_LOG_PROPERTY = "webdriver.chrome.verboseLogging";
    public static final String CHROME_DRIVER_SILENT_OUTPUT_PROPERTY = "webdriver.chrome.silentOutput";
    public static final String CHROME_DRIVER_ALLOWED_IPS_PROPERTY = "webdriver.chrome.withAllowedIps";
    public static final String CHROME_DRIVER_DISABLE_BUILD_CHECK = "webdriver.chrome.disableBuildCheck";

    public ChromeDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, timeout, Collections.unmodifiableList(new ArrayList<String>(args)), Collections.unmodifiableMap(new HashMap<String, String>(environment)));
    }

    public String getDriverName() {
        return CHROME_DRIVER_NAME;
    }

    public String getDriverProperty() {
        return CHROME_DRIVER_EXE_PROPERTY;
    }

    public Capabilities getDefaultDriverOptions() {
        return new ChromeOptions();
    }

    public static ChromeDriverService createDefaultService() {
        return (ChromeDriverService)new Builder().build();
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends DriverService.Builder<ChromeDriverService, Builder> {
        private Boolean disableBuildCheck;
        private Boolean readableTimestamp;
        private Boolean appendLog;
        private Boolean verbose;
        private Boolean silent;
        private String allowedListIps;
        private ChromiumDriverLogLevel logLevel;

        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.CHROME.is(capabilities.getBrowserName())) {
                ++score;
            }
            if (capabilities.getCapability("goog:chromeOptions") != null) {
                ++score;
            }
            return score;
        }

        public Builder withAppendLog(boolean appendLog) {
            this.appendLog = appendLog;
            return this;
        }

        public Builder withBuildCheckDisabled(boolean noBuildCheck) {
            this.disableBuildCheck = noBuildCheck;
            return this;
        }

        public Builder withLogLevel(ChromiumDriverLogLevel logLevel) {
            this.logLevel = logLevel;
            this.silent = false;
            this.verbose = false;
            return this;
        }

        public Builder withSilent(boolean silent) {
            if (silent) {
                this.logLevel = ChromiumDriverLogLevel.OFF;
            }
            this.silent = false;
            return this;
        }

        public Builder withVerbose(boolean verbose) {
            if (verbose) {
                this.logLevel = ChromiumDriverLogLevel.ALL;
            }
            this.verbose = false;
            return this;
        }

        public Builder withAllowedListIps(String allowedListIps) {
            this.allowedListIps = allowedListIps;
            return this;
        }

        public Builder withReadableTimestamp(Boolean readableTimestamp) {
            this.readableTimestamp = readableTimestamp;
            return this;
        }

        protected void loadSystemProperties() {
            this.parseLogOutput(ChromeDriverService.CHROME_DRIVER_LOG_PROPERTY);
            if (this.disableBuildCheck == null) {
                this.disableBuildCheck = Boolean.getBoolean(ChromeDriverService.CHROME_DRIVER_DISABLE_BUILD_CHECK);
            }
            if (this.readableTimestamp == null) {
                this.readableTimestamp = Boolean.getBoolean(ChromeDriverService.CHROME_DRIVER_READABLE_TIMESTAMP);
            }
            if (this.appendLog == null) {
                this.appendLog = Boolean.getBoolean(ChromeDriverService.CHROME_DRIVER_APPEND_LOG_PROPERTY);
            }
            if (this.verbose == null && Boolean.getBoolean(ChromeDriverService.CHROME_DRIVER_VERBOSE_LOG_PROPERTY)) {
                this.withVerbose(Boolean.getBoolean(ChromeDriverService.CHROME_DRIVER_VERBOSE_LOG_PROPERTY));
            }
            if (this.silent == null && Boolean.getBoolean(ChromeDriverService.CHROME_DRIVER_SILENT_OUTPUT_PROPERTY)) {
                this.withSilent(Boolean.getBoolean(ChromeDriverService.CHROME_DRIVER_SILENT_OUTPUT_PROPERTY));
            }
            if (this.allowedListIps == null) {
                this.allowedListIps = System.getProperty(ChromeDriverService.CHROME_DRIVER_ALLOWED_IPS_PROPERTY);
            }
            if (this.logLevel == null && System.getProperty(ChromeDriverService.CHROME_DRIVER_LOG_LEVEL_PROPERTY) != null) {
                String level = System.getProperty(ChromeDriverService.CHROME_DRIVER_LOG_LEVEL_PROPERTY);
                this.withLogLevel(ChromiumDriverLogLevel.fromString((String)level));
            }
        }

        protected List<String> createArgs() {
            ArrayList<String> args = new ArrayList<String>();
            args.add(String.format("--port=%d", this.getPort()));
            if (this.getLogFile() != null) {
                args.add(String.format("--log-path=%s", this.getLogFile().getAbsolutePath()));
                if (Boolean.TRUE.equals(this.readableTimestamp)) {
                    args.add("--readable-timestamp");
                }
                if (Boolean.TRUE.equals(this.appendLog)) {
                    args.add("--append-log");
                }
                this.withLogOutput(OutputStream.nullOutputStream());
            }
            if (this.logLevel != null) {
                args.add(String.format("--log-level=%s", this.logLevel.toString().toUpperCase()));
            }
            if (this.allowedListIps != null) {
                args.add(String.format("--allowed-ips=%s", this.allowedListIps));
            }
            if (Boolean.TRUE.equals(this.disableBuildCheck)) {
                args.add("--disable-build-check");
            }
            return Collections.unmodifiableList(args);
        }

        protected ChromeDriverService createDriverService(File exe, int port, Duration timeout, List<String> args, Map<String, String> environment) {
            try {
                return new ChromeDriverService(exe, port, timeout, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

