/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;

public interface HasDownloads {
    default public void requireDownloadsEnabled(Capabilities capabilities) {
        if (!HasDownloads.isDownloadsEnabled(capabilities)) {
            throw new WebDriverException("You must enable downloads in order to work with downloadable files.");
        }
    }

    public boolean isDownloadsEnabled();

    public static boolean isDownloadsEnabled(Capabilities capabilities) {
        return capabilities.is("se:downloadsEnabled");
    }

    @Deprecated
    public List<String> getDownloadableFiles();

    public List<DownloadedFile> getDownloadedFiles();

    public void downloadFile(String var1, Path var2) throws IOException;

    public void deleteDownloadableFiles();

    public static class DownloadedFile {
        private final String name;
        private final long creationTime;
        private final long lastModifiedTime;
        private final long size;

        public DownloadedFile(String name, long creationTime, long lastModifiedTime, long size) {
            this.name = name;
            this.creationTime = creationTime;
            this.lastModifiedTime = lastModifiedTime;
            this.size = size;
        }

        public String getName() {
            return this.name;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public long getSize() {
            return this.size;
        }
    }
}

