/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.KeyboardEvent;
import java.io.IOException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.htmlunit.HtmlUnitWebElement;
import org.openqa.selenium.htmlunit.InputKeysContainer;
import org.openqa.selenium.htmlunit.KeyboardModifiersState;
import org.openqa.selenium.interactions.Keyboard;

public class HtmlUnitKeyboard
implements Keyboard {
    private KeyboardModifiersState modifiersState = new KeyboardModifiersState();
    private final HtmlUnitDriver parent;

    HtmlUnitKeyboard(HtmlUnitDriver parent) {
        this.parent = parent;
    }

    private HtmlUnitWebElement getElementToSend(WebElement toElement) {
        WebElement sendToElement = toElement;
        if (sendToElement == null) {
            sendToElement = this.parent.switchTo().activeElement();
        }
        return (HtmlUnitWebElement)sendToElement;
    }

    public void sendKeys(CharSequence ... keysToSend) {
        WebElement toElement = this.parent.switchTo().activeElement();
        HtmlUnitWebElement htmlElem = this.getElementToSend(toElement);
        htmlElem.sendKeys(keysToSend);
    }

    public void sendKeys(HtmlElement element, String currentValue, InputKeysContainer keysToSend) {
        keysToSend.setCapitalization(this.modifiersState.isShiftPressed());
        if (this.parent.isJavascriptEnabled() && !(element instanceof HtmlFileInput)) {
            HtmlTextInput input;
            if (element instanceof HtmlTextArea) {
                HtmlTextArea area = (HtmlTextArea)element;
                String text = area.getText();
                area.setSelectionStart(text.length());
                area.setSelectionEnd(text.length());
            } else if (element instanceof HtmlTextInput) {
                input = (HtmlTextInput)element;
                String text = input.getText();
                input.setSelectionStart(text.length());
                input.setSelectionEnd(text.length());
            } else if (element instanceof HtmlPasswordInput) {
                input = (HtmlPasswordInput)element;
                String text = input.getText();
                input.setSelectionStart(text.length());
                input.setSelectionEnd(text.length());
            }
            try {
                element.type(keysToSend.toString());
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        } else if (element instanceof HtmlInput) {
            HtmlInput input = (HtmlInput)element;
            input.setValueAttribute((currentValue == null ? "" : currentValue) + keysToSend.toString());
        } else if (element instanceof HtmlTextArea) {
            ((HtmlTextArea)element).setText((currentValue == null ? "" : currentValue) + keysToSend.toString());
        } else {
            throw new UnsupportedOperationException("You may only set the value of elements that are input elements");
        }
    }

    public void pressKey(CharSequence keyToPress) {
        WebElement toElement = this.parent.switchTo().activeElement();
        HtmlUnitWebElement htmlElement = this.getElementToSend(toElement);
        this.modifiersState.storeKeyDown(keyToPress);
        htmlElement.sendKeyDownEvent(keyToPress);
    }

    public void releaseKey(CharSequence keyToRelease) {
        WebElement toElement = this.parent.switchTo().activeElement();
        HtmlUnitWebElement htmlElement = this.getElementToSend(toElement);
        this.modifiersState.storeKeyUp(keyToRelease);
        htmlElement.sendKeyUpEvent(keyToRelease);
    }

    void performSingleKeyAction(HtmlElement element, CharSequence modifierKey, String eventDescription) {
        boolean shiftKey = modifierKey.equals(Keys.SHIFT);
        boolean ctrlKey = modifierKey.equals(Keys.CONTROL);
        boolean altKey = modifierKey.equals(Keys.ALT);
        KeyboardEvent keyEvent = new KeyboardEvent((DomNode)element, eventDescription, 0, shiftKey, ctrlKey, altKey);
        element.fireEvent((Event)keyEvent);
    }

    public boolean isShiftPressed() {
        return this.modifiersState.isShiftPressed();
    }

    public boolean isCtrlPressed() {
        return this.modifiersState.isCtrlPressed();
    }

    public boolean isAltPressed() {
        return this.modifiersState.isAltPressed();
    }
}

