/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import org.scijava.script.AutoCompleter;
import org.scijava.script.AutoCompletionResult;
import org.scijava.script.ScriptLanguage;

public abstract class AbstractAutoCompleter
implements AutoCompleter {
    private ScriptLanguage scriptLanguage;

    public AbstractAutoCompleter(ScriptLanguage scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }

    @Override
    public AutoCompletionResult autocomplete(String code, int index, ScriptEngine engine) {
        ArrayList<String> matches = new ArrayList<String>();
        boolean startIndex = false;
        if (code.endsWith(".")) {
            matches.addAll(this.engineAttributesCompleter(code, index, engine));
        } else if (code.contains(".")) {
            List<String> codeList = Arrays.asList(code.split("\\."));
            String objectString = codeList.get(codeList.size() - 2);
            String prefix = codeList.get(codeList.size() - 1);
            matches.addAll(this.engineAttributesCompleter(objectString + ".", prefix, index, engine));
        } else {
            matches.addAll(this.engineVariablesCompleter(code, index, engine));
        }
        List<String> unique = matches.stream().distinct().collect(Collectors.toList());
        Collections.sort(unique, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                return s1.toLowerCase().compareTo(s2.toLowerCase());
            }
        });
        return new AutoCompletionResult(unique, 0);
    }

    private List<String> engineVariablesCompleter(String code, int index, ScriptEngine engine) {
        ArrayList<String> matches = new ArrayList<String>();
        Bindings bindings = engine.getBindings(100);
        for (String key : bindings.keySet()) {
            if (!key.toLowerCase().startsWith(code.toLowerCase())) continue;
            matches.add(key);
        }
        return matches;
    }

    private List<String> engineAttributesCompleter(String objectString, int index, ScriptEngine engine) {
        return this.engineAttributesCompleter(objectString, "", index, engine);
    }

    private List<String> engineAttributesCompleter(String objectString, String prefix, int index, ScriptEngine engine) {
        ArrayList<String> matches = new ArrayList<String>();
        String lPrefix = prefix.toLowerCase();
        Bindings bindings = engine.getBindings(100);
        for (String key : bindings.keySet()) {
            if (!objectString.endsWith(key + ".")) continue;
            Object obj = bindings.get(key);
            for (Field field : obj.getClass().getFields()) {
                if (!field.getName().toLowerCase().startsWith(lPrefix)) continue;
                matches.add(objectString + field.getName());
            }
            for (AccessibleObject accessibleObject : obj.getClass().getMethods()) {
                if (!((Method)accessibleObject).getName().toLowerCase().startsWith(lPrefix)) continue;
                matches.add(objectString + ((Method)accessibleObject).getName() + "(");
            }
        }
        return matches;
    }
}

