/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.junit;

import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Suite$;
import org.scalatest.Tracker;
import org.scalatest.events.Formatter;
import org.scalatest.events.IndentedText;
import org.scalatest.events.MotionToSuppress$;
import org.scalatest.events.TestFailed$;
import org.scalatest.events.TestStarting$;
import org.scalatest.events.TestSucceeded$;
import org.scalatest.exceptions.PayloadField;
import org.scalatest.junit.JUnit3Suite;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001m4Q!\u0001\u0002\u0001\t!\u0011a\"T=UKN$H*[:uK:,'O\u0003\u0002\u0004\t\u0005)!.\u001e8ji*\u0011QAB\u0001\ng\u000e\fG.\u0019;fgRT\u0011aB\u0001\u0004_J<7c\u0001\u0001\n#A\u0011!bD\u0007\u0002\u0017)\u0011A\"D\u0001\u0005Y\u0006twMC\u0001\u000f\u0003\u0011Q\u0017M^1\n\u0005AY!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0013-5\t1C\u0003\u0002\u0015+\u0005IaM]1nK^|'o\u001b\u0006\u0002\u0007%\u0011qc\u0005\u0002\r)\u0016\u001cH\u000fT5ti\u0016tWM\u001d\u0005\t3\u0001\u0011\t\u0011)A\u00057\u00051!/\u001a9peR\u001c\u0001\u0001\u0005\u0002\u001d;5\tA!\u0003\u0002\u001f\t\tA!+\u001a9peR,'\u000f\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\"\u0003\u001d!(/Y2lKJ\u0004\"\u0001\b\u0012\n\u0005\r\"!a\u0002+sC\u000e\\WM\u001d\u0005\u0006K\u0001!\tAJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u001dJ#\u0006\u0005\u0002)\u00015\t!\u0001C\u0003\u001aI\u0001\u00071\u0004C\u0003!I\u0001\u0007\u0011\u0005C\u0004-\u0001\t\u0007I\u0011B\u0017\u0002\u001d\u0019\f\u0017\u000e\\3e)\u0016\u001cHo]*fiV\ta\u0006E\u00020maj\u0011\u0001\r\u0006\u0003cI\nq!\\;uC\ndWM\u0003\u00024i\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u0019\u0003\u0007M+G\u000f\u0005\u0002\u0013s%\u0011!h\u0005\u0002\u0005)\u0016\u001cH\u000f\u0003\u0004=\u0001\u0001\u0006IAL\u0001\u0010M\u0006LG.\u001a3UKN$8oU3uA!)a\b\u0001C\u0005\u007f\u00059r-\u001a;Tk&$XMT1nK\u001a{'\u000fV3ti\u000e\u000b7/\u001a\u000b\u0003\u0001\"\u0003\"!Q#\u000f\u0005\t\u001bU\"\u0001\u001b\n\u0005\u0011#\u0014A\u0002)sK\u0012,g-\u0003\u0002G\u000f\n11\u000b\u001e:j]\u001eT!\u0001\u0012\u001b\t\u000b%k\u0004\u0019\u0001\u001d\u0002\u0011Q,7\u000f^\"bg\u0016DQa\u0013\u0001\u0005\u00021\u000b\u0001dZ3u\u001b\u0016\u001c8/Y4f\u000f&4XM\u001c+ie><\u0018M\u00197f)\riu*\u0018\t\u0003\u00159K!AR\u0006\t\u000bAS\u0005\u0019A)\u0002\u0013QD'o\\<bE2,\u0007C\u0001*[\u001d\t\u0019\u0006L\u0004\u0002U/6\tQK\u0003\u0002W5\u00051AH]8pizJ\u0011!N\u0005\u00033R\nq\u0001]1dW\u0006<W-\u0003\u0002\\9\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u00033RBQA\u0018&A\u0002}\u000ba#[:BgN,'\u000f^5p]\u001a\u000b\u0017\u000e\\3e\u000bJ\u0014xN\u001d\t\u0003\u0005\u0002L!!\u0019\u001b\u0003\u000f\t{w\u000e\\3b]\")1\r\u0001C\u0001I\u0006I1\u000f^1siR+7\u000f\u001e\u000b\u0003K\"\u0004\"A\u00114\n\u0005\u001d$$\u0001B+oSRDQ!\u00132A\u0002aBQA\u001b\u0001\u0005\u0002-\f\u0001\"\u00193e\u000bJ\u0014xN\u001d\u000b\u0004K2l\u0007\"B%j\u0001\u0004A\u0004\"\u0002)j\u0001\u0004\t\u0006\"B8\u0001\t\u0003\u0001\u0018AC1eI\u001a\u000b\u0017\u000e\\;sKR\u0019Q-\u001d:\t\u000b%s\u0007\u0019\u0001\u001d\t\u000bMt\u0007\u0019\u0001;\u0002)\u0005\u001c8/\u001a:uS>tg)Y5mK\u0012,%O]8s!\t\u0011R/\u0003\u0002w'\t!\u0012i]:feRLwN\u001c$bS2,G-\u0012:s_JDQ\u0001\u001f\u0001\u0005\u0002e\fq!\u001a8e)\u0016\u001cH\u000f\u0006\u0002fu\")\u0011j\u001ea\u0001q\u0001")
public class MyTestListener
implements TestListener {
    private final Reporter report;
    private final Tracker tracker;
    private final Set<Test> failedTestsSet;

    private Set<Test> failedTestsSet() {
        return this.failedTestsSet;
    }

    private String getSuiteNameForTestCase(Test testCase) {
        String string;
        Test test = testCase;
        if (test instanceof JUnit3Suite) {
            JUnit3Suite jUnit3Suite = (JUnit3Suite)test;
            string = jUnit3Suite.suiteName();
        } else {
            string = Suite$.MODULE$.getSimpleNameOfAnObjectsClass(testCase);
        }
        return string;
    }

    public String getMessageGivenThrowable(Throwable throwable, boolean isAssertionFailedError) {
        return throwable.getMessage() == null ? new StringBuilder().append((Object)"A JUnit3Suite test failed with an ").append((Object)(isAssertionFailedError ? "AssertionFailedError" : "exception")).toString() : throwable.getMessage();
    }

    public void startTest(Test testCase) {
        if (testCase == null) {
            throw new NullPointerException("testCase was null");
        }
        this.report.apply(TestStarting$.MODULE$.apply(this.tracker.nextOrdinal(), this.getSuiteNameForTestCase(testCase), (Option<String>)new Some((Object)testCase.getClass().getName()), testCase.toString(), (Option<Formatter>)new Some((Object)MotionToSuppress$.MODULE$), (Option<Rerunner>)None$.MODULE$));
    }

    public void addError(Test testCase, Throwable throwable) {
        Option<Object> option;
        if (testCase == null) {
            throw new NullPointerException("testCase was null");
        }
        if (throwable == null) {
            throw new NullPointerException("throwable was null");
        }
        IndentedText formatter = Suite$.MODULE$.getIndentedText(testCase.toString(), 1, true);
        Throwable throwable2 = throwable;
        if (throwable2 instanceof PayloadField) {
            Throwable throwable3 = throwable2;
            option = ((PayloadField)((Object)throwable3)).payload();
        } else {
            option = None$.MODULE$;
        }
        Option<Object> payload = option;
        this.report.apply(TestFailed$.MODULE$.apply(this.tracker.nextOrdinal(), this.getMessageGivenThrowable(throwable, false), this.getSuiteNameForTestCase(testCase), (Option<String>)new Some((Object)testCase.getClass().getName()), testCase.toString(), (Option<Throwable>)new Some((Object)throwable), (Option<Object>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Rerunner>)None$.MODULE$, payload));
        this.failedTestsSet().$plus$eq((Object)testCase);
    }

    public void addFailure(Test testCase, AssertionFailedError assertionFailedError) {
        if (testCase == null) {
            throw new NullPointerException("testCase was null");
        }
        if (assertionFailedError == null) {
            throw new NullPointerException("throwable was null");
        }
        IndentedText formatter = Suite$.MODULE$.getIndentedText(testCase.toString(), 1, true);
        this.report.apply(TestFailed$.MODULE$.apply(this.tracker.nextOrdinal(), this.getMessageGivenThrowable((Throwable)assertionFailedError, true), this.getSuiteNameForTestCase(testCase), (Option<String>)new Some((Object)testCase.getClass().getName()), testCase.toString(), (Option<Throwable>)new Some((Object)assertionFailedError), (Option<Object>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Rerunner>)None$.MODULE$));
        this.failedTestsSet().$plus$eq((Object)testCase);
    }

    public void endTest(Test testCase) {
        boolean testHadFailed = this.failedTestsSet().contains((Object)testCase);
        if (testHadFailed) {
            this.failedTestsSet().$minus$eq((Object)testCase);
        } else {
            if (testCase == null) {
                throw new NullPointerException("testCase was null");
            }
            IndentedText formatter = Suite$.MODULE$.getIndentedText(testCase.toString(), 1, true);
            this.report.apply(TestSucceeded$.MODULE$.apply(this.tracker.nextOrdinal(), this.getSuiteNameForTestCase(testCase), (Option<String>)new Some((Object)testCase.getClass().getName()), testCase.toString(), (Option<Object>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Rerunner>)None$.MODULE$));
        }
    }

    public MyTestListener(Reporter report, Tracker tracker) {
        this.report = report;
        this.tracker = tracker;
        this.failedTestsSet = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

