/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.junit;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Resources$;
import org.scalatest.Suite$;
import org.scalatest.Tracker;
import org.scalatest.events.Formatter;
import org.scalatest.events.IndentedText;
import org.scalatest.events.MotionToSuppress$;
import org.scalatest.events.TestFailed$;
import org.scalatest.events.TestIgnored$;
import org.scalatest.events.TestStarting$;
import org.scalatest.events.TestSucceeded$;
import org.scalatest.exceptions.PayloadField;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001}4Q!\u0001\u0002\u0001\u0005!\u0011Q\"T=Sk:d\u0015n\u001d;f]\u0016\u0014(BA\u0002\u0005\u0003\u0015QWO\\5u\u0015\t)a!A\u0005tG\u0006d\u0017\r^3ti*\tq!A\u0002pe\u001e\u001c\"\u0001A\u0005\u0011\u0005)\u0001R\"A\u0006\u000b\u00051i\u0011\u0001\u00048pi&4\u0017nY1uS>t'B\u0001\b\u0010\u0003\u0019\u0011XO\u001c8fe*\u00111AB\u0005\u0003#-\u00111BU;o\u0019&\u001cH/\u001a8fe\"A1\u0003\u0001B\u0001B\u0003%Q#\u0001\u0004sKB|'\u000f^\u0002\u0001!\t1r#D\u0001\u0005\u0013\tABA\u0001\u0005SKB|'\u000f^3s\u0011!Q\u0002A!A!\u0002\u0013Y\u0012AB2p]\u001aLw\r\u0005\u0003\u001dE\u0015BcBA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\u0012A\u0002)sK\u0012,g-\u0003\u0002$I\t\u0019Q*\u00199\u000b\u0005\u0005r\u0002C\u0001\u000f'\u0013\t9CE\u0001\u0004TiJLgn\u001a\t\u0003;%J!A\u000b\u0010\u0003\u0007\u0005s\u0017\u0010\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0003)!\b.\u001a+sC\u000e\\WM\u001d\t\u0003-9J!a\f\u0003\u0003\u000fQ\u0013\u0018mY6fe\")\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"BaM\u001b7oA\u0011A\u0007A\u0007\u0002\u0005!)1\u0003\ra\u0001+!)!\u0004\ra\u00017!)A\u0006\ra\u0001[!9\u0011\b\u0001b\u0001\n\u0003Q\u0014a\u00034bS2,G\rV3tiN,\u0012a\u000f\t\u0004y\u0005+S\"A\u001f\u000b\u0005yz\u0014\u0001B;uS2T\u0011\u0001Q\u0001\u0005U\u00064\u0018-\u0003\u0002C{\t\u00191+\u001a;\t\r\u0011\u0003\u0001\u0015!\u0003<\u000311\u0017-\u001b7fIR+7\u000f^:!\u0011\u00151\u0005\u0001\"\u0011H\u0003-!Xm\u001d;GC&dWO]3\u0015\u0005![\u0005CA\u000fJ\u0013\tQeD\u0001\u0003V]&$\b\"\u0002'F\u0001\u0004i\u0015a\u00024bS2,(/\u001a\t\u0003\u00159K!aT\u0006\u0003\u000f\u0019\u000b\u0017\u000e\\;sK\")\u0011\u000b\u0001C!%\u0006aA/Z:u\r&t\u0017n\u001d5fIR\u0011\u0001j\u0015\u0005\u0006)B\u0003\r!V\u0001\fI\u0016\u001c8M]5qi&|g\u000e\u0005\u0002W/6\tQ\"\u0003\u0002Y\u001b\tYA)Z:de&\u0004H/[8o\u0011\u0015Q\u0006\u0001\"\u0011\\\u0003-!Xm\u001d;JO:|'/\u001a3\u0015\u0005!c\u0006\"\u0002+Z\u0001\u0004)\u0006\"\u00020\u0001\t\u0003z\u0016a\u0004;fgR\u0014VO\u001c$j]&\u001c\b.\u001a3\u0015\u0005!\u0003\u0007\"B1^\u0001\u0004\u0011\u0017A\u0002:fgVdG\u000f\u0005\u0002WG&\u0011A-\u0004\u0002\u0007%\u0016\u001cX\u000f\u001c;\t\u000b\u0019\u0004A\u0011I4\u0002\u001dQ,7\u000f\u001e*v]N#\u0018M\u001d;fIR\u0011\u0001\n\u001b\u0005\u0006)\u0016\u0004\r!\u0016\u0005\u0006U\u0002!\te[\u0001\fi\u0016\u001cHo\u0015;beR,G\r\u0006\u0002IY\")A+\u001ba\u0001+\"9a\u000e\u0001b\u0001\n\u0003y\u0017\u0001\u0007+F'R{F)R*D%&\u0003F+S(O?B\u000bE\u000bV#S\u001dV\t\u0001\u000f\u0005\u0002ri6\t!O\u0003\u0002t{\u0005)!/Z4fq&\u0011QO\u001d\u0002\b!\u0006$H/\u001a:o\u0011\u00199\b\u0001)A\u0005a\u0006IB+R*U?\u0012+5k\u0011*J!RKuJT0Q\u0003R#VI\u0015(!\u0011\u0015I\b\u0001\"\u0003{\u0003Q\u0001\u0018M]:f)\u0016\u001cH\u000fR3tGJL\u0007\u000f^5p]R\u00111P \t\u0006;q,S%J\u0005\u0003{z\u0011a\u0001V;qY\u0016\u001c\u0004\"\u0002+y\u0001\u0004)\u0006")
public class MyRunListener
extends RunListener {
    private final Reporter report;
    private final Tracker theTracker;
    private final Set<String> failedTests;
    private final Pattern TEST_DESCRIPTION_PATTERN;

    public Set<String> failedTests() {
        return this.failedTests;
    }

    public void testFailure(Failure failure) {
        this.failedTests().add(failure.getDescription().getDisplayName());
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(failure.getDescription());
        if (tuple3 != null) {
            Option<Object> option;
            Tuple3 tuple32;
            String testName = (String)tuple3._1();
            String testClass = (String)tuple3._2();
            String testClassName = (String)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
            String testName2 = (String)tuple33._1();
            String testClass2 = (String)tuple33._2();
            String testClassName2 = (String)tuple33._3();
            Throwable throwableOrNull = failure.getException();
            None$ throwable = throwableOrNull == null ? None$.MODULE$ : new Some((Object)throwableOrNull);
            String message = throwableOrNull == null ? Resources$.MODULE$.apply("jUnitTestFailed") : throwableOrNull.toString();
            IndentedText formatter = Suite$.MODULE$.getIndentedText(testName2, 1, true);
            None$ none$ = throwable;
            if (none$ instanceof PayloadField) {
                None$ none$2 = none$;
                option = ((PayloadField)none$2).payload();
            } else {
                option = None$.MODULE$;
            }
            Option<Object> payload = option;
            this.report.apply(TestFailed$.MODULE$.apply(this.theTracker.nextOrdinal(), message, testClassName2, (Option<String>)new Some((Object)testClass2), testName2, (Option<Throwable>)throwable, (Option<Object>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Rerunner>)None$.MODULE$, payload));
            return;
        }
        throw new MatchError(tuple3);
    }

    public void testFinished(Description description) {
        Tuple3<String, String, String> tuple3;
        block3: {
            block2: {
                Tuple3 tuple32;
                if (this.failedTests().contains(description.getDisplayName())) break block2;
                tuple3 = this.parseTestDescription(description);
                if (tuple3 == null) break block3;
                String testName = (String)tuple3._1();
                String testClass = (String)tuple3._2();
                String testClassName = (String)tuple3._3();
                Tuple3 tuple33 = tuple32 = new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
                String testName2 = (String)tuple33._1();
                String testClass2 = (String)tuple33._2();
                String testClassName2 = (String)tuple33._3();
                IndentedText formatter = Suite$.MODULE$.getIndentedText(testName2, 1, true);
                this.report.apply(TestSucceeded$.MODULE$.apply(this.theTracker.nextOrdinal(), testClassName2, (Option<String>)new Some((Object)testClass2), testName2, (Option<Object>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Rerunner>)None$.MODULE$));
            }
            return;
        }
        throw new MatchError(tuple3);
    }

    public void testIgnored(Description description) {
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
        if (tuple3 != null) {
            Tuple3 tuple32;
            String testName = (String)tuple3._1();
            String testClass = (String)tuple3._2();
            String testClassName = (String)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
            String testName2 = (String)tuple33._1();
            String testClass2 = (String)tuple33._2();
            String testClassName2 = (String)tuple33._3();
            String testSucceededIcon = Resources$.MODULE$.apply("testSucceededIconChar");
            String formattedText = Resources$.MODULE$.apply("iconPlusShortName", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{testSucceededIcon, testName2}));
            this.report.apply(TestIgnored$.MODULE$.apply(this.theTracker.nextOrdinal(), testClassName2, (Option<String>)new Some((Object)testClass2), testName2, (Option<Formatter>)new Some((Object)new IndentedText(formattedText, testName2, 1))));
            return;
        }
        throw new MatchError(tuple3);
    }

    public void testRunFinished(Result result) {
    }

    public void testRunStarted(Description description) {
    }

    public void testStarted(Description description) {
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
        if (tuple3 != null) {
            Tuple3 tuple32;
            String testName = (String)tuple3._1();
            String testClass = (String)tuple3._2();
            String testClassName = (String)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
            String testName2 = (String)tuple33._1();
            String testClass2 = (String)tuple33._2();
            String testClassName2 = (String)tuple33._3();
            this.report.apply(TestStarting$.MODULE$.apply(this.theTracker.nextOrdinal(), testClassName2, (Option<String>)new Some((Object)testClass2), testName2, (Option<Formatter>)new Some((Object)MotionToSuppress$.MODULE$), (Option<Rerunner>)None$.MODULE$));
            return;
        }
        throw new MatchError(tuple3);
    }

    public Pattern TEST_DESCRIPTION_PATTERN() {
        return this.TEST_DESCRIPTION_PATTERN;
    }

    private Tuple3<String, String, String> parseTestDescription(Description description) {
        Matcher matcher = this.TEST_DESCRIPTION_PATTERN().matcher(description.getDisplayName());
        if (matcher.find()) {
            String testName = matcher.group(1);
            String testClass = matcher.group(2);
            String testClassName = testClass.replaceAll(".*\\.", "");
            return new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
        }
        throw new RuntimeException(new StringBuilder().append((Object)"unexpected displayName [").append((Object)description.getDisplayName()).append((Object)"]").toString());
    }

    public MyRunListener(Reporter report, Map<String, Object> config, Tracker theTracker) {
        this.report = report;
        this.theTracker = theTracker;
        this.failedTests = Collections.synchronizedSet(new HashSet());
        this.TEST_DESCRIPTION_PATTERN = Pattern.compile("^(.*)\\((.*)\\)");
    }
}

