/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.caching;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.ConcurrentHashMap;
import sbt.internal.inc.EmptyStamp$;
import sbt.internal.inc.Stamper$;
import sbt.io.IO$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.mutable.ParArray$;
import scala.collection.parallel.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import xsbti.compile.FileHash;
import xsbti.compile.analysis.Stamp;

public final class ClasspathCache$ {
    public static ClasspathCache$ MODULE$;
    private final boolean jdkTimestamps;
    private final ConcurrentHashMap<Path, Tuple2<Tuple2<FileTime, Object>, FileHash>> cacheMetadataJar;
    private final int emptyStampCode;

    static {
        new ClasspathCache$();
    }

    private boolean jdkTimestamps() {
        return this.jdkTimestamps;
    }

    private FileHash emptyFileHash(Path file) {
        return FileHash.of((Path)file, (int)this.emptyStampCode);
    }

    private FileHash genFileHash(Path file, Tuple2<FileTime, Object> metadata) {
        FileHash newHash = FileHash.of((Path)file, (int)((Stamp)Stamper$.MODULE$.forFarmHashP().apply((Object)file)).getValueId());
        this.cacheMetadataJar.put(file, (Tuple2<Tuple2<FileTime, Object>, FileHash>)new Tuple2(metadata, (Object)newHash));
        return newHash;
    }

    public FileHash[] hashClasspath(Seq<Path> classpath) {
        return (FileHash[])((ParIterableLike)package$.MODULE$.CollectionsHaveToParArray(classpath, (Function1)Predef$.MODULE$.$conforms()).toParArray().map((Function1 & Serializable & scala.Serializable)file -> this.fromCacheOrHash$1((Path)file), (CanBuildFrom)ParArray$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FileHash.class));
    }

    private static final /* synthetic */ boolean liftedTree1$1(String x1$1) {
        boolean bl;
        try {
            bl = new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x1$1.split("\\."))).last())).toInt() >= 10;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    private final FileHash fromCacheOrHash$1(Path file) {
        FileHash fileHash;
        block5: {
            try {
                Some some;
                Tuple2 tuple2;
                BasicFileAttributes attrs = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                if (attrs.isDirectory()) {
                    fileHash = this.emptyFileHash(file);
                    break block5;
                }
                FileTime lastModified = this.jdkTimestamps() ? attrs.lastModifiedTime() : FileTime.fromMillis(IO$.MODULE$.getModifiedTimeOrZero(file.toFile()));
                Tuple2 currentMetadata = new Tuple2((Object)lastModified, (Object)BoxesRunTime.boxToLong((long)attrs.size()));
                Option option = Option$.MODULE$.apply(this.cacheMetadataJar.get(file));
                if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                    Tuple2 metadata = (Tuple2)tuple2._1();
                    FileHash hashHit = (FileHash)tuple2._2();
                    Tuple2 tuple22 = metadata;
                    Tuple2 tuple23 = currentMetadata;
                    if (!(tuple22 != null ? !tuple22.equals(tuple23) : tuple23 != null)) {
                        fileHash = hashHit;
                        break block5;
                    }
                }
                fileHash = this.genFileHash(file, (Tuple2<FileTime, Object>)currentMetadata);
            }
            catch (NoSuchFileException noSuchFileException) {
                fileHash = this.emptyFileHash(file);
            }
        }
        return fileHash;
    }

    private ClasspathCache$() {
        boolean bl;
        MODULE$ = this;
        String string = System.getProperty("sbt.io.jdktimestamps");
        if (string == null) {
            String string2 = System.getProperty("java.specification.version");
            bl = string2 == null ? false : ClasspathCache$.liftedTree1$1(string2);
        } else {
            String string3 = string.toLowerCase();
            String string4 = "false";
            bl = string3 == null ? string4 != null : !string3.equals(string4);
        }
        this.jdkTimestamps = bl;
        this.cacheMetadataJar = new ConcurrentHashMap();
        this.emptyStampCode = EmptyStamp$.MODULE$.hashCode();
    }
}

