/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.unsafe;

import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.scalanative.meta.LinktimeInfo$;
import scala.scalanative.runtime.LongArray;
import scala.scalanative.runtime.Platform$;
import scala.scalanative.runtime.PlatformExt$;
import scala.scalanative.runtime.RawPtr;
import scala.scalanative.runtime.libc$;
import scala.scalanative.unsafe.CStruct4;
import scala.scalanative.unsafe.CStruct5;
import scala.scalanative.unsafe.CVarArg;
import scala.scalanative.unsafe.CVarArg$;
import scala.scalanative.unsafe.CVarArgList;
import scala.scalanative.unsafe.CVarArgList$CVaListOps$;
import scala.scalanative.unsafe.CVarArgList$HeaderOps$;
import scala.scalanative.unsafe.Ptr;
import scala.scalanative.unsafe.Tag;
import scala.scalanative.unsafe.Tag$;
import scala.scalanative.unsafe.Tag$Double$;
import scala.scalanative.unsafe.Tag$Float$;
import scala.scalanative.unsafe.Zone;
import scala.scalanative.unsafe.package$;
import scala.scalanative.unsigned.UByte;
import scala.scalanative.unsigned.UInt;
import scala.scalanative.unsigned.ULong;
import scala.scalanative.unsigned.UShort;
import scala.scalanative.unsigned.package$UnsignedRichInt$;

public final class CVarArgList$ {
    public static CVarArgList$ MODULE$;
    private final boolean isWindowsOrMac;
    private final int countGPRegisters;
    private final int fpRegisterWords;
    private final int registerSaveWords;

    static {
        new CVarArgList$();
    }

    private Ptr<CStruct4<UInt, UInt, Ptr<Object>, Ptr<Object>>> HeaderOps(Ptr<CStruct4<UInt, UInt, Ptr<Object>, Ptr<Object>>> ptr) {
        return ptr;
    }

    private Ptr<CStruct5<Ptr<Object>, Ptr<Object>, Ptr<Object>, Object, Object>> CVaListOps(Ptr<CStruct5<Ptr<Object>, Ptr<Object>, Ptr<Object>, Object, Object>> ptr) {
        return ptr;
    }

    public boolean isWindowsOrMac() {
        return this.isWindowsOrMac;
    }

    private final int countGPRegisters() {
        return this.countGPRegisters;
    }

    private final int countFPRegisters() {
        return 8;
    }

    private final int fpRegisterWords() {
        return this.fpRegisterWords;
    }

    private final int registerSaveWords() {
        return this.registerSaveWords;
    }

    public CVarArgList fromSeq(Seq<CVarArg> varargs, Zone z) {
        if (LinktimeInfo$.MODULE$.isWindows()) {
            return this.toCVarArgList_X86_64_Windows(varargs, z);
        }
        if (PlatformExt$.MODULE$.isArm64() && Platform$.MODULE$.isMac()) {
            return this.toCVarArgList_Arm64_MacOS(varargs, z);
        }
        return this.toCVarArgList_Unix(varargs, z);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPassedAsDouble(CVarArg vararg) {
        Tag<Object> tag = vararg.tag();
        Tag$Float$ tag$Float$ = Tag$Float$.MODULE$;
        if (tag == null) {
            if (tag$Float$ == null) return true;
        } else if (tag.equals(tag$Float$)) return true;
        Tag<Object> tag2 = vararg.tag();
        Tag$Double$ tag$Double$ = Tag$Double$.MODULE$;
        if (tag2 != null) {
            if (!tag2.equals(tag$Double$)) return false;
            return true;
        }
        if (tag$Double$ == null) return true;
        return false;
    }

    private <T> long[] encode(T value, Tag<T> tag) {
        while (true) {
            T t;
            if ((t = value) instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte(t);
                tag = Tag$.MODULE$.materializeLongTag();
                value = BoxesRunTime.boxToLong((long)by);
                continue;
            }
            if (t instanceof Short) {
                short s = BoxesRunTime.unboxToShort(t);
                tag = Tag$.MODULE$.materializeLongTag();
                value = BoxesRunTime.boxToLong((long)s);
                continue;
            }
            if (t instanceof Integer) {
                int n = BoxesRunTime.unboxToInt(t);
                tag = Tag$.MODULE$.materializeLongTag();
                value = BoxesRunTime.boxToLong((long)n);
                continue;
            }
            if (t instanceof UByte) {
                UByte uByte = (UByte)t;
                tag = Tag$.MODULE$.materializeULongTag();
                value = uByte.toULong();
                continue;
            }
            if (t instanceof UShort) {
                UShort uShort = (UShort)t;
                tag = Tag$.MODULE$.materializeULongTag();
                value = uShort.toULong();
                continue;
            }
            if (t instanceof UInt) {
                UInt uInt = (UInt)t;
                tag = Tag$.MODULE$.materializeULongTag();
                value = uInt.toULong();
                continue;
            }
            if (!(t instanceof Float)) break;
            float f = BoxesRunTime.unboxToFloat(t);
            tag = Tag$.MODULE$.materializeDoubleTag();
            value = BoxesRunTime.boxToDouble((double)f);
        }
        int count = package$.MODULE$.sizeof(tag).$plus(package$.MODULE$.sizeof(Tag$.MODULE$.materializeLongTag())).$minus(package$UnsignedRichInt$.MODULE$.toULong$extension(scala.scalanative.unsigned.package$.MODULE$.UnsignedRichInt(1))).$div(package$.MODULE$.sizeof(Tag$.MODULE$.materializeLongTag())).toInt();
        long[] words = new long[count];
        Ptr start = ((LongArray)words).at(0);
        tag.store(start, value);
        return words;
    }

    private CVarArgList toCVarArgList_Unix(Seq<CVarArg> varargs, Zone z) {
        RawPtr rawPtr;
        ObjectRef storage = ObjectRef.create((Object)new long[this.registerSaveWords()]);
        IntRef wordsUsed = IntRef.create((int)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])storage.elem)).size());
        IntRef gpRegistersUsed = IntRef.create((int)0);
        IntRef fpRegistersUsed = IntRef.create((int)0);
        varargs.foreach((Function1 & java.io.Serializable & Serializable)vararg -> {
            CVarArgList$.$anonfun$toCVarArgList_Unix$1(fpRegistersUsed, storage, gpRegistersUsed, wordsUsed, vararg);
            return BoxedUnit.UNIT;
        });
        Ptr<Object> resultStorage = z.alloc(package$.MODULE$.sizeof(Tag$.MODULE$.materializeLongTag()).$times(package$UnsignedRichInt$.MODULE$.toULong$extension(scala.scalanative.unsigned.package$.MODULE$.UnsignedRichInt(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])storage.elem)).size()))));
        Ptr storageStart = ((LongArray)((long[])storage.elem)).at(0);
        libc$.MODULE$.memcpy(scala.scalanative.runtime.package$.MODULE$.toRawPtr(resultStorage), scala.scalanative.runtime.package$.MODULE$.toRawPtr(storageStart), package$UnsignedRichInt$.MODULE$.toULong$extension(scala.scalanative.unsigned.package$.MODULE$.UnsignedRichInt(wordsUsed.elem)).$times(package$.MODULE$.sizeof(Tag$.MODULE$.materializeLongTag())));
        if (PlatformExt$.MODULE$.isArm64()) {
            if (Platform$.MODULE$.isMac()) {
                rawPtr = scala.scalanative.runtime.package$.MODULE$.toRawPtr(storageStart);
            } else {
                Ptr<Object> vrTop = resultStorage.$plus(this.fpRegisterWords() * 8, Tag$.MODULE$.materializeLongTag());
                Ptr<Object> grTop = vrTop.$plus(this.countGPRegisters(), Tag$.MODULE$.materializeLongTag());
                Ptr<Object> va = z.alloc(package$.MODULE$.sizeof(Tag$.MODULE$.materializeCStruct5Tag(Tag$.MODULE$.materializePtrTag(Tag$.MODULE$.materializeLongTag()), Tag$.MODULE$.materializePtrTag(Tag$.MODULE$.materializeLongTag()), Tag$.MODULE$.materializePtrTag(Tag$.MODULE$.materializeLongTag()), Tag$.MODULE$.materializeIntTag(), Tag$.MODULE$.materializeIntTag())));
                CVarArgList$CVaListOps$.MODULE$.stack_$eq$extension(this.CVaListOps(va), grTop);
                CVarArgList$CVaListOps$.MODULE$.grTop_$eq$extension(this.CVaListOps(va), grTop);
                CVarArgList$CVaListOps$.MODULE$.vrTop_$eq$extension(this.CVaListOps(va), vrTop);
                CVarArgList$CVaListOps$.MODULE$.grOffset_$eq$extension(this.CVaListOps(va), -64);
                CVarArgList$CVaListOps$.MODULE$.vrOffset_$eq$extension(this.CVaListOps(va), -128);
                rawPtr = scala.scalanative.runtime.package$.MODULE$.toRawPtr(va);
            }
        } else {
            Ptr<Object> resultHeader = z.alloc(package$.MODULE$.sizeof(Tag$.MODULE$.materializeCStruct4Tag(Tag$.MODULE$.materializeUIntTag(), Tag$.MODULE$.materializeUIntTag(), Tag$.MODULE$.materializePtrTag(Tag$.MODULE$.materializeLongTag()), Tag$.MODULE$.materializePtrTag(Tag$.MODULE$.materializeLongTag()))));
            CVarArgList$HeaderOps$.MODULE$.gpOffset_$eq$extension(this.HeaderOps(resultHeader), package$UnsignedRichInt$.MODULE$.toUInt$extension(scala.scalanative.unsigned.package$.MODULE$.UnsignedRichInt(0)));
            CVarArgList$HeaderOps$.MODULE$.fpOffset_$eq$extension(this.HeaderOps(resultHeader), package$UnsignedRichInt$.MODULE$.toULong$extension(scala.scalanative.unsigned.package$.MODULE$.UnsignedRichInt(this.countGPRegisters())).$times(package$.MODULE$.sizeof(Tag$.MODULE$.materializeLongTag())).toUInt());
            CVarArgList$HeaderOps$.MODULE$.regSaveArea_$eq$extension(this.HeaderOps(resultHeader), resultStorage);
            CVarArgList$HeaderOps$.MODULE$.overflowArgArea_$eq$extension(this.HeaderOps(resultHeader), resultStorage.$plus(this.registerSaveWords(), Tag$.MODULE$.materializeLongTag()));
            rawPtr = scala.scalanative.runtime.package$.MODULE$.toRawPtr(resultHeader);
        }
        RawPtr rawPtr2 = rawPtr;
        return new CVarArgList(rawPtr2);
    }

    private CVarArgList toCVarArgList_X86_64_Windows(Seq<CVarArg> varargs, Zone z) {
        ObjectRef storage = ObjectRef.create(null);
        IntRef count = IntRef.create((int)0);
        IntRef allocated = IntRef.create((int)0);
        varargs.foreach((Function1 & java.io.Serializable & Serializable)vararg -> {
            CVarArgList$.$anonfun$toCVarArgList_X86_64_Windows$1(count, allocated, storage, vararg);
            return BoxedUnit.UNIT;
        });
        RawPtr resultStorage = scala.scalanative.runtime.package$.MODULE$.toRawPtr(z.alloc(package$UnsignedRichInt$.MODULE$.toUInt$extension(scala.scalanative.unsigned.package$.MODULE$.UnsignedRichInt(count.elem)).$times(package$.MODULE$.sizeof(Tag$.MODULE$.materializeLongTag()))));
        libc$.MODULE$.memcpy(resultStorage, scala.scalanative.runtime.package$.MODULE$.toRawPtr((Ptr)storage.elem), package$UnsignedRichInt$.MODULE$.toUInt$extension(scala.scalanative.unsigned.package$.MODULE$.UnsignedRichInt(count.elem)).$times(package$.MODULE$.sizeof(Tag$.MODULE$.materializeLongTag())));
        libc$.MODULE$.free(scala.scalanative.runtime.package$.MODULE$.toRawPtr((Ptr)storage.elem));
        return new CVarArgList(resultStorage);
    }

    private CVarArgList toCVarArgList_Arm64_MacOS(Seq<CVarArg> varargs, Zone z) {
        Seq alignedArgs = (Seq)varargs.map((Function1 & java.io.Serializable & Serializable)arg -> {
            Object object = arg.value();
            if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                return CVarArg$.MODULE$.materialize(BoxesRunTime.boxToLong((long)by), Tag$.MODULE$.materializeLongTag());
            }
            if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                return CVarArg$.MODULE$.materialize(BoxesRunTime.boxToLong((long)s), Tag$.MODULE$.materializeLongTag());
            }
            if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                return CVarArg$.MODULE$.materialize(BoxesRunTime.boxToLong((long)n), Tag$.MODULE$.materializeLongTag());
            }
            if (object instanceof UByte) {
                UByte uByte = (UByte)object;
                return CVarArg$.MODULE$.materialize(uByte.toULong(), Tag$.MODULE$.materializeULongTag());
            }
            if (object instanceof UShort) {
                UShort uShort = (UShort)object;
                return CVarArg$.MODULE$.materialize(uShort.toULong(), Tag$.MODULE$.materializeULongTag());
            }
            if (object instanceof UInt) {
                UInt uInt = (UInt)object;
                return CVarArg$.MODULE$.materialize(uInt.toULong(), Tag$.MODULE$.materializeULongTag());
            }
            if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                return CVarArg$.MODULE$.materialize(BoxesRunTime.boxToDouble((double)f), Tag$.MODULE$.materializeDoubleTag());
            }
            return arg;
        }, Seq$.MODULE$.canBuildFrom());
        ObjectRef totalSize = ObjectRef.create((Object)package$UnsignedRichInt$.MODULE$.toULong$extension(scala.scalanative.unsigned.package$.MODULE$.UnsignedRichInt(0)));
        alignedArgs.foreach((Function1 & java.io.Serializable & Serializable)vararg -> {
            CVarArgList$.$anonfun$toCVarArgList_Arm64_MacOS$2(totalSize, vararg);
            return BoxedUnit.UNIT;
        });
        Ptr<Object> argListStorage = z.alloc((ULong)totalSize.elem);
        ObjectRef currentIndex = ObjectRef.create((Object)package$UnsignedRichInt$.MODULE$.toULong$extension(scala.scalanative.unsigned.package$.MODULE$.UnsignedRichInt(0)));
        alignedArgs.foreach((Function1 & java.io.Serializable & Serializable)vararg -> {
            CVarArgList$.$anonfun$toCVarArgList_Arm64_MacOS$3(currentIndex, argListStorage, vararg);
            return BoxedUnit.UNIT;
        });
        return new CVarArgList(scala.scalanative.runtime.package$.MODULE$.toRawPtr(argListStorage));
    }

    private static final void appendWord$1(long word, IntRef wordsUsed$1, ObjectRef storage$1) {
        if (wordsUsed$1.elem == new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])storage$1.elem)).size()) {
            long[] newstorage = new long[new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])storage$1.elem)).size() * 2];
            System.arraycopy((long[])storage$1.elem, 0, newstorage, 0, new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])storage$1.elem)).size());
            storage$1.elem = newstorage;
        }
        ((long[])storage$1.elem)[wordsUsed$1.elem] = word;
        ++wordsUsed$1.elem;
    }

    public static final /* synthetic */ void $anonfun$toCVarArgList_Unix$1(IntRef fpRegistersUsed$1, ObjectRef storage$1, IntRef gpRegistersUsed$1, IntRef wordsUsed$1, CVarArg vararg) {
        long[] encoded = MODULE$.encode(vararg.value(), vararg.tag());
        boolean isDouble = MODULE$.isPassedAsDouble(vararg);
        if (isDouble && fpRegistersUsed$1.elem < 8) {
            int fpRegistersSize = fpRegistersUsed$1.elem * MODULE$.fpRegisterWords();
            IntRef startIndex = IntRef.create((int)(PlatformExt$.MODULE$.isArm64() ? fpRegistersSize : MODULE$.countGPRegisters() + fpRegistersSize));
            new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(encoded)).foreach((Function1)(JFunction1.mcVJ.sp & java.io.Serializable & Serializable)w -> {
                ((long[])storage$1.elem)[startIndex$1.elem] = w;
                ++startIndex$1.elem;
            });
            ++fpRegistersUsed$1.elem;
            return;
        }
        if (new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(encoded)).size() == 1 && !isDouble && gpRegistersUsed$1.elem < MODULE$.countGPRegisters()) {
            int startIndex = PlatformExt$.MODULE$.isArm64() ? MODULE$.fpRegisterWords() * 8 + gpRegistersUsed$1.elem : gpRegistersUsed$1.elem;
            ((long[])storage$1.elem)[startIndex] = encoded[0];
            ++gpRegistersUsed$1.elem;
            return;
        }
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(encoded)).foreach((Function1)(JFunction1.mcVJ.sp & java.io.Serializable & Serializable)word -> CVarArgList$.appendWord$1(word, wordsUsed$1, storage$1));
    }

    public static final /* synthetic */ void $anonfun$toCVarArgList_X86_64_Windows$1(IntRef count$1, IntRef allocated$1, ObjectRef storage$2, CVarArg vararg) {
        long[] encoded = MODULE$.encode(vararg.value(), vararg.tag());
        int requiredSize = count$1.elem + new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(encoded)).size();
        if (requiredSize > allocated$1.elem) {
            allocated$1.elem = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(requiredSize), allocated$1.elem * 2);
            storage$2.elem = scala.scalanative.runtime.package$.MODULE$.fromRawPtr(libc$.MODULE$.realloc(scala.scalanative.runtime.package$.MODULE$.toRawPtr((Ptr)storage$2.elem), package$UnsignedRichInt$.MODULE$.toUInt$extension(scala.scalanative.unsigned.package$.MODULE$.UnsignedRichInt(allocated$1.elem)).$times(package$.MODULE$.sizeof(Tag$.MODULE$.materializeLongTag()))));
        }
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(encoded)).foreach((Function1)(JFunction1.mcVJ.sp & java.io.Serializable & Serializable)word -> {
            ((Ptr)storage$2.elem).$plus(count$1.elem, Tag$.MODULE$.materializeLongTag()).unary_$bang_$eq(BoxesRunTime.boxToLong((long)word), Tag$.MODULE$.materializeLongTag());
            ++count$1.elem;
        });
    }

    public static final /* synthetic */ void $anonfun$toCVarArgList_Arm64_MacOS$2(ObjectRef totalSize$1, CVarArg vararg) {
        Tag<Object> tag = vararg.tag();
        totalSize$1.elem = Tag$.MODULE$.align((ULong)totalSize$1.elem, tag.alignment()).$plus(tag.size());
    }

    public static final /* synthetic */ void $anonfun$toCVarArgList_Arm64_MacOS$3(ObjectRef currentIndex$1, Ptr argListStorage$1, CVarArg vararg) {
        Tag<Object> tag = vararg.tag();
        currentIndex$1.elem = Tag$.MODULE$.align((ULong)currentIndex$1.elem, tag.alignment());
        tag.store(argListStorage$1.$plus((ULong)currentIndex$1.elem, Tag$.MODULE$.materializeByteTag()), vararg.value());
        currentIndex$1.elem = ((ULong)currentIndex$1.elem).$plus(tag.size());
    }

    private CVarArgList$() {
        MODULE$ = this;
        this.isWindowsOrMac = Platform$.MODULE$.isWindows() || Platform$.MODULE$.isMac();
        this.countGPRegisters = PlatformExt$.MODULE$.isArm64() && !this.isWindowsOrMac() ? 8 : 6;
        this.fpRegisterWords = PlatformExt$.MODULE$.isArm64() && !this.isWindowsOrMac() ? 16 / package$.MODULE$.sizeof(Tag$.MODULE$.materializeLongTag()).toInt() : 2;
        this.registerSaveWords = this.countGPRegisters() + 8 * this.fpRegisterWords();
    }
}

