/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.runtime.ieee754tostring.ryu;

import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.scalanative.runtime.ieee754tostring.ryu.RyuRoundingMode;

public final class RyuFloat$ {
    public static RyuFloat$ MODULE$;
    private final long LOG10_2_NUMERATOR;
    private final long LOG10_5_NUMERATOR;
    private final long LOG2_5_NUMERATOR;
    private final int[] POW5_SPLIT;
    private final int[] POW5_INV_SPLIT;

    static {
        new RyuFloat$();
    }

    public final int FLOAT_MANTISSA_BITS() {
        return 23;
    }

    public final int FLOAT_MANTISSA_MASK() {
        return 0x7FFFFF;
    }

    public final int FLOAT_EXPONENT_BITS() {
        return 8;
    }

    public final int FLOAT_EXPONENT_MASK() {
        return 255;
    }

    public final int FLOAT_EXPONENT_BIAS() {
        return 127;
    }

    public final long LOG10_2_DENOMINATOR() {
        return 10000000L;
    }

    public final long LOG10_2_NUMERATOR() {
        return this.LOG10_2_NUMERATOR;
    }

    public final long LOG10_5_DENOMINATOR() {
        return 10000000L;
    }

    public final long LOG10_5_NUMERATOR() {
        return this.LOG10_5_NUMERATOR;
    }

    public final long LOG2_5_DENOMINATOR() {
        return 10000000L;
    }

    public final long LOG2_5_NUMERATOR() {
        return this.LOG2_5_NUMERATOR;
    }

    public final int POW5_BITCOUNT() {
        return 61;
    }

    public final int POW5_HALF_BITCOUNT() {
        return 31;
    }

    public final int POW5_INV_BITCOUNT() {
        return 59;
    }

    public final int POW5_INV_HALF_BITCOUNT() {
        return 31;
    }

    public final int POW5_ARRAY_NCOL() {
        return 2;
    }

    public final int[] POW5_SPLIT() {
        return this.POW5_SPLIT;
    }

    public final int[] POW5_INV_SPLIT() {
        return this.POW5_INV_SPLIT;
    }

    public String floatToString(float value, RyuRoundingMode roundingMode) {
        if (Float.isNaN(value)) {
            return "NaN";
        }
        if (value == Float.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (value == Float.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        int bits = Float.floatToIntBits(value);
        if (bits == 0) {
            return "0.0";
        }
        if (bits == Integer.MIN_VALUE) {
            return "-0.0";
        }
        int ieeeExponent = bits >> 23 & 0xFF;
        int ieeeMantissa = bits & 0x7FFFFF;
        int e2 = 0;
        int m2 = 0;
        if (ieeeExponent == 0) {
            e2 = -149;
            m2 = ieeeMantissa;
        } else {
            e2 = ieeeExponent - 127 - 23;
            m2 = ieeeMantissa | 0x800000;
        }
        boolean sign = bits < 0;
        boolean even = (m2 & 1) == 0;
        int mv = 4 * m2;
        int mp = 4 * m2 + 2;
        int mm = 4 * m2 - ((long)m2 != 0x800000L || ieeeExponent <= 1 ? 2 : 1);
        e2 -= 2;
        int dp = 0;
        int dv = 0;
        int dm = 0;
        int e10 = 0;
        boolean dpIsTrailingZeros = false;
        boolean dvIsTrailingZeros = false;
        boolean dmIsTrailingZeros = false;
        int lastRemovedDigit = 0;
        if (e2 >= 0) {
            int q = (int)((long)e2 * this.LOG10_2_NUMERATOR() / 10000000L);
            int k = 59 + this.pow5bits(q) - 1;
            int i2 = -e2 + q + k;
            dv = (int)this.mulPow5InvDivPow2(mv, q, i2);
            dp = (int)this.mulPow5InvDivPow2(mp, q, i2);
            dm = (int)this.mulPow5InvDivPow2(mm, q, i2);
            if (q != 0 && (dp - 1) / 10 <= dm / 10) {
                int l = 59 + this.pow5bits(q - 1) - 1;
                lastRemovedDigit = (int)(this.mulPow5InvDivPow2(mv, q - 1, -e2 + q - 1 + l) % 10L);
            }
            e10 = q;
            dpIsTrailingZeros = this.pow5Factor(mp) >= q;
            dvIsTrailingZeros = this.pow5Factor(mv) >= q;
            dmIsTrailingZeros = this.pow5Factor(mm) >= q;
        } else {
            int q = (int)((long)(-e2) * this.LOG10_5_NUMERATOR() / 10000000L);
            int i3 = -e2 - q;
            int k = this.pow5bits(i3) - 61;
            int j = q - k;
            dv = (int)this.mulPow5divPow2(mv, i3, j);
            dp = (int)this.mulPow5divPow2(mp, i3, j);
            dm = (int)this.mulPow5divPow2(mm, i3, j);
            if (q != 0 && (dp - 1) / 10 <= dm / 10) {
                j = q - 1 - (this.pow5bits(i3 + 1) - 61);
                lastRemovedDigit = (int)(this.mulPow5divPow2(mv, i3 + 1, j) % 10L);
            }
            e10 = q + e2;
            dpIsTrailingZeros = 1 >= q;
            dvIsTrailingZeros = q < 23 && (mv & (1 << q - 1) - 1) == 0;
            dmIsTrailingZeros = (mm % 2 == 1 ? 0 : 1) >= q;
        }
        int dplength = this.decimalLength(dp);
        IntRef exp = IntRef.create((int)(e10 + dplength - 1));
        boolean scientificNotation = exp.elem < -3 || exp.elem >= 7;
        int removed = 0;
        if (dpIsTrailingZeros && !roundingMode.acceptUpperBound(even)) {
            --dp;
        }
        boolean done = false;
        while (dp / 10 > dm / 10 && !done) {
            if (dp < 100 && scientificNotation) {
                done = true;
                continue;
            }
            dmIsTrailingZeros &= dm % 10 == 0;
            dp /= 10;
            lastRemovedDigit = dv % 10;
            dv /= 10;
            dm /= 10;
            ++removed;
        }
        if (dmIsTrailingZeros && roundingMode.acceptLowerBound(even)) {
            boolean done2 = false;
            while (dm % 10 == 0 && !done2) {
                if (dp < 100 && scientificNotation) {
                    done2 = true;
                    continue;
                }
                dp /= 10;
                lastRemovedDigit = dv % 10;
                dv /= 10;
                dm /= 10;
                ++removed;
            }
        }
        if (dvIsTrailingZeros && lastRemovedDigit == 5 && dv % 2 == 0) {
            lastRemovedDigit = 4;
        }
        IntRef output = IntRef.create((int)(dv + (dv == dm && (!dmIsTrailingZeros || !roundingMode.acceptLowerBound(even)) || lastRemovedDigit >= 5 ? 1 : 0)));
        int olength = dplength - removed;
        char[] result = new char[15];
        IntRef index = IntRef.create((int)0);
        if (sign) {
            result[index.elem] = 45;
            ++index.elem;
        }
        if (scientificNotation) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), olength - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
                int c = output$1.elem % 10;
                output$1.elem /= 10;
                result$1[index$1.elem + olength$1 - i] = (char)(48 + c);
            });
            result[index.elem] = (char)(48 + output.elem % 10);
            result[index.elem + 1] = 46;
            index.elem += olength + 1;
            if (olength == 1) {
                result[index.elem] = 48;
                ++index.elem;
            }
            result[index.elem] = 69;
            ++index.elem;
            if (exp.elem < 0) {
                result[index.elem] = 45;
                ++index.elem;
                exp.elem = -exp.elem;
            }
            if (exp.elem >= 10) {
                result[index.elem] = (char)(48 + exp.elem / 10);
                ++index.elem;
            }
            result[index.elem] = (char)(48 + exp.elem % 10);
            ++index.elem;
        } else if (exp.elem < 0) {
            result[index.elem] = 48;
            ++index.elem;
            result[index.elem] = 46;
            ++index.elem;
            for (int i4 = -1; i4 > exp.elem; --i4) {
                result[index.elem] = 48;
                ++index.elem;
            }
            int current = index.elem;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), olength).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
                result$1[current$1 + olength$1 - i - 1] = (char)(48 + output$1.elem % 10);
                output$1.elem /= 10;
                ++index$1.elem;
            });
        } else if (exp.elem + 1 >= olength) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), olength).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
                result$1[index$1.elem + olength$1 - i - 1] = (char)(48 + output$1.elem % 10);
                output$1.elem /= 10;
            });
            index.elem += olength;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(olength), exp.elem + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
                result$1[index$1.elem] = 48;
                ++index$1.elem;
            });
            result[index.elem] = 46;
            ++index.elem;
            result[index.elem] = 48;
            ++index.elem;
        } else {
            IntRef current = IntRef.create((int)(index.elem + 1));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), olength).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
                if (olength - i - 1 == exp$1.elem) {
                    result$1[current$2.elem + olength$1 - i - 1] = 46;
                    --current$2.elem;
                }
                result$1[current$2.elem + olength$1 - i - 1] = (char)(48 + output$1.elem % 10);
                output$1.elem /= 10;
            });
            index.elem += olength + 1;
        }
        return new String(result, 0, index.elem);
    }

    private int pow5bits(int e) {
        if (e == 0) {
            return 1;
        }
        return (int)(((long)e * this.LOG2_5_NUMERATOR() + 10000000L - 1L) / 10000000L);
    }

    private int pow5Factor(int _value) {
        int value = _value;
        int count = 0;
        while (value > 0) {
            if (value % 5 != 0) {
                return count;
            }
            value /= 5;
            ++count;
        }
        throw new IllegalArgumentException(String.valueOf(BoxesRunTime.boxToInteger((int)value)));
    }

    private long mulPow5divPow2(int m, int i, int j) {
        if (j - 31 < 0) {
            throw new IllegalArgumentException();
        }
        long bits0 = (long)m * (long)this.POW5_SPLIT()[i * 2 + 0];
        long bits1 = (long)m * (long)this.POW5_SPLIT()[i * 2 + 1];
        return bits0 + (bits1 >> 31) >> j - 31;
    }

    private long mulPow5InvDivPow2(int m, int q, int j) {
        if (j - 31 < 0) {
            throw new IllegalArgumentException();
        }
        long bits0 = (long)m * (long)this.POW5_INV_SPLIT()[q * 2 + 0];
        long bits1 = (long)m * (long)this.POW5_INV_SPLIT()[q * 2 + 1];
        return bits0 + (bits1 >> 31) >> j - 31;
    }

    private int decimalLength(int v) {
        int length = 10;
        int factor = 1000000000;
        boolean done = false;
        while (length > 0 && !done) {
            if (v >= factor) {
                done = true;
                continue;
            }
            factor /= 10;
            --length;
        }
        return length;
    }

    private RyuFloat$() {
        MODULE$ = this;
        this.LOG10_2_NUMERATOR = (long)((double)10000000L * Math.log10(2.0));
        this.LOG10_5_NUMERATOR = (long)((double)10000000L * Math.log10(5.0));
        this.LOG2_5_NUMERATOR = (long)((double)10000000L * (Math.log(5.0) / Math.log(2.0)));
        this.POW5_SPLIT = new int[]{0x20000000, 0, 0x28000000, 0, 0x32000000, 0, 1048576000, 0, 655360000, 0, 819200000, 0, 1024000000, 0, 640000000, 0, 800000000, 0, 1000000000, 0, 625000000, 0, 781250000, 0, 976562500, 0, 610351562, 0x40000000, 762939453, 0x10000000, 953674316, 0x34000000, 596046447, 0x60800000, 745058059, 1486880768, 931322574, 1321730048, 582076609, 289210368, 727595761, 898383872, 909494701, 1659850752, 568434188, 1305842176, 710542735, 1632302720, 888178419, 1503507488, 555111512, 671256724, 693889390, 839070905, 867361737, 2122580455, 542101086, 521306416, 677626357, 1725374844, 847032947, 546105819, 1058791184, 145761362, 661744490, 91100851, 827180612, 1187617888, 1033975765, 1484522360, 646234853, 1196261931, 807793566, 2032198326, 1009741958, 1466506084, 631088724, 379695390, 788860905, 474619238, 986076131, 1130144959, 616297582, 437905143, 770371977, 1621123253, 962964972, 415791331, 601853107, 1333611405, 752316384, 1130143345, 940395480, 1412679181};
        this.POW5_INV_SPLIT = new int[]{0x10000000, 1, 0xCCCCCCC, 0x66666667, 171798691, 1803886265, 137438953, 1013612282, 219902325, 1192282922, 175921860, 953826338, 140737488, 763061070, 225179981, 791400982, 180143985, 203624056, 144115188, 162899245, 230584300, 1978625710, 184467440, 1582900568, 147573952, 1266320455, 236118324, 308125809, 188894659, 675997377, 151115727, 970294631, 241785163, 1981968139, 193428131, 297084323, 154742504, 1955654377, 247588007, 1840556814, 198070406, 613451992, 158456325, 61264864, 253530120, 98023782, 202824096, 78419026, 162259276, 1780722139, 259614842, 1990161963, 207691874, 733136111, 166153499, 1016005619, 265845599, 337118801, 212676479, 699191770, 170141183, 988850146};
    }
}

