/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.regex;

import scala.runtime.BoxedUnit;
import scala.scalanative.regex.Unicode$;

public final class Utils$ {
    public static Utils$ MODULE$;
    private final int[] EMPTY_INTS;
    private final String METACHARACTERS;

    static {
        new Utils$();
    }

    public final int[] EMPTY_INTS() {
        return this.EMPTY_INTS;
    }

    public boolean isalnum(int c) {
        return 48 <= c && c <= 57 || 65 <= c && c <= 90 || 97 <= c && c <= 122;
    }

    public int unhex(int c) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (97 <= c && c <= 102) {
            return c - 97 + 10;
        }
        if (65 <= c && c <= 70) {
            return c - 65 + 10;
        }
        return -1;
    }

    private final String METACHARACTERS() {
        return this.METACHARACTERS;
    }

    public void escapeRune(StringBuilder out, int rune) {
        if (Unicode$.MODULE$.isPrint(rune)) {
            Object object = this.METACHARACTERS().indexOf((char)rune) >= 0 ? out.append('\\') : BoxedUnit.UNIT;
            out.appendCodePoint(rune);
            return;
        }
        int n = rune;
        switch (n) {
            case 34: {
                out.append("\\\"");
                return;
            }
            case 92: {
                out.append("\\\\");
                return;
            }
            case 9: {
                out.append("\\t");
                return;
            }
            case 10: {
                out.append("\\n");
                return;
            }
            case 13: {
                out.append("\\r");
                return;
            }
            case 8: {
                out.append("\\b");
                return;
            }
            case 12: {
                out.append("\\f");
                return;
            }
        }
        String s = Integer.toHexString(rune);
        if (rune < 256) {
            out.append("\\x");
            Object object = s.length() == 1 ? out.append('0') : BoxedUnit.UNIT;
            out.append(s);
            return;
        }
        out.append("\\x{").append(s).append('}');
    }

    public int[] stringToRunes(String str) {
        int rune;
        int charlen = str.length();
        int runelen = str.codePointCount(0, charlen);
        int[] runes = new int[runelen];
        int r = 0;
        for (int c = 0; c < charlen; c += Character.charCount(rune)) {
            runes[r] = rune = str.codePointAt(c);
            ++r;
        }
        return runes;
    }

    public String runeToString(int r) {
        char c = (char)r;
        if (r == c) {
            return String.valueOf(c);
        }
        return new String(Character.toChars(c));
    }

    public int[] subarray(int[] array, int start, int end) {
        int[] r = new int[end - start];
        for (int i = start; i < end; ++i) {
            r[i - start] = array[i];
        }
        return r;
    }

    public byte[] subarray(byte[] array, int start, int end) {
        byte[] r = new byte[end - start];
        for (int i = start; i < end; ++i) {
            r[i - start] = array[i];
        }
        return r;
    }

    public int indexOf(byte[] source, byte[] target, int _fromIndex) {
        int fromIndex = _fromIndex;
        if (fromIndex >= source.length) {
            if (target.length == 0) {
                return source.length;
            }
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (target.length == 0) {
            return fromIndex;
        }
        byte first = target[0];
        int max = source.length - target.length;
        for (int i = fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                ++i;
                while (i <= max && source[i] != first) {
                    ++i;
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + target.length - 1;
            int k = 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public boolean isWordRune(int r) {
        return 65 <= r && r <= 90 || 97 <= r && r <= 122 || 48 <= r && r <= 57 || r == 95;
    }

    public final int EMPTY_BEGIN_LINE() {
        return 1;
    }

    public final int EMPTY_END_LINE() {
        return 2;
    }

    public final int EMPTY_BEGIN_TEXT() {
        return 4;
    }

    public final int EMPTY_END_TEXT() {
        return 8;
    }

    public final int EMPTY_WORD_BOUNDARY() {
        return 16;
    }

    public final int EMPTY_NO_WORD_BOUNDARY() {
        return 32;
    }

    public final int EMPTY_ALL() {
        return -1;
    }

    public final int emptyOpContext(int r1, int r2) {
        int op = 0;
        if (r1 < 0) {
            op |= 5;
        }
        if (r1 == 10) {
            op |= 1;
        }
        if (r2 < 0) {
            op |= 0xA;
        }
        if (r2 == 10) {
            op |= 2;
        }
        op = this.isWordRune(r1) != this.isWordRune(r2) ? (op |= 0x10) : (op |= 0x20);
        return op;
    }

    private Utils$() {
        MODULE$ = this;
        this.EMPTY_INTS = new int[0];
        this.METACHARACTERS = "\\.+*?()|[]{}^$";
    }
}

