/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.regex;

import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt;
import scala.scalanative.regex.UnicodeTables$;

public final class Unicode$ {
    public static Unicode$ MODULE$;

    static {
        new Unicode$();
    }

    public final int MAX_RUNE() {
        return 0x10FFFF;
    }

    public final int MAX_ASCII() {
        return 127;
    }

    public final int MAX_LATIN1() {
        return 255;
    }

    private final int MAX_CASE() {
        return 3;
    }

    private final int REPLACEMENT_CHAR() {
        return 65533;
    }

    public final int MIN_FOLD() {
        return 65;
    }

    public final int MAX_FOLD() {
        return 66639;
    }

    private int midpoint(int lo, int hi, int step) {
        return (lo + hi) / 2 / step * step;
    }

    private boolean is32(int[] ranges, int r) {
        int indexStep = 3;
        int lo = 0;
        int hi = ranges.length;
        boolean found = false;
        while (lo < hi) {
            int m = this.midpoint(lo, hi, indexStep);
            int rangeLow = ranges[m];
            int rangeHigh = ranges[m + 1];
            int rangeStride = ranges[m + 2];
            if (rangeLow <= r && r <= rangeHigh) {
                found = (r - rangeLow) % rangeStride == 0;
                lo = hi;
                continue;
            }
            if (r < rangeLow) {
                hi = m;
                continue;
            }
            lo = m + indexStep;
        }
        return found;
    }

    private boolean is(int[] ranges, int r) {
        if (r <= 255) {
            Predef$.MODULE$.assert(false, (Function0 & java.io.Serializable & Serializable)() -> "Bad MAX_LATIN1 guess Lee!");
        }
        return ranges.length > 0 && r >= ranges[0] && this.is32(ranges, r);
    }

    public boolean isLower(int r) {
        if (r <= 255) {
            return Character.isLowerCase((char)r);
        }
        return this.is(UnicodeTables$.MODULE$.Lower(), r);
    }

    public boolean isUpper(int r) {
        if (r <= 255) {
            return Character.isUpperCase((char)r);
        }
        return this.is(UnicodeTables$.MODULE$.Upper(), r);
    }

    public boolean isTitle(int r) {
        if (r <= 255) {
            return false;
        }
        return this.is(UnicodeTables$.MODULE$.Title(), r);
    }

    public boolean isPrint(int r) {
        if (r <= 255) {
            return r >= 32 && r < 127 || r >= 161 && r != 173;
        }
        return this.is(UnicodeTables$.MODULE$.L(), r) || this.is(UnicodeTables$.MODULE$.M(), r) || this.is(UnicodeTables$.MODULE$.N(), r) || this.is(UnicodeTables$.MODULE$.P(), r) || this.is(UnicodeTables$.MODULE$.S(), r);
    }

    private int to(int kase, int r, int[] caseRange) {
        if (kase < 0 || 3 <= kase) {
            return 65533;
        }
        int indexStep = 5;
        int lo = 0;
        int hi = caseRange.length;
        int found = -1;
        while (lo < hi) {
            int m = this.midpoint(lo, hi, indexStep);
            int crlo = caseRange[m];
            int crhi = caseRange[m + 1];
            if (crlo <= r && r <= crhi) {
                lo = hi;
                int delta = caseRange[m + 2 + kase];
                if (delta <= 0x10FFFF) {
                    found = r + delta;
                    continue;
                }
                found = crlo + (r - crlo & ~1 | kase & 1);
                continue;
            }
            if (r < crlo) {
                hi = m;
                continue;
            }
            lo = m + indexStep;
        }
        if (found >= 0) {
            return found;
        }
        return r;
    }

    private int to(int kase, int r) {
        return this.to(kase, r, UnicodeTables$.MODULE$.CASE_RANGES());
    }

    private int toUpper(int r) {
        if (r <= 127) {
            int res = r;
            if (97 <= r && r <= 122) {
                res -= 32;
            }
            return res;
        }
        return this.to(0, r);
    }

    private int toLower(int r) {
        if (r <= 127) {
            int res = r;
            if (65 <= r && r <= 90) {
                res += 32;
            }
            return res;
        }
        return this.to(1, r);
    }

    public int simpleFold(int r) {
        int l;
        int indexStep = 2;
        int lo = 0;
        int hi = UnicodeTables$.MODULE$.CASE_ORBIT().length;
        int found = -1;
        block5: while (lo < hi) {
            int m = this.midpoint(lo, hi, indexStep);
            int n = new RichInt(Predef$.MODULE$.intWrapper(r)).compare((Object)BoxesRunTime.boxToInteger((int)UnicodeTables$.MODULE$.CASE_ORBIT()[m]));
            switch (n) {
                case -1: {
                    hi = m;
                    continue block5;
                }
                case 0: {
                    found = m;
                    lo = hi;
                    continue block5;
                }
                case 1: {
                    lo = m + indexStep;
                    continue block5;
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        int result = found >= 0 ? UnicodeTables$.MODULE$.CASE_ORBIT()[found + 1] : ((l = this.toLower(r)) != r ? l : this.toUpper(r));
        return result;
    }

    private Unicode$() {
        MODULE$ = this;
    }
}

