/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.regex;

import java.util.regex.PatternSyntaxException;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.scalanative.regex.CharClass;
import scala.scalanative.regex.Parser;
import scala.scalanative.regex.Parser$Pair$;
import scala.scalanative.regex.Regexp;
import scala.scalanative.regex.Unicode$;
import scala.scalanative.regex.UnicodeTables$;
import scala.scalanative.regex.Utils$;

public final class Parser$ {
    public static Parser$ MODULE$;
    private final int[] ANY_TABLE;

    static {
        new Parser$();
    }

    private final String ERR_INTERNAL_ERROR() {
        return "regexp/syntax: internal error";
    }

    private final String ERR_INVALID_CHAR_CLASS() {
        return "Unclosed character class";
    }

    private final String ERR_INVALID_CHAR_RANGE() {
        return "Illegal character range";
    }

    private final String ERR_INVALID_ESCAPE() {
        return "Illegal/unsupported escape sequence";
    }

    private final String ERR_INVALID_NAMED_CAPTURE() {
        return "capturing group name does not start with a Latin letter";
    }

    private final String ERR_INVALID_PERL_OP() {
        return "Unknown inline modifier";
    }

    private final String ERR_INVALID_REPEAT_OP() {
        return "Invalid nested repetition operator";
    }

    private final String ERR_INVALID_REPEAT_SIZE() {
        return "Dangling meta character '*'";
    }

    private final String ERR_TRAILING_BACKSLASH() {
        return "Trailing Backslash";
    }

    private final String ERR_MISSING_REPEAT_ARGUMENT() {
        return "Dangling meta character '*'";
    }

    private final String ERR_UNCLOSED_GROUP() {
        return "Unclosed group";
    }

    private final String ERR_UNMATCHED_CLOSING_PAREN() {
        return "Unmatched closing ')'";
    }

    private final String ERR_UNKNOWN_CHARACTER_PROPERTY_NAME() {
        return "Unknown character property name";
    }

    private final String ERR_DUPLICATE_NAMED_CAPTURE() {
        return "Named capturing group";
    }

    public int scala$scalanative$regex$Parser$$minFoldRune(int _r) {
        int r = _r;
        if (r < 65 || r > 66639) {
            return r;
        }
        int min = r;
        int r0 = r;
        r = Unicode$.MODULE$.simpleFold(r);
        while (r != r0) {
            if (min > r) {
                min = r;
            }
            r = Unicode$.MODULE$.simpleFold(r);
        }
        return min;
    }

    public Regexp scala$scalanative$regex$Parser$$leadingRegexp(Regexp re) {
        Regexp sub;
        Object object = re.op() == 1 ? null : (re.op() == 17 && re.subs().length > 0 ? ((sub = re.subs()[0]).op() == 1 ? null : sub) : re);
        Regexp result = object;
        return result;
    }

    public Regexp scala$scalanative$regex$Parser$$literalRegexp(String s, int flags) {
        Regexp re = new Regexp(2);
        re.flags_$eq(flags);
        re.runes_$eq(Utils$.MODULE$.stringToRunes(s));
        return re;
    }

    public Regexp parse(String pattern, int flags) {
        return new Parser(pattern, flags).scala$scalanative$regex$Parser$$parseInternal();
    }

    public int scala$scalanative$regex$Parser$$parseRepeat(Parser.StringIterator t) {
        int result = -1;
        int max = 0;
        int min = 0;
        int StateStart = 1;
        int StateTwo = 2;
        int StateThree = 3;
        int StateFour = 4;
        int StateDone = 99;
        int state = StateStart;
        int start = t.pos();
        while (state != StateDone) {
            int n = state;
            if (StateStart == n) {
                state = StateTwo;
                int start2 = t.pos();
                if (!t.more() || !t.lookingAt('{')) {
                    state = StateDone;
                }
                continue;
            }
            if (StateTwo == n) {
                state = StateThree;
                t.skip(1);
                min = this.parseInt(t);
                if (min == -1 || !t.more()) {
                    state = StateDone;
                }
                continue;
            }
            if (StateThree == n) {
                state = StateFour;
                if (!t.lookingAt(',')) {
                    max = min;
                    continue;
                }
                t.skip(1);
                if (!t.more()) {
                    state = StateDone;
                    continue;
                }
                if (t.lookingAt('}')) {
                    max = -1;
                    continue;
                }
                max = this.parseInt(t);
                if (max == -1) {
                    state = StateDone;
                }
                continue;
            }
            if (StateFour == n) {
                state = StateDone;
                if (t.more() && t.lookingAt('}')) {
                    t.skip(1);
                    if (min < 0 || min > 1000 || max == -2 || max > 1000 || max >= 0 && min > max) {
                        throw new PatternSyntaxException("Dangling meta character '*'", t.from(start), 0);
                    }
                    result = min << 16 | max & 0xFFFF;
                }
                continue;
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return result;
    }

    public boolean scala$scalanative$regex$Parser$$isValidCaptureName(String name2) {
        int i;
        if (name2.isEmpty()) {
            return false;
        }
        for (i = 0; i < name2.length(); ++i) {
            char c = name2.charAt(i);
            if (c == '_' || Utils$.MODULE$.isalnum(c)) continue;
            i = name2.length() + 1;
        }
        return i == name2.length();
    }

    private int parseInt(Parser.StringIterator t) {
        int start = t.pos();
        int c = 0;
        while (t.more() && (c = t.peek()) >= 48 && c <= 57) {
            t.skip(1);
        }
        String n = t.from(start);
        if (n.isEmpty() || n.length() > 1 && n.charAt(0) == '0') {
            return -1;
        }
        if (n.length() > 8) {
            return -2;
        }
        return Predef$.MODULE$.Integer2int(Integer.valueOf(n, 10));
    }

    public boolean scala$scalanative$regex$Parser$$isCharClass(Regexp re) {
        return re.op() == 2 && re.runes().length == 1 || re.op() == 3 || re.op() == 4 || re.op() == 5;
    }

    private boolean matchRune(Regexp re, int r) {
        boolean bl;
        int n = re.op();
        switch (n) {
            case 2: {
                if (re.runes().length == 1 && re.runes()[0] == r) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                int len = re.runes().length;
                Predef$.MODULE$.assert(len % 2 == 0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(36).append("matchRune: runs.length ").append(len).append(" must be even").toString());
                boolean found = false;
                for (int i = 0; i < len && !found; i += 2) {
                    if (re.runes()[i] > r || r > re.runes()[i + 1]) continue;
                    found = true;
                }
                bl = found;
                break;
            }
            case 4: {
                if (r != 10) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 5: {
                bl = true;
                break;
            }
            default: {
                bl = false;
                break;
            }
        }
        boolean matched = bl;
        return matched;
    }

    public void scala$scalanative$regex$Parser$$mergeCharClass(Regexp dst, Regexp src) {
        int n = dst.op();
        switch (n) {
            case 5: {
                return;
            }
            case 4: {
                if (this.matchRune(src, 10)) {
                    dst.op_$eq(5);
                    return;
                }
                return;
            }
            case 3: {
                if (src.op() == 2) {
                    dst.runes_$eq(new CharClass(dst.runes()).appendLiteral(src.runes()[0], src.flags()).toArray());
                    return;
                }
                dst.runes_$eq(new CharClass(dst.runes()).appendClass(src.runes()).toArray());
                return;
            }
            case 2: {
                if (src.runes()[0] == dst.runes()[0] && src.flags() == dst.flags()) {
                    return;
                }
                dst.op_$eq(3);
                dst.runes_$eq(new CharClass().appendLiteral(dst.runes()[0], dst.flags()).appendLiteral(src.runes()[0], src.flags()).toArray());
                return;
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public int scala$scalanative$regex$Parser$$parseEscape(Parser.StringIterator t) {
        int c;
        int startPos = t.pos();
        t.skip(1);
        if (!t.more()) {
            throw new PatternSyntaxException("Trailing Backslash", t.str(), t.pos());
        }
        int n = c = t.pop();
        switch (n) {
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                if (!t.more() || t.peek() < 48 || t.peek() > 55) {
                    throw Parser$.invalidEscape$1(t);
                }
                int r = c - 48;
                int i = 1;
                boolean breakInner = false;
                while (i < 3 && !breakInner) {
                    if (!t.more() || t.peek() < 48 || t.peek() > 55) {
                        breakInner = true;
                        continue;
                    }
                    r = r * 8 + t.peek() - 48;
                    t.skip(1);
                    ++i;
                }
                return r;
            }
            case 48: {
                int r = c - 48;
                int i = 1;
                boolean breakInner = false;
                while (i < 3 && !breakInner) {
                    if (!t.more() || t.peek() < 48 || t.peek() > 55) {
                        breakInner = true;
                        continue;
                    }
                    r = r * 8 + t.peek() - 48;
                    t.skip(1);
                    ++i;
                }
                return r;
            }
            case 120: {
                if (!t.more()) {
                    throw Parser$.invalidEscape$1(t);
                }
                c = t.pop();
                if (c == 123) {
                    int nhex = 0;
                    int r = 0;
                    boolean breakInner = false;
                    while (!breakInner) {
                        if (!t.more()) {
                            throw Parser$.invalidEscape$1(t);
                        }
                        c = t.pop();
                        if (c == 125) {
                            breakInner = true;
                        }
                        if (breakInner) continue;
                        int v = Utils$.MODULE$.unhex(c);
                        if (v < 0) {
                            throw Parser$.invalidEscape$1(t);
                        }
                        if ((r = r * 16 + v) > 0x10FFFF) {
                            throw Parser$.invalidEscape$1(t);
                        }
                        ++nhex;
                    }
                    if (nhex == 0) {
                        throw Parser$.invalidEscape$1(t);
                    }
                    return r;
                }
                int x = Utils$.MODULE$.unhex(c);
                c = t.pop();
                int y = Utils$.MODULE$.unhex(c);
                if (x < 0 || y < 0) {
                    throw Parser$.invalidEscape$1(t);
                }
                return x * 16 + y;
            }
            case 97: {
                return 7;
            }
            case 102: {
                return 12;
            }
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 118: {
                return 11;
            }
        }
        if (!Utils$.MODULE$.isalnum(c)) {
            return c;
        }
        throw Parser$.invalidEscape$1(t);
    }

    public int scala$scalanative$regex$Parser$$parseClassChar(Parser.StringIterator t, int wholeClassPos) {
        if (!t.more()) {
            throw new PatternSyntaxException("Unclosed character class", t.str(), t.pos() - 1);
        }
        int result = t.lookingAt('\\') ? this.scala$scalanative$regex$Parser$$parseEscape(t) : t.pop();
        return result;
    }

    private int[] ANY_TABLE() {
        return this.ANY_TABLE;
    }

    public Parser.Pair<int[], int[]> scala$scalanative$regex$Parser$$unicodeTable(String name2) {
        Parser.Pair<int[], Object> result;
        block1: {
            block2: {
                block0: {
                    result = null;
                    if (!name2.equals("Any")) break block0;
                    result = Parser$Pair$.MODULE$.of(this.ANY_TABLE(), this.ANY_TABLE());
                    break block1;
                }
                int[] table = (int[])UnicodeTables$.MODULE$.CATEGORIES().getOrElse((Object)name2, (Function0 & java.io.Serializable & Serializable)() -> null);
                if (table == null) break block2;
                result = Parser$Pair$.MODULE$.of(table, UnicodeTables$.MODULE$.FOLD_CATEGORIES().getOrElse((Object)name2, (Function0 & java.io.Serializable & Serializable)() -> null));
                break block1;
            }
            int[] table = (int[])UnicodeTables$.MODULE$.SCRIPTS().getOrElse((Object)name2, (Function0 & java.io.Serializable & Serializable)() -> null);
            if (table == null) break block1;
            result = Parser$Pair$.MODULE$.of(table, UnicodeTables$.MODULE$.FOLD_SCRIPT().getOrElse((Object)name2, (Function0 & java.io.Serializable & Serializable)() -> null));
        }
        return result;
    }

    public Regexp[] subarray(Regexp[] array, int start, int end) {
        Regexp[] r = new Regexp[end - start];
        for (int i = start; i < end; ++i) {
            r[i - start] = array[i];
        }
        return r;
    }

    public int[] scala$scalanative$regex$Parser$$concatRunes(int[] x, int[] y) {
        int[] z = new int[x.length + y.length];
        System.arraycopy(x, 0, z, 0, x.length);
        System.arraycopy(y, 0, z, x.length, y.length);
        return z;
    }

    private static final Nothing$ invalidEscape$1(Parser.StringIterator t$1) {
        throw new PatternSyntaxException("Illegal/unsupported escape sequence", t$1.str(), t$1.pos() - 1);
    }

    private Parser$() {
        MODULE$ = this;
        this.ANY_TABLE = new int[]{0, 0x10FFFF, 1};
    }
}

