/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.Factory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.SortedIterableFactory;
import scala.collection.SortedOps;
import scala.collection.SortedSetFactoryDefaults;
import scala.collection.SortedSetOps;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StepperShape$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSetOps;
import scala.collection.StrictOptimizedSortedSetOps;
import scala.collection.convert.impl.AnyBinaryTreeStepper$;
import scala.collection.convert.impl.DoubleBinaryTreeStepper$;
import scala.collection.convert.impl.IntBinaryTreeStepper;
import scala.collection.convert.impl.IntBinaryTreeStepper$;
import scala.collection.convert.impl.LongBinaryTreeStepper$;
import scala.collection.generic.DefaultSerializable;
import scala.collection.mutable.AbstractSet;
import scala.collection.mutable.Builder;
import scala.collection.mutable.RedBlackTree;
import scala.collection.mutable.RedBlackTree$;
import scala.collection.mutable.RedBlackTree$Tree$;
import scala.collection.mutable.SetOps;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.TreeSet$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.Either;

public class TreeSet<A>
extends AbstractSet<A>
implements SortedSet<A>,
StrictOptimizedSortedSetOps<A, TreeSet, TreeSet<A>>,
DefaultSerializable {
    private final RedBlackTree.Tree<A, Null$> tree;
    private final Ordering<A> ordering;

    public static Factory evidenceIterableFactory(Object object) {
        return TreeSet$.MODULE$.evidenceIterableFactory(object);
    }

    public static Object fill(int n, Function0 function0, Object object) {
        return TreeSet$.MODULE$.fill(n, function0, object);
    }

    public static Object iterate(Object object, int n, Function1 function1, Object object2) {
        return TreeSet$.MODULE$.iterate(object, n, function1, object2);
    }

    public static <A> Builder<A, TreeSet<A>> newBuilder(Ordering<A> ordering) {
        return TreeSet$.MODULE$.newBuilder(ordering);
    }

    public static Object tabulate(int n, Function1 function1, Object object) {
        return TreeSet$.MODULE$.tabulate(n, function1, object);
    }

    public static Object unfold(Object object, Function1 function1, Object object2) {
        return TreeSet$.MODULE$.unfold(object, function1, object2);
    }

    public TreeSet(RedBlackTree.Tree<A, Null$> tree, Ordering<A> ordering) {
        this.tree = tree;
        this.ordering = ordering;
        SortedOps.$init$(this);
        SortedSetOps.$init$(this);
        SortedSetFactoryDefaults.$init$(this);
        scala.collection.SortedSet.$init$(this);
        SortedSet.$init$(this);
        StrictOptimizedIterableOps.$init$(this);
        StrictOptimizedSetOps.$init$(this);
        StrictOptimizedSortedSetOps.$init$(this);
        DefaultSerializable.$init$(this);
        if (ordering == null) {
            throw new NullPointerException("ordering must not be null");
        }
    }

    @Override
    public int compare(A k0, A k1) {
        return SortedOps.compare$(this, k0, k1);
    }

    @Override
    public Object range(Object from, Object until) {
        return SortedOps.range$(this, from, until);
    }

    @Override
    public final Object from(Object from) {
        return SortedOps.from$(this, from);
    }

    @Override
    public Object rangeFrom(Object from) {
        return SortedOps.rangeFrom$(this, from);
    }

    @Override
    public final Object until(Object until) {
        return SortedOps.until$(this, until);
    }

    @Override
    public Object rangeUntil(Object until) {
        return SortedOps.rangeUntil$(this, until);
    }

    @Override
    public final Object to(Object to) {
        return SortedOps.to$(this, to);
    }

    @Override
    public Iterator<A> keysIteratorFrom(A start) {
        return SortedSetOps.keysIteratorFrom$(this, start);
    }

    @Override
    public A firstKey() {
        return (A)SortedSetOps.firstKey$(this);
    }

    @Override
    public A lastKey() {
        return (A)SortedSetOps.lastKey$(this);
    }

    @Override
    public <B> A min(Ordering<B> ord) {
        return (A)SortedSetOps.min$(this, ord);
    }

    @Override
    public <B> A max(Ordering<B> ord) {
        return (A)SortedSetOps.max$(this, ord);
    }

    @Override
    public SortedSetOps rangeTo(Object to) {
        return SortedSetOps.rangeTo$(this, to);
    }

    @Override
    public scala.collection.SortedSet fromSpecific(IterableOnce coll) {
        return SortedSetFactoryDefaults.fromSpecific$(this, coll);
    }

    @Override
    public Builder<A, TreeSet<A>> newSpecificBuilder() {
        return SortedSetFactoryDefaults.newSpecificBuilder$(this);
    }

    @Override
    public scala.collection.SortedSet empty() {
        return SortedSetFactoryDefaults.empty$(this);
    }

    @Override
    public SortedSetOps.WithFilter<A, scala.collection.mutable.Set, TreeSet> withFilter(Function1<A, Object> p) {
        return SortedSetFactoryDefaults.withFilter$(this, p);
    }

    @Override
    public String stringPrefix() {
        return scala.collection.SortedSet.stringPrefix$(this);
    }

    @Override
    public boolean equals(Object that) {
        return scala.collection.SortedSet.equals$(this, that);
    }

    @Override
    public scala.collection.mutable.Set<A> unsorted() {
        return SortedSet.unsorted$(this);
    }

    @Override
    public Tuple2<TreeSet<A>, TreeSet<A>> partition(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public Tuple2<TreeSet<A>, TreeSet<A>> span(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.span$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<scala.collection.mutable.Set<A1>, scala.collection.mutable.Set<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<scala.collection.mutable.Set<A1>, scala.collection.mutable.Set<A2>, scala.collection.mutable.Set<A3>> unzip3(Function1<A, Tuple3<A1, A2, A3>> asTriple) {
        return StrictOptimizedIterableOps.unzip3$(this, asTriple);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<A, B> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedMap$(this, b, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<A, IterableOnce<B>> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatMap$(this, b, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedConcat$(this, that, b);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public final <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<A, B> pf) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedCollect$(this, b, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<A, IterableOnce<B>> toIterableOnce) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatten$(this, b, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public final <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<A, B>, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedZip$(this, that, b);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return StrictOptimizedIterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public <A1, A2> Tuple2<scala.collection.mutable.Set<A1>, scala.collection.mutable.Set<A2>> partitionMap(Function1<A, Either<A1, A2>> f) {
        return StrictOptimizedIterableOps.partitionMap$(this, f);
    }

    @Override
    public Object tapEach(Function1 f) {
        return StrictOptimizedIterableOps.tapEach$(this, f);
    }

    @Override
    public Object takeRight(int n) {
        return StrictOptimizedIterableOps.takeRight$(this, n);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    @Override
    public scala.collection.SetOps concat(IterableOnce that) {
        return StrictOptimizedSetOps.concat$(this, that);
    }

    @Override
    public scala.collection.SortedSet map(Function1 f, Ordering ev) {
        return StrictOptimizedSortedSetOps.map$(this, f, ev);
    }

    @Override
    public scala.collection.SortedSet flatMap(Function1 f, Ordering ev) {
        return StrictOptimizedSortedSetOps.flatMap$(this, f, ev);
    }

    @Override
    public scala.collection.SortedSet zip(IterableOnce that, Ordering ev) {
        return StrictOptimizedSortedSetOps.zip$(this, that, ev);
    }

    @Override
    public scala.collection.SortedSet collect(PartialFunction pf, Ordering ev) {
        return StrictOptimizedSortedSetOps.collect$(this, pf, ev);
    }

    @Override
    public Object writeReplace() {
        return DefaultSerializable.writeReplace$(this);
    }

    @Override
    public /* synthetic */ Object scala$collection$SortedSetOps$$super$min(Ordering ord) {
        return IterableOnceOps.min$(this, ord);
    }

    @Override
    public /* synthetic */ Object scala$collection$SortedSetOps$$super$max(Ordering ord) {
        return IterableOnceOps.max$(this, ord);
    }

    @Override
    public /* synthetic */ boolean scala$collection$SortedSet$$super$equals(Object that) {
        return Set.equals$(this, that);
    }

    public RedBlackTree.Tree<A, Null$> scala$collection$mutable$TreeSet$$tree() {
        return this.tree;
    }

    @Override
    public Ordering<A> ordering() {
        return this.ordering;
    }

    public TreeSet(Ordering<A> ord) {
        this(RedBlackTree$Tree$.MODULE$.empty(), ord);
    }

    @Override
    public SortedIterableFactory<TreeSet> sortedIterableFactory() {
        return TreeSet$.MODULE$;
    }

    @Override
    public Iterator<A> iterator() {
        return RedBlackTree$.MODULE$.keysIterator(this.scala$collection$mutable$TreeSet$$tree(), RedBlackTree$.MODULE$.keysIterator$default$2(), RedBlackTree$.MODULE$.keysIterator$default$3(), this.ordering());
    }

    @Override
    public Iterator<A> iteratorFrom(A start) {
        return RedBlackTree$.MODULE$.keysIterator(this.scala$collection$mutable$TreeSet$$tree(), Some$.MODULE$.apply(start), RedBlackTree$.MODULE$.keysIterator$default$3(), this.ordering());
    }

    @Override
    public <S extends Stepper<?>> S stepper(StepperShape<A, S> shape) {
        int n = shape.shape();
        IntBinaryTreeStepper<RedBlackTree.Node<A, Null$>> s = StepperShape$.MODULE$.IntShape() == n ? IntBinaryTreeStepper$.MODULE$.from(this.size(), this.scala$collection$mutable$TreeSet$$tree().root(), (Function1<RedBlackTree.Node, RedBlackTree.Node> & Serializable)_$1 -> _$1.left(), (Function1<RedBlackTree.Node, RedBlackTree.Node> & Serializable)_$2 -> _$2.right(), (Function1<RedBlackTree.Node, Integer> & Serializable)_$3 -> BoxesRunTime.unboxToInt(_$3.key())) : (StepperShape$.MODULE$.LongShape() == n ? LongBinaryTreeStepper$.MODULE$.from(this.size(), this.scala$collection$mutable$TreeSet$$tree().root(), (Function1<RedBlackTree.Node, RedBlackTree.Node> & Serializable)_$4 -> _$4.left(), (Function1<RedBlackTree.Node, RedBlackTree.Node> & Serializable)_$5 -> _$5.right(), (Function1<RedBlackTree.Node, Long> & Serializable)_$6 -> BoxesRunTime.unboxToLong(_$6.key())) : (StepperShape$.MODULE$.DoubleShape() == n ? DoubleBinaryTreeStepper$.MODULE$.from(this.size(), this.scala$collection$mutable$TreeSet$$tree().root(), (Function1<RedBlackTree.Node, RedBlackTree.Node> & Serializable)_$7 -> _$7.left(), (Function1<RedBlackTree.Node, RedBlackTree.Node> & Serializable)_$8 -> _$8.right(), (Function1<RedBlackTree.Node, Double> & Serializable)_$9 -> BoxesRunTime.unboxToDouble(_$9.key())) : shape.parUnbox(AnyBinaryTreeStepper$.MODULE$.from(this.size(), this.scala$collection$mutable$TreeSet$$tree().root(), (Function1<RedBlackTree.Node, RedBlackTree.Node> & Serializable)_$10 -> _$10.left(), (Function1<RedBlackTree.Node, RedBlackTree.Node> & Serializable)_$11 -> _$11.right(), (Function1<RedBlackTree.Node, Object> & Serializable)_$12 -> _$12.key()))));
        return (S)s;
    }

    @Override
    public TreeSet<A> addOne(A elem) {
        RedBlackTree$.MODULE$.insert(this.scala$collection$mutable$TreeSet$$tree(), elem, null, this.ordering());
        return this;
    }

    @Override
    public TreeSet<A> subtractOne(A elem) {
        RedBlackTree$.MODULE$.delete(this.scala$collection$mutable$TreeSet$$tree(), elem, this.ordering());
        return this;
    }

    @Override
    public void clear() {
        RedBlackTree$.MODULE$.clear(this.scala$collection$mutable$TreeSet$$tree());
    }

    @Override
    public boolean contains(A elem) {
        return RedBlackTree$.MODULE$.contains(this.scala$collection$mutable$TreeSet$$tree(), elem, this.ordering());
    }

    public Set<A> unconstrained() {
        return this;
    }

    @Override
    public TreeSet<A> rangeImpl(Option<A> from, Option<A> until) {
        return new TreeSetProjection(this, from, until);
    }

    @Override
    public String className() {
        return "TreeSet";
    }

    @Override
    public int size() {
        return RedBlackTree$.MODULE$.size(this.scala$collection$mutable$TreeSet$$tree());
    }

    @Override
    public int knownSize() {
        return this.size();
    }

    @Override
    public boolean isEmpty() {
        return RedBlackTree$.MODULE$.isEmpty(this.scala$collection$mutable$TreeSet$$tree());
    }

    @Override
    public A head() {
        return RedBlackTree$.MODULE$.minKey(this.scala$collection$mutable$TreeSet$$tree()).get();
    }

    @Override
    public A last() {
        return RedBlackTree$.MODULE$.maxKey(this.scala$collection$mutable$TreeSet$$tree()).get();
    }

    @Override
    public Option<A> minAfter(A key) {
        return RedBlackTree$.MODULE$.minKeyAfter(this.scala$collection$mutable$TreeSet$$tree(), key, this.ordering());
    }

    @Override
    public Option<A> maxBefore(A key) {
        return RedBlackTree$.MODULE$.maxKeyBefore(this.scala$collection$mutable$TreeSet$$tree(), key, this.ordering());
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        RedBlackTree$.MODULE$.foreachKey(this.scala$collection$mutable$TreeSet$$tree(), f);
    }

    public final class TreeSetProjection
    extends TreeSet<A> {
        private final Option<A> from;
        private final Option<A> until;
        private final /* synthetic */ TreeSet $outer;

        public TreeSetProjection(TreeSet $outer, Option<A> from, Option<A> until) {
            this.from = from;
            this.until = until;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer.scala$collection$mutable$TreeSet$$tree(), $outer.ordering());
        }

        private Option<A> pickLowerBound(Option<A> newFrom) {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.from, newFrom);
            Option option = tuple2._1();
            Option option2 = tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object fr = some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Object newFr = some2.value();
                    return Some$.MODULE$.apply(this.ordering().max(fr, newFr));
                }
            }
            if (None$.MODULE$.equals(option)) {
                return newFrom;
            }
            return this.from;
        }

        private Option<A> pickUpperBound(Option<A> newUntil) {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.until, newUntil);
            Option option = tuple2._1();
            Option option2 = tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object unt = some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Object newUnt = some2.value();
                    return Some$.MODULE$.apply(this.ordering().min(unt, newUnt));
                }
            }
            if (None$.MODULE$.equals(option)) {
                return newUntil;
            }
            return this.until;
        }

        private boolean isInsideViewBounds(A key) {
            boolean afterFrom = this.from.isEmpty() || this.ordering().compare(this.from.get(), key) <= 0;
            boolean beforeUntil = this.until.isEmpty() || this.ordering().compare(key, this.until.get()) < 0;
            return afterFrom && beforeUntil;
        }

        @Override
        public TreeSet<A> rangeImpl(Option<A> from, Option<A> until) {
            return new TreeSetProjection(this.$outer, this.pickLowerBound(from), this.pickUpperBound(until));
        }

        @Override
        public boolean contains(A key) {
            return this.isInsideViewBounds(key) && RedBlackTree$.MODULE$.contains(this.$outer.scala$collection$mutable$TreeSet$$tree(), key, this.ordering());
        }

        @Override
        public Iterator<A> iterator() {
            return RedBlackTree$.MODULE$.keysIterator(this.$outer.scala$collection$mutable$TreeSet$$tree(), this.from, this.until, this.ordering());
        }

        @Override
        public Iterator<A> iteratorFrom(A start) {
            return RedBlackTree$.MODULE$.keysIterator(this.$outer.scala$collection$mutable$TreeSet$$tree(), this.pickLowerBound(Some$.MODULE$.apply(start)), this.until, this.ordering());
        }

        @Override
        public int size() {
            if (RedBlackTree$.MODULE$.size(this.$outer.scala$collection$mutable$TreeSet$$tree()) == 0) {
                return 0;
            }
            return this.iterator().length();
        }

        @Override
        public int knownSize() {
            if (RedBlackTree$.MODULE$.size(this.$outer.scala$collection$mutable$TreeSet$$tree()) == 0) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return RedBlackTree$.MODULE$.size(this.$outer.scala$collection$mutable$TreeSet$$tree()) == 0 || !this.iterator().hasNext();
        }

        @Override
        public A head() {
            return this.headOption().get();
        }

        @Override
        public Option<A> headOption() {
            Option elem = this.from.isDefined() ? RedBlackTree$.MODULE$.minKeyAfter(this.$outer.scala$collection$mutable$TreeSet$$tree(), this.from.get(), this.ordering()) : RedBlackTree$.MODULE$.minKey(this.$outer.scala$collection$mutable$TreeSet$$tree());
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(elem, this.until);
            Option option = tuple2._1();
            Option option2 = tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object e = some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Object unt = some2.value();
                    if (this.ordering().compare(e, unt) >= 0) {
                        return None$.MODULE$;
                    }
                }
            }
            return elem;
        }

        @Override
        public A last() {
            return this.lastOption().get();
        }

        @Override
        public Option<A> lastOption() {
            Option elem = this.until.isDefined() ? RedBlackTree$.MODULE$.maxKeyBefore(this.$outer.scala$collection$mutable$TreeSet$$tree(), this.until.get(), this.ordering()) : RedBlackTree$.MODULE$.maxKey(this.$outer.scala$collection$mutable$TreeSet$$tree());
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(elem, this.from);
            Option option = tuple2._1();
            Option option2 = tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Object e = some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Object fr = some2.value();
                    if (this.ordering().compare(e, fr) < 0) {
                        return None$.MODULE$;
                    }
                }
            }
            return elem;
        }

        @Override
        public <U> void foreach(Function1<A, U> f) {
            this.iterator().foreach(f);
        }

        @Override
        public TreeSet<A> clone() {
            return ((TreeSet)SetOps.clone$(this)).rangeImpl(this.from, this.until);
        }

        public final /* synthetic */ TreeSet scala$collection$mutable$TreeSet$TreeSetProjection$$$outer() {
            return this.$outer;
        }
    }
}

