/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import scala.Function0;
import scala.Function1;
import scala.concurrent.BatchingExecutorStatics$;
import scala.concurrent.BatchingExecutorStatics$MissingParentBlockContext$;
import scala.concurrent.BlockContext;
import scala.concurrent.BlockContext$;
import scala.concurrent.CanAwait;
import scala.runtime.Scala3RunTime$;
import scala.util.control.NonFatal$;

public interface BatchingExecutor
extends Executor {
    public static void $init$(BatchingExecutor $this) {
        $this.scala$concurrent$BatchingExecutor$_setter_$scala$concurrent$BatchingExecutor$$_tasksLocal_$eq(new ThreadLocal());
    }

    public ThreadLocal<Object> scala$concurrent$BatchingExecutor$$_tasksLocal();

    public void scala$concurrent$BatchingExecutor$_setter_$scala$concurrent$BatchingExecutor$$_tasksLocal_$eq(ThreadLocal var1);

    public void submitForExecution(Runnable var1);

    public void reportFailure(Throwable var1);

    public static void submitAsyncBatched$(BatchingExecutor $this, Runnable runnable) {
        $this.submitAsyncBatched(runnable);
    }

    default public void submitAsyncBatched(Runnable runnable) {
        Object b = this.scala$concurrent$BatchingExecutor$$_tasksLocal().get();
        if (b instanceof AsyncBatch) {
            ((AsyncBatch)b).push(runnable);
            return;
        }
        this.submitForExecution(new AsyncBatch(runnable));
    }

    public static void submitSyncBatched$(BatchingExecutor $this, Runnable runnable) {
        $this.submitSyncBatched(runnable);
    }

    default public void submitSyncBatched(Runnable runnable) {
        int i;
        Objects.requireNonNull(runnable, "runnable is null");
        ThreadLocal<Object> tl = this.scala$concurrent$BatchingExecutor$$_tasksLocal();
        Object b = tl.get();
        if (b instanceof SyncBatch) {
            ((SyncBatch)b).push(runnable);
            return;
        }
        int n = i = !(b == null) ? (Integer)b : 0;
        if (i < 16) {
            block9: {
                tl.set(i + 1);
                try {
                    try {
                        this.submitForExecution(runnable);
                    }
                    catch (InterruptedException ie) {
                        this.reportFailure(ie);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable f = throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(f)) {
                            this.reportFailure(f);
                            break block9;
                        }
                        throw throwable;
                    }
                }
                finally {
                    tl.set(b);
                }
            }
            return;
        }
        SyncBatch batch = new SyncBatch(runnable);
        tl.set(batch);
        this.submitForExecution(batch);
        tl.set(b);
    }

    public abstract class AbstractBatch {
        private Runnable first;
        private Runnable[] other;
        private int size;

        public AbstractBatch(Runnable first, Runnable[] other, int size) {
            this.first = first;
            this.other = other;
            this.size = size;
        }

        public final Runnable first() {
            return this.first;
        }

        public final void first_$eq(Runnable x$1) {
            this.first = x$1;
        }

        public final Runnable[] other() {
            return this.other;
        }

        public final void other_$eq(Runnable[] x$1) {
            this.other = x$1;
        }

        public final int size() {
            return this.size;
        }

        public final void size_$eq(int x$1) {
            this.size = x$1;
        }

        private final Runnable[] ensureCapacity(int curSize) {
            int newLen;
            Runnable[] curOther = this.other();
            int curLen = curOther.length;
            if (curSize <= curLen) {
                return curOther;
            }
            int n = newLen = curLen == 0 ? 4 : curLen << 1;
            if (newLen <= curLen) {
                throw new StackOverflowError("Space limit of asynchronous stack reached: " + curLen);
            }
            Runnable[] newOther = new Runnable[newLen];
            System.arraycopy(curOther, 0, newOther, 0, curLen);
            this.other_$eq(newOther);
            return newOther;
        }

        public final void push(Runnable r) {
            int sz = this.size();
            if (sz == 0) {
                this.first_$eq(r);
            } else {
                this.ensureCapacity((int)sz)[sz - 1] = r;
            }
            this.size_$eq(sz + 1);
        }

        public final void runN(int n) {
            while (n > 0) {
                int n2 = this.size();
                if (0 == n2) {
                    return;
                }
                if (1 == n2) {
                    Runnable x$proxy1 = this.first();
                    if (x$proxy1 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    Runnable next = x$proxy1;
                    this.first_$eq(null);
                    this.size_$eq(0);
                    next.run();
                    --n;
                    continue;
                }
                int sz = n2;
                Runnable[] o = this.other();
                Runnable x$proxy2 = o[sz - 2];
                if (x$proxy2 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                Runnable next = x$proxy2;
                o[sz - 2] = null;
                this.size_$eq(sz - 1);
                next.run();
                --n;
            }
        }
    }

    public final class AsyncBatch
    extends AbstractBatch
    implements Runnable,
    BlockContext,
    Function1<BlockContext, Throwable> {
        private BlockContext parentBlockContext;

        private AsyncBatch(Runnable _first, Runnable[] _other, int _size) {
            if (BatchingExecutor.this == null) {
                throw new NullPointerException();
            }
            super(_first, _other, _size);
            this.parentBlockContext = BatchingExecutorStatics$MissingParentBlockContext$.MODULE$;
        }

        @Override
        public <A> Function1<A, Throwable> compose(Function1<A, BlockContext> g) {
            return Function1.compose$(this, g);
        }

        @Override
        public <A> Function1<BlockContext, A> andThen(Function1<Throwable, A> g) {
            return Function1.andThen$(this, g);
        }

        @Override
        public String toString() {
            return Function1.toString$(this);
        }

        @Override
        public void apply$mcVI$sp(int x$0) {
            Function1.apply$mcVI$sp$(this, x$0);
        }

        @Override
        public void apply$mcVJ$sp(long x$0) {
            Function1.apply$mcVJ$sp$(this, x$0);
        }

        @Override
        public void apply$mcVF$sp(float x$0) {
            Function1.apply$mcVF$sp$(this, x$0);
        }

        @Override
        public void apply$mcVD$sp(double x$0) {
            Function1.apply$mcVD$sp$(this, x$0);
        }

        @Override
        public boolean apply$mcZI$sp(int x$0) {
            return Function1.apply$mcZI$sp$(this, x$0);
        }

        @Override
        public boolean apply$mcZJ$sp(long x$0) {
            return Function1.apply$mcZJ$sp$(this, x$0);
        }

        @Override
        public boolean apply$mcZF$sp(float x$0) {
            return Function1.apply$mcZF$sp$(this, x$0);
        }

        @Override
        public boolean apply$mcZD$sp(double x$0) {
            return Function1.apply$mcZD$sp$(this, x$0);
        }

        @Override
        public int apply$mcII$sp(int x$0) {
            return Function1.apply$mcII$sp$(this, x$0);
        }

        @Override
        public int apply$mcIJ$sp(long x$0) {
            return Function1.apply$mcIJ$sp$(this, x$0);
        }

        @Override
        public int apply$mcIF$sp(float x$0) {
            return Function1.apply$mcIF$sp$(this, x$0);
        }

        @Override
        public int apply$mcID$sp(double x$0) {
            return Function1.apply$mcID$sp$(this, x$0);
        }

        @Override
        public float apply$mcFI$sp(int x$0) {
            return Function1.apply$mcFI$sp$(this, x$0);
        }

        @Override
        public float apply$mcFJ$sp(long x$0) {
            return Function1.apply$mcFJ$sp$(this, x$0);
        }

        @Override
        public float apply$mcFF$sp(float x$0) {
            return Function1.apply$mcFF$sp$(this, x$0);
        }

        @Override
        public float apply$mcFD$sp(double x$0) {
            return Function1.apply$mcFD$sp$(this, x$0);
        }

        @Override
        public long apply$mcJI$sp(int x$0) {
            return Function1.apply$mcJI$sp$(this, x$0);
        }

        @Override
        public long apply$mcJJ$sp(long x$0) {
            return Function1.apply$mcJJ$sp$(this, x$0);
        }

        @Override
        public long apply$mcJF$sp(float x$0) {
            return Function1.apply$mcJF$sp$(this, x$0);
        }

        @Override
        public long apply$mcJD$sp(double x$0) {
            return Function1.apply$mcJD$sp$(this, x$0);
        }

        @Override
        public double apply$mcDI$sp(int x$0) {
            return Function1.apply$mcDI$sp$(this, x$0);
        }

        @Override
        public double apply$mcDJ$sp(long x$0) {
            return Function1.apply$mcDJ$sp$(this, x$0);
        }

        @Override
        public double apply$mcDF$sp(float x$0) {
            return Function1.apply$mcDF$sp$(this, x$0);
        }

        @Override
        public double apply$mcDD$sp(double x$0) {
            return Function1.apply$mcDD$sp$(this, x$0);
        }

        public AsyncBatch(Runnable runnable) {
            this(runnable, BatchingExecutorStatics$.MODULE$.emptyBatchArray(), 1);
        }

        @Override
        public final void run() {
            BatchingExecutor.this.scala$concurrent$BatchingExecutor$$_tasksLocal().set(this);
            Throwable f = this.resubmit(BlockContext$.MODULE$.usingBlockContext(this, this));
            if (f != null) {
                throw f;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Throwable apply(BlockContext prevBlockContext) {
            Throwable throwable;
            try {
                try {
                    this.parentBlockContext = prevBlockContext;
                    this.runN(1024);
                    throwable = null;
                }
                catch (Throwable t) {
                    void var2_2;
                    throwable = var2_2;
                }
            }
            finally {
                this.parentBlockContext = BatchingExecutorStatics$MissingParentBlockContext$.MODULE$;
                BatchingExecutor.this.scala$concurrent$BatchingExecutor$$_tasksLocal().remove();
            }
            return throwable;
        }

        /*
         * WARNING - void declaration
         */
        private final Throwable resubmit(Throwable cause) {
            if (this.size() > 0) {
                Throwable throwable;
                try {
                    BatchingExecutor.this.submitForExecution(this);
                    throwable = cause;
                }
                catch (Throwable inner) {
                    void var2_2;
                    if (NonFatal$.MODULE$.apply(inner)) {
                        ExecutionException e = new ExecutionException("Non-fatal error occurred and resubmission failed, see suppressed exception.", cause);
                        e.addSuppressed(inner);
                        throwable = e;
                    }
                    throwable = var2_2;
                }
                return throwable;
            }
            return cause;
        }

        private final AsyncBatch cloneAndClear() {
            AsyncBatch newBatch = new AsyncBatch(this.first(), this.other(), this.size());
            this.first_$eq(null);
            this.other_$eq(BatchingExecutorStatics$.MODULE$.emptyBatchArray());
            this.size_$eq(0);
            return newBatch;
        }

        @Override
        public final <T> T blockOn(Function0<T> thunk, CanAwait permission) {
            if (this.size() > 0) {
                BatchingExecutor.this.submitForExecution(this.cloneAndClear());
            }
            return this.parentBlockContext.blockOn(thunk, permission);
        }

        public final /* synthetic */ BatchingExecutor scala$concurrent$BatchingExecutor$AsyncBatch$$$outer() {
            return BatchingExecutor.this;
        }
    }

    public final class SyncBatch
    extends AbstractBatch
    implements Runnable {
        public SyncBatch(Runnable runnable) {
            if (BatchingExecutor.this == null) {
                throw new NullPointerException();
            }
            super(runnable, BatchingExecutorStatics$.MODULE$.emptyBatchArray(), 1);
        }

        @Override
        public final void run() {
            do {
                try {
                    this.runN(1024);
                }
                catch (InterruptedException ie) {
                    BatchingExecutor.this.reportFailure(ie);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable f = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(f)) {
                        BatchingExecutor.this.reportFailure(f);
                        continue;
                    }
                    throw throwable;
                }
            } while (this.size() > 0);
        }

        public final /* synthetic */ BatchingExecutor scala$concurrent$BatchingExecutor$SyncBatch$$$outer() {
            return BatchingExecutor.this;
        }
    }
}

