/*
 * Decompiled with CFR 0.152.
 */
package sangria.slowlog;

import com.codahale.metrics.Snapshot;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import sangria.ast.BigIntValue;
import sangria.ast.BigIntValue$;
import sangria.ast.ObjectField;
import sangria.ast.ObjectField$;
import sangria.ast.ObjectValue;
import sangria.ast.ObjectValue$;
import sangria.ast.Value;
import sangria.marshalling.InputUnmarshaller;
import sangria.slowlog.FieldMetrics;
import sangria.slowlog.MetricRenderer;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001\u0002\b\u0010\u0001QA\u0001b\b\u0001\u0003\u0006\u0004%\t\u0001\t\u0005\tW\u0001\u0011\t\u0011)A\u0005C!)A\u0006\u0001C\u0001[!)\u0001\u0007\u0001C\u0001c!)q\f\u0001C\u0001A\")!\u000e\u0001C\u0001W\")Q\u000f\u0001C\u0001m\"9\u00111\u0003\u0001\u0005\u0002\u0005U\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!a\u0012\u0001\t\u0003\tI\u0005\u0003\u0006\u0002N\u0001A)\u0019!C\u0001\u0003\u001f\u0012Q\u0003R3gCVdG/T3ue&\u001c'+\u001a8eKJ,'O\u0003\u0002\u0011#\u000591\u000f\\8xY><'\"\u0001\n\u0002\u000fM\fgn\u001a:jC\u000e\u00011c\u0001\u0001\u00167A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\u0004\"\u0001H\u000f\u000e\u0003=I!AH\b\u0003\u001d5+GO]5d%\u0016tG-\u001a:fe\u0006!QO\\5u+\u0005\t\u0003C\u0001\u0012*\u001b\u0005\u0019#B\u0001\u0013&\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003M\u001d\nA!\u001e;jY*\t\u0001&\u0001\u0003kCZ\f\u0017B\u0001\u0016$\u0005!!\u0016.\\3V]&$\u0018!B;oSR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002/_A\u0011A\u0004\u0001\u0005\u0006?\r\u0001\r!I\u0001\u0010e\u0016tG-\u001a:WCJL\u0017M\u00197fgV\u0011!'\u0013\u000b\u0004gI#FC\u0001\u001b@!\t)DH\u0004\u00027uA\u0011qgF\u0007\u0002q)\u0011\u0011hE\u0001\u0007yI|w\u000e\u001e \n\u0005m:\u0012A\u0002)sK\u0012,g-\u0003\u0002>}\t11\u000b\u001e:j]\u001eT!aO\f\t\u000f\u0001#\u0011\u0011!a\u0002\u0003\u0006QQM^5eK:\u001cW\r\n\u001a\u0011\u0007\t+u)D\u0001D\u0015\t!\u0015#A\u0006nCJ\u001c\b.\u00197mS:<\u0017B\u0001$D\u0005EIe\u000e];u+:l\u0017M]:iC2dWM\u001d\t\u0003\u0011&c\u0001\u0001B\u0003K\t\t\u00071J\u0001\u0002J]F\u0011Aj\u0014\t\u0003-5K!AT\f\u0003\u000f9{G\u000f[5oOB\u0011a\u0003U\u0005\u0003#^\u00111!\u00118z\u0011\u0015\u0019F\u00011\u0001H\u0003%1\u0018M]5bE2,7\u000fC\u0003V\t\u0001\u0007a+A\u0003oC6,7\u000fE\u0002X9Rr!\u0001\u0017.\u000f\u0005]J\u0016\"\u0001\r\n\u0005m;\u0012a\u00029bG.\fw-Z\u0005\u0003;z\u0013aAV3di>\u0014(BA.\u0018\u0003-\u0011XM\u001c3fe\u001aKW\r\u001c3\u0015\tQ\n7\r\u001b\u0005\u0006E\u0016\u0001\r\u0001N\u0001\tif\u0004XMT1nK\")A-\u0002a\u0001K\u00069Q.\u001a;sS\u000e\u001c\bC\u0001\u000fg\u0013\t9wB\u0001\u0007GS\u0016dG-T3ue&\u001c7\u000fC\u0003j\u000b\u0001\u0007A'\u0001\u0004qe\u00164\u0017\u000e_\u0001\u0010e\u0016tG-\u001a:Fq\u0016\u001cW\u000f^5p]R!A\u0007\\9t\u0011\u0015ig\u00011\u0001o\u00035!WO]1uS>tg*\u00198pgB\u0011ac\\\u0005\u0003a^\u0011A\u0001T8oO\")!O\u0002a\u0001]\u0006ya/\u00197jI\u0006$\u0018n\u001c8OC:|7\u000fC\u0003u\r\u0001\u0007a.A\trk\u0016\u0014\u0018PU3ek\u000e,'OT1o_N\fqB]3oI\u0016\u0014\b*[:u_\u001e\u0014\u0018-\u001c\u000b\u0006onl\u0018\u0011\u0003\t\u0004/rC\b\u0003\u0002\fziQJ!A_\f\u0003\rQ+\b\u000f\\33\u0011\u0015ax\u00011\u0001o\u0003\u0015\u0019w.\u001e8u\u0011\u0015qx\u00011\u0001\u0000\u0003\u0011\u0019h.\u00199\u0011\t\u0005\u0005\u0011QB\u0007\u0003\u0003\u0007Q1\u0001ZA\u0003\u0015\u0011\t9!!\u0003\u0002\u0011\r|G-\u00195bY\u0016T!!a\u0003\u0002\u0007\r|W.\u0003\u0003\u0002\u0010\u0005\r!\u0001C*oCB\u001c\bn\u001c;\t\u000b}9\u0001\u0019A\u0011\u0002\u001dI,g\u000eZ3s\tV\u0014\u0018\r^5p]R\u0019A'a\u0006\t\u000b5D\u0001\u0019\u00018\u0002!I,g\u000eZ3s\u0019><W*Z:tC\u001e,G#\u0002\u001b\u0002\u001e\u0005}\u0001\"B7\n\u0001\u0004q\u0007BBA\u0011\u0013\u0001\u0007A'A\u0007f]JL7\r[3e#V,'/_\u0001\rM&,G\u000eZ'fiJL7m\u001d\u000b\u0005\u0003O\t\u0019\u0004\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\ti#E\u0001\u0004CN$\u0018\u0002BA\u0019\u0003W\u00111b\u00142kK\u000e$h+\u00197vK\")AM\u0003a\u0001K\u0006iA-\u001e:bi&|gNR5fY\u0012$b!!\u000f\u0002@\u0005\r\u0003\u0003BA\u0015\u0003wIA!!\u0010\u0002,\tYqJ\u00196fGR4\u0015.\u001a7e\u0011\u0019\t\te\u0003a\u0001i\u0005!a.Y7f\u0011\u0019\t)e\u0003a\u0001]\u0006)a/\u00197vK\u0006q!/\u001a8eKJ$\u0016.\\3V]&$Hc\u0001\u001b\u0002L!)q\u0004\u0004a\u0001C\u0005qA/[7f+:LGoU;gM&DX#\u0001\u001b")
public class DefaultMetricRenderer
implements MetricRenderer {
    private String timeUnitSuffix;
    private final TimeUnit unit;
    private volatile boolean bitmap$0;

    public TimeUnit unit() {
        return this.unit;
    }

    @Override
    public <In> String renderVariables(In variables, Vector<String> names, InputUnmarshaller<In> evidence$2) {
        InputUnmarshaller iu = (InputUnmarshaller)Predef$.MODULE$.implicitly(evidence$2);
        Iterator renderedVars = names.iterator().flatMap((Function1 & Serializable & scala.Serializable)name -> Option$.MODULE$.option2Iterable(iu.getRootMapValue(variables, name).map((Function1 & Serializable & scala.Serializable)v -> new StringBuilder(6).append("  $").append((String)name).append(" = ").append(iu.render(v)).toString())));
        if (renderedVars.nonEmpty()) {
            return renderedVars.mkString("\n");
        }
        return "";
    }

    @Override
    public String renderField(String typeName, FieldMetrics metrics, String prefix) {
        String countStr;
        long success = metrics.success().getCount();
        long failure = metrics.failure().getCount();
        Snapshot histogram = metrics.snapshot();
        long count = metrics.count();
        String string = countStr = new StringBuilder(10).append("[").append(prefix).append(typeName).append("] count: ").append(success).append((Object)(failure > 0L ? new StringBuilder(1).append("/").append(failure).toString() : "")).toString();
        return ((TraversableOnce)((Vector)this.renderHistogram(count, histogram, this.unit()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String n = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(2).append(n).append(": ").append(v).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Vector$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Vector$.MODULE$.canBuildFrom())).mkString(", ");
    }

    @Override
    public String renderExecution(long durationNanos, long validationNanos, long queryReducerNanos) {
        return new StringBuilder(56).append("[Execution Metrics] duration: ").append(this.renderDuration(durationNanos)).append(", validation: ").append(this.renderDuration(validationNanos)).append(", reducers: ").append(this.renderDuration(queryReducerNanos)).toString();
    }

    public Vector<Tuple2<String, String>> renderHistogram(long count, Snapshot snap, TimeUnit unit) {
        if (count == 1L) {
            return (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"time"), (Object)this.renderDuration(snap.getMax()))}));
        }
        return (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min"), (Object)this.renderDuration(snap.getMin())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max"), (Object)this.renderDuration(snap.getMax())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mean"), (Object)this.renderDuration((long)snap.getMean())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p75"), (Object)this.renderDuration((long)snap.get75thPercentile())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p95"), (Object)this.renderDuration((long)snap.get95thPercentile())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p99"), (Object)this.renderDuration((long)snap.get99thPercentile()))}));
    }

    @Override
    public String renderDuration(long durationNanos) {
        TimeUnit timeUnit = this.unit();
        TimeUnit timeUnit2 = TimeUnit.NANOSECONDS;
        if (!(timeUnit != null ? !((Object)((Object)timeUnit)).equals((Object)timeUnit2) : timeUnit2 != null)) {
            return new StringBuilder(0).append(durationNanos).append(this.renderTimeUnit(this.unit())).toString();
        }
        return new StringBuilder(0).append(this.unit().convert(durationNanos, TimeUnit.NANOSECONDS)).append(this.renderTimeUnit(this.unit())).toString();
    }

    @Override
    public String renderLogMessage(long durationNanos, String enrichedQuery) {
        return new StringBuilder(24).append("Slow GraphQL query [").append(this.renderDuration(durationNanos)).append("].\n\n").append(enrichedQuery).toString();
    }

    public ObjectValue fieldMetrics(FieldMetrics metrics) {
        Vector durationMetrics = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ObjectField[]{this.durationField("min", metrics.snapshot().getMin()), this.durationField("max", metrics.snapshot().getMax()), this.durationField("mean", (long)metrics.snapshot().getMean()), this.durationField("p75", (long)metrics.snapshot().get75thPercentile()), this.durationField("p95", (long)metrics.snapshot().get95thPercentile()), this.durationField("p99", (long)metrics.snapshot().get99thPercentile())}));
        Vector failed = metrics.failure().getCount() > 0L ? (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ObjectField[]{new ObjectField("failed", (Value)new BigIntValue(BigInt$.MODULE$.long2bigInt(metrics.failure().getCount()), BigIntValue$.MODULE$.apply$default$2(), BigIntValue$.MODULE$.apply$default$3()), ObjectField$.MODULE$.apply$default$3(), ObjectField$.MODULE$.apply$default$4())})) : package$.MODULE$.Vector().empty();
        ObjectField objectField = new ObjectField("count", (Value)new BigIntValue(BigInt$.MODULE$.long2bigInt(metrics.success().getCount()), BigIntValue$.MODULE$.apply$default$2(), BigIntValue$.MODULE$.apply$default$3()), ObjectField$.MODULE$.apply$default$3(), ObjectField$.MODULE$.apply$default$4());
        return new ObjectValue((Vector)((Vector)failed.$plus$plus((GenTraversableOnce)durationMetrics, Vector$.MODULE$.canBuildFrom())).$plus$colon((Object)objectField, Vector$.MODULE$.canBuildFrom()), ObjectValue$.MODULE$.apply$default$2(), ObjectValue$.MODULE$.apply$default$3());
    }

    @Override
    public ObjectField durationField(String name, long value) {
        TimeUnit timeUnit = this.unit();
        TimeUnit timeUnit2 = TimeUnit.NANOSECONDS;
        long correctValue = !(timeUnit != null ? !((Object)((Object)timeUnit)).equals((Object)timeUnit2) : timeUnit2 != null) ? value : this.unit().convert(value, TimeUnit.NANOSECONDS);
        return new ObjectField(new StringBuilder(0).append(name).append(this.timeUnitSuffix()).toString(), (Value)new BigIntValue(BigInt$.MODULE$.long2bigInt(correctValue), BigIntValue$.MODULE$.apply$default$2(), BigIntValue$.MODULE$.apply$default$3()), ObjectField$.MODULE$.apply$default$3(), ObjectField$.MODULE$.apply$default$4());
    }

    public String renderTimeUnit(TimeUnit unit) {
        TimeUnit timeUnit = unit;
        if (((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit)) {
            return "d";
        }
        if (((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit)) {
            return "h";
        }
        if (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)timeUnit)) {
            return "\u03bcs";
        }
        if (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)timeUnit)) {
            return "ms";
        }
        if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit)) {
            return "m";
        }
        if (((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)timeUnit)) {
            return "ns";
        }
        if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit)) {
            return "s";
        }
        throw new MatchError((Object)timeUnit);
    }

    private String timeUnitSuffix$lzycompute() {
        DefaultMetricRenderer defaultMetricRenderer = this;
        synchronized (defaultMetricRenderer) {
            if (!this.bitmap$0) {
                String string;
                TimeUnit timeUnit = this.unit();
                if (((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit)) {
                    string = "Day";
                } else if (((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit)) {
                    string = "Hour";
                } else if (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)timeUnit)) {
                    string = "Micros";
                } else if (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)timeUnit)) {
                    string = "Ms";
                } else if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit)) {
                    string = "Min";
                } else if (((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)timeUnit)) {
                    string = "Ns";
                } else if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit)) {
                    string = "Sec";
                } else {
                    throw new MatchError((Object)timeUnit);
                }
                this.timeUnitSuffix = string;
                this.bitmap$0 = true;
            }
        }
        return this.timeUnitSuffix;
    }

    public String timeUnitSuffix() {
        if (!this.bitmap$0) {
            return this.timeUnitSuffix$lzycompute();
        }
        return this.timeUnitSuffix;
    }

    public DefaultMetricRenderer(TimeUnit unit) {
        this.unit = unit;
    }
}

