/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.uikit;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.coreanimation.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.coredata.*;
import org.robovm.apple.coreimage.*;
import org.robovm.apple.coretext.*;
import org.robovm.apple.corelocation.*;
/*</imports>*/

/*<javadoc>*/
/**
 * @since Available in iOS 8.0 and later.
 */
/*</javadoc>*/
/*<annotations>*/@Library("UIKit") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/UIPrinter/*</name>*/ 
    extends /*<extends>*/NSObject/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/public static class UIPrinterPtr extends Ptr<UIPrinter, UIPrinterPtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(UIPrinter.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    public UIPrinter() {}
    protected UIPrinter(SkipInit skipInit) { super(skipInit); }
    public UIPrinter(NSURL url) { super(create(url)); retain(getHandle()); }
    /*</constructors>*/
    /*<properties>*/
    @Property(selector = "URL")
    public native NSURL getURL();
    @Property(selector = "displayName")
    public native String getDisplayName();
    @Property(selector = "displayLocation")
    public native String getDisplayLocation();
    @Property(selector = "supportedJobTypes")
    public native UIPrinterJobTypes getSupportedJobTypes();
    @Property(selector = "makeAndModel")
    public native String getMakeAndModel();
    @Property(selector = "supportsColor")
    public native boolean supportsColor();
    @Property(selector = "supportsDuplex")
    public native boolean supportsDuplex();
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    @Method(selector = "contactPrinter:")
    public native void contactPrinter(@Block VoidBooleanBlock completionHandler);
    @Method(selector = "printerWithURL:")
    protected static native @Pointer long create(NSURL url);
    /*</methods>*/
}
