/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.eventkit;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.corelocation.*;
import org.robovm.apple.addressbook.*;
import org.robovm.apple.mapkit.*;
/*</imports>*/

/*<javadoc>*/
/**
 * @since Available in iOS 6.0 and later.
 */
/*</javadoc>*/
/*<annotations>*/@Library("EventKit") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/EKStructuredLocation/*</name>*/ 
    extends /*<extends>*/EKObject/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/public static class EKStructuredLocationPtr extends Ptr<EKStructuredLocation, EKStructuredLocationPtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(EKStructuredLocation.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    public EKStructuredLocation() {}
    protected EKStructuredLocation(SkipInit skipInit) { super(skipInit); }
    public EKStructuredLocation(String title) { super(create(title)); retain(getHandle()); }
    /**
     * @since Available in iOS 9.0 and later.
     */
    public EKStructuredLocation(MKMapItem mapItem) { super(create(mapItem)); retain(getHandle()); }
    /*</constructors>*/
    /*<properties>*/
    @Property(selector = "title")
    public native String getTitle();
    @Property(selector = "setTitle:")
    public native void setTitle(String v);
    @Property(selector = "geoLocation")
    public native CLLocation getGeoLocation();
    @Property(selector = "setGeoLocation:")
    public native void setGeoLocation(CLLocation v);
    @Property(selector = "radius")
    public native double getRadius();
    @Property(selector = "setRadius:")
    public native void setRadius(double v);
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    @Method(selector = "locationWithTitle:")
    private static native @Pointer long create(String title);
    /**
     * @since Available in iOS 9.0 and later.
     */
    @Method(selector = "locationWithMapItem:")
    private static native @Pointer long create(MKMapItem mapItem);
    /*</methods>*/
}
