/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.AsyncTaskLoader;
import android.content.Context;
import java.util.concurrent.Callable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.util.SimpleFuture;

@Implements(value=AsyncTaskLoader.class)
public class ShadowAsyncTaskLoader<D> {
    @RealObject
    private AsyncTaskLoader<D> realObject;
    private SimpleFuture<D> future;

    public void __constructor__(Context context) {
        BackgroundWorker worker = new BackgroundWorker();
        this.future = new SimpleFuture<D>(worker){

            protected void done() {
                try {
                    final Object result = this.get();
                    ShadowApplication.getInstance().getForegroundThreadScheduler().post(new Runnable(){

                        @Override
                        public void run() {
                            ShadowAsyncTaskLoader.this.realObject.deliverResult(result);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
    }

    @Implementation
    public void onForceLoad() {
        ShadowApplication.getInstance().getBackgroundThreadScheduler().post(new Runnable(){

            @Override
            public void run() {
                ShadowAsyncTaskLoader.this.future.run();
            }
        });
    }

    private final class BackgroundWorker
    implements Callable<D> {
        private BackgroundWorker() {
        }

        @Override
        public D call() throws Exception {
            return ShadowAsyncTaskLoader.this.realObject.loadInBackground();
        }
    }
}

