/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.ParcelFileDescriptor;
import android.util.AttributeSet;
import android.util.TypedValue;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.res.AttrData;
import org.robolectric.res.AttributeResource;
import org.robolectric.res.DrawableResourceLoader;
import org.robolectric.res.EmptyStyle;
import org.robolectric.res.FileTypedResource;
import org.robolectric.res.FsFile;
import org.robolectric.res.ResName;
import org.robolectric.res.ResType;
import org.robolectric.res.ResourceIds;
import org.robolectric.res.ResourceTable;
import org.robolectric.res.Style;
import org.robolectric.res.StyleData;
import org.robolectric.res.StyleResolver;
import org.robolectric.res.ThemeStyleSet;
import org.robolectric.res.TypedResource;
import org.robolectric.res.builder.XmlBlock;
import org.robolectric.res.builder.XmlResourceParserImpl;
import org.robolectric.shadows.Converter;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowTypedArray;
import org.robolectric.util.Logger;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AssetManager.class)
public final class ShadowAssetManager {
    public static final int STYLE_NUM_ENTRIES = 6;
    public static final int STYLE_TYPE = 0;
    public static final int STYLE_DATA = 1;
    public static final int STYLE_ASSET_COOKIE = 2;
    public static final int STYLE_RESOURCE_ID = 3;
    public static final int STYLE_CHANGING_CONFIGURATIONS = 4;
    public static final int STYLE_DENSITY = 5;
    boolean strictErrors = false;
    private static long nextInternalThemeId = 1000L;
    private static final Map<Long, NativeTheme> nativeThemes = new HashMap<Long, NativeTheme>();
    private ResourceTable resourceTable;
    @RealObject
    AssetManager realObject;

    private void convertAndFill(AttributeResource attribute, TypedValue outValue, String qualifiers, boolean resolveRefs) {
        if (attribute.isNull()) {
            outValue.type = 0;
            outValue.data = 0;
            return;
        }
        if (attribute.isEmpty()) {
            outValue.type = 0;
            outValue.data = 1;
            return;
        }
        outValue.assetCookie = Converter.getNextStringCookie();
        if (attribute.isStyleReference()) {
            return;
        }
        while (attribute.isResourceReference()) {
            ResName resName = attribute.getResourceReference();
            Integer resourceId = attribute.getReferenceResId() != null ? attribute.getReferenceResId() : this.resourceTable.getResourceId(resName);
            if (resourceId == null) {
                throw new Resources.NotFoundException("unknown resource " + resName);
            }
            outValue.type = 1;
            if (!resolveRefs) {
                outValue.data = resourceId;
                return;
            }
            outValue.resourceId = resourceId;
            TypedResource dereferencedRef = this.resourceTable.getValue(resName, qualifiers);
            if (dereferencedRef == null) {
                Logger.strict((String)"couldn't resolve %s from %s", (Object[])new Object[]{resName.getFullyQualifiedName(), attribute});
                if (resName.type.equals("id")) {
                    return;
                }
                if (resName.type.equals("layout")) {
                    return;
                }
                if (resName.type.equals("dimen")) {
                    return;
                }
                if (resName.type.equals("transition")) {
                    return;
                }
                if (resName.type.equals("interpolator")) {
                    return;
                }
                if (resName.type.equals("menu")) {
                    return;
                }
                if (resName.type.equals("raw")) {
                    return;
                }
                if (DrawableResourceLoader.isStillHandledHere((String)resName.type)) {
                    TypedResource drawableResource = this.resourceTable.getValue(resName, qualifiers);
                    if (drawableResource == null) {
                        throw new Resources.NotFoundException("can't find file for " + resName);
                    }
                    outValue.type = 3;
                    outValue.data = 0;
                    outValue.assetCookie = Converter.getNextStringCookie();
                    outValue.string = (CharSequence)drawableResource.getData();
                    return;
                }
                throw new RuntimeException("huh? " + resName);
            }
            if (dereferencedRef.isFile()) {
                outValue.type = 3;
                outValue.data = 0;
                outValue.assetCookie = Converter.getNextStringCookie();
                outValue.string = dereferencedRef.asString();
                return;
            }
            if (!(dereferencedRef.getData() instanceof String)) break;
            attribute = new AttributeResource(attribute.resName, dereferencedRef.asString(), resName.packageName);
            if (attribute.isResourceReference()) continue;
            if (!resolveRefs) break;
            Converter.getConverter((ResType)dereferencedRef.getResType()).fillTypedValue((Object)attribute.value, outValue);
            return;
        }
        if (attribute.isNull()) {
            outValue.type = 0;
            return;
        }
        TypedResource attrTypeData = this.resourceTable.getValue(attribute.resName, qualifiers);
        if (attrTypeData != null) {
            String[] types;
            AttrData attrData = (AttrData)attrTypeData.getData();
            String format = attrData.getFormat();
            for (String type : types = format.split("\\|")) {
                Converter converter;
                if ("reference".equals(type) || (converter = Converter.getConverterFor((AttrData)attrData, (String)type)) == null || !converter.fillTypedValue((Object)attribute.value, outValue)) continue;
                return;
            }
        } else {
            ResType resType = ResType.inferFromValue((String)attribute.value);
            Converter.getConverter((ResType)resType).fillTypedValue((Object)attribute.value, outValue);
        }
    }

    public void __constructor__() {
        this.resourceTable = RuntimeEnvironment.getAppResourceTable();
    }

    public void __constructor__(boolean isSystem) {
        this.resourceTable = isSystem ? RuntimeEnvironment.getSystemResourceTable() : RuntimeEnvironment.getAppResourceTable();
    }

    public ResourceTable getResourceTable() {
        return this.resourceTable;
    }

    @HiddenApi
    @Implementation
    public CharSequence getResourceText(int ident) {
        TypedResource value = this.getAndResolve(ident, RuntimeEnvironment.getQualifiers(), true);
        if (value == null) {
            return null;
        }
        return (CharSequence)value.getData();
    }

    @HiddenApi
    @Implementation
    public CharSequence getResourceBagText(int ident, int bagEntryId) {
        throw new UnsupportedOperationException();
    }

    @HiddenApi
    @Implementation
    public String[] getResourceStringArray(int id2) {
        CharSequence[] resourceTextArray = this.getResourceTextArray(id2);
        if (resourceTextArray == null) {
            return null;
        }
        String[] strings = new String[resourceTextArray.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = resourceTextArray[i].toString();
        }
        return strings;
    }

    @HiddenApi
    @Implementation
    public int getResourceIdentifier(String name, String defType, String defPackage) {
        ResName resName = ResName.qualifyResName((String)name, (String)defPackage, (String)defType);
        if (!"id".equals(resName.type) && !this.resourceTable.hasValue(resName, RuntimeEnvironment.getQualifiers())) {
            return 0;
        }
        Integer resourceId = this.resourceTable.getResourceId(resName);
        return resourceId == null ? 0 : resourceId;
    }

    @HiddenApi
    @Implementation
    public boolean getResourceValue(int ident, int density, TypedValue outValue, boolean resolveRefs) {
        TypedResource value = this.getAndResolve(ident, RuntimeEnvironment.getQualifiers(), resolveRefs);
        if (value == null) {
            return false;
        }
        this.getConverter(value).fillTypedValue(value.getData(), outValue);
        return true;
    }

    private Converter getConverter(TypedResource value) {
        if (value instanceof FileTypedResource.Image || value instanceof FileTypedResource && ((FileTypedResource)value).getFsFile().getName().endsWith(".xml")) {
            return new Converter.FromFilePath();
        }
        return Converter.getConverter((ResType)value.getResType());
    }

    @HiddenApi
    @Implementation
    public CharSequence[] getResourceTextArray(int resId) {
        TypedResource value = this.getAndResolve(resId, RuntimeEnvironment.getQualifiers(), true);
        if (value == null) {
            return null;
        }
        TypedResource[] items = this.getConverter(value).getItems(value);
        CharSequence[] charSequences = new CharSequence[items.length];
        for (int i = 0; i < items.length; ++i) {
            TypedResource typedResource = this.resolve(items[i], RuntimeEnvironment.getQualifiers(), resId);
            charSequences[i] = this.getConverter(typedResource).asCharSequence(typedResource);
        }
        return charSequences;
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public boolean getThemeValue(int themePtr, int ident, TypedValue outValue, boolean resolveRefs) {
        return this.getThemeValue((long)themePtr, ident, outValue, resolveRefs);
    }

    @HiddenApi
    @Implementation(minSdk=21)
    public boolean getThemeValue(long themePtr, int ident, TypedValue outValue, boolean resolveRefs) {
        ResName resName = this.resourceTable.getResName(ident);
        ThemeStyleSet themeStyleSet = ShadowAssetManager.getNativeTheme(themePtr).themeStyleSet;
        AttributeResource attrValue = themeStyleSet.getAttrValue(resName);
        while (attrValue != null && attrValue.isStyleReference()) {
            ResName attrResName = attrValue.getStyleReference();
            if (attrValue.resName.equals((Object)attrResName)) {
                Logger.info((String)"huh... circular reference for %s?", (Object[])new Object[]{attrResName.getFullyQualifiedName()});
                return false;
            }
            attrValue = themeStyleSet.getAttrValue(attrResName);
        }
        if (attrValue != null) {
            this.convertAndFill(attrValue, outValue, RuntimeEnvironment.getQualifiers(), resolveRefs);
            return true;
        }
        return false;
    }

    @HiddenApi
    @Implementation
    public void ensureStringBlocks() {
    }

    @Implementation
    public final InputStream open(String fileName) throws IOException {
        return ShadowApplication.getInstance().getAppManifest().getAssetsDirectory().join(new String[]{fileName}).getInputStream();
    }

    @Implementation
    public final InputStream open(String fileName, int accessMode) throws IOException {
        return ShadowApplication.getInstance().getAppManifest().getAssetsDirectory().join(new String[]{fileName}).getInputStream();
    }

    @Implementation
    public final AssetFileDescriptor openFd(String fileName) throws IOException {
        File file = new File(ShadowApplication.getInstance().getAppManifest().getAssetsDirectory().join(new String[]{fileName}).getPath());
        ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        return new AssetFileDescriptor(parcelFileDescriptor, 0L, file.length());
    }

    @Implementation
    public final String[] list(String path) throws IOException {
        FsFile file = ShadowApplication.getInstance().getAppManifest().getAssetsDirectory().join(new String[]{path});
        if (file.isDirectory()) {
            return file.listFileNames();
        }
        return new String[0];
    }

    @HiddenApi
    @Implementation
    public final InputStream openNonAsset(int cookie, String fileName, int accessMode) throws IOException {
        ResName resName = this.qualifyFromNonAssetFileName(fileName);
        FileTypedResource typedResource = (FileTypedResource)this.resourceTable.getValue(resName, RuntimeEnvironment.getQualifiers());
        if (typedResource == null) {
            throw new IOException("Unable to find resource for " + fileName);
        }
        if (accessMode == 2) {
            return typedResource.getFsFile().getInputStream();
        }
        return new ByteArrayInputStream(typedResource.getFsFile().getBytes());
    }

    private ResName qualifyFromNonAssetFileName(String fileName) {
        if (fileName.startsWith("jar:")) {
            return ResName.qualifyFromFilePath((String)"android", (String)fileName.replaceFirst("jar:", ""));
        }
        return ResName.qualifyFromFilePath((String)ShadowApplication.getInstance().getAppManifest().getPackageName(), (String)fileName);
    }

    @HiddenApi
    @Implementation
    public final AssetFileDescriptor openNonAssetFd(int cookie, String fileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Implementation
    public final XmlResourceParser openXmlResourceParser(int cookie, String fileName) throws IOException {
        return this.getXmlResourceParser(null, XmlBlock.create((String)fileName, (String)"fixme"), "fixme");
    }

    public XmlResourceParser loadXmlResourceParser(int resId, String type) throws Resources.NotFoundException {
        ResName resName = this.getResName(resId);
        ResName resolvedResName = this.resolveResName(resName, RuntimeEnvironment.getQualifiers());
        if (resolvedResName == null) {
            throw new RuntimeException("couldn't resolve " + resName.getFullyQualifiedName());
        }
        resName = resolvedResName;
        XmlBlock block = this.resourceTable.getXml(resName, RuntimeEnvironment.getQualifiers());
        if (block == null) {
            throw new Resources.NotFoundException(resName.getFullyQualifiedName());
        }
        ResourceTable resourceProvider = ResourceIds.isFrameworkResource((int)resId) ? RuntimeEnvironment.getSystemResourceTable() : RuntimeEnvironment.getCompileTimeResourceTable();
        return this.getXmlResourceParser(resourceProvider, block, resName.packageName);
    }

    private XmlResourceParser getXmlResourceParser(ResourceTable resourceProvider, XmlBlock block, String packageName) {
        return new XmlResourceParserImpl(block.getDocument(), block.getFilename(), block.getPackageName(), packageName, resourceProvider);
    }

    @HiddenApi
    @Implementation
    public int addAssetPath(String path) {
        return 1;
    }

    @HiddenApi
    @Implementation
    public boolean isUpToDate() {
        return true;
    }

    @HiddenApi
    @Implementation
    public void setLocale(String locale) {
    }

    @Implementation
    public String[] getLocales() {
        return new String[0];
    }

    @HiddenApi
    @Implementation
    public void setConfiguration(int mcc, int mnc, String locale, int orientation, int touchscreen, int density, int keyboard, int keyboardHidden, int navigation, int screenWidth, int screenHeight, int smallestScreenWidthDp, int screenWidthDp, int screenHeightDp, int screenLayout, int uiMode, int majorVersion) {
    }

    @HiddenApi
    @Implementation
    public int[] getArrayIntResource(int resId) {
        TypedResource value = this.getAndResolve(resId, RuntimeEnvironment.getQualifiers(), true);
        if (value == null) {
            return null;
        }
        TypedResource[] items = this.getConverter(value).getItems(value);
        int[] ints = new int[items.length];
        for (int i = 0; i < items.length; ++i) {
            TypedResource typedResource = this.resolve(items[i], RuntimeEnvironment.getQualifiers(), resId);
            ints[i] = this.getConverter(typedResource).asInt(typedResource);
        }
        return ints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HiddenApi
    @Implementation
    public Number createTheme() {
        Map<Long, NativeTheme> map = nativeThemes;
        synchronized (map) {
            long nativePtr = nextInternalThemeId++;
            nativeThemes.put(nativePtr, new NativeTheme(new ThemeStyleSet()));
            return RuntimeEnvironment.castNativePtr((long)nativePtr);
        }
    }

    private static NativeTheme getNativeTheme(Resources.Theme theme) {
        return ShadowAssetManager.getNativeTheme(Shadows.shadowOf(theme).getNativePtr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NativeTheme getNativeTheme(long themePtr) {
        NativeTheme nativeTheme;
        Map<Long, NativeTheme> map = nativeThemes;
        synchronized (map) {
            nativeTheme = nativeThemes.get(themePtr);
        }
        if (nativeTheme == null) {
            throw new RuntimeException("no theme " + themePtr + " found in AssetManager");
        }
        return nativeTheme;
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public void releaseTheme(int themePtr) {
        this.releaseTheme((long)themePtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HiddenApi
    @Implementation(minSdk=21)
    public void releaseTheme(long themePtr) {
        Map<Long, NativeTheme> map = nativeThemes;
        synchronized (map) {
            nativeThemes.remove(themePtr);
        }
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void applyThemeStyle(int themePtr, int styleRes, boolean force) {
        ShadowAssetManager.applyThemeStyle((long)themePtr, styleRes, force);
    }

    @HiddenApi
    @Implementation(minSdk=21)
    public static void applyThemeStyle(long themePtr, int styleRes, boolean force) {
        NativeTheme nativeTheme = ShadowAssetManager.getNativeTheme(themePtr);
        Style style = nativeTheme.getShadowAssetManager().resolveStyle(styleRes, null);
        nativeTheme.themeStyleSet.apply(style, force);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void copyTheme(int destPtr, int sourcePtr) {
        ShadowAssetManager.copyTheme((long)destPtr, (long)sourcePtr);
    }

    @HiddenApi
    @Implementation(minSdk=21)
    public static void copyTheme(long destPtr, long sourcePtr) {
        NativeTheme destNativeTheme = ShadowAssetManager.getNativeTheme(destPtr);
        NativeTheme sourceNativeTheme = ShadowAssetManager.getNativeTheme(sourcePtr);
        destNativeTheme.themeStyleSet = sourceNativeTheme.themeStyleSet.copy();
    }

    Style resolveStyle(int resId, Style themeStyleSet) {
        return this.resolveStyle(this.getResName(resId), themeStyleSet);
    }

    private Style resolveStyle(@NotNull ResName themeStyleName, Style themeStyleSet) {
        TypedResource themeStyleResource = this.resourceTable.getValue(themeStyleName, RuntimeEnvironment.getQualifiers());
        if (themeStyleResource == null) {
            return null;
        }
        StyleData themeStyleData = (StyleData)themeStyleResource.getData();
        if (themeStyleSet == null) {
            themeStyleSet = new ThemeStyleSet();
        }
        return new StyleResolver(this.resourceTable, Shadows.shadowOf(AssetManager.getSystem()).getResourceTable(), themeStyleData, themeStyleSet, themeStyleName, RuntimeEnvironment.getQualifiers());
    }

    private TypedResource getAndResolve(int resId, String qualifiers, boolean resolveRefs) {
        TypedResource value = this.resourceTable.getValue(resId, qualifiers);
        if (resolveRefs) {
            value = this.resolve(value, qualifiers, resId);
        }
        return value;
    }

    TypedResource resolve(TypedResource value, String qualifiers, int resId) {
        return this.resolveResourceValue(value, qualifiers, resId);
    }

    public ResName resolveResName(ResName resName, String qualifiers) {
        TypedResource value = this.resourceTable.getValue(resName, qualifiers);
        return this.resolveResource(value, qualifiers, resName);
    }

    private ResName resolveResource(TypedResource value, String qualifiers, ResName resName) {
        while (value != null && value.isReference()) {
            String s = value.asString();
            if (AttributeResource.isNull((String)s) || AttributeResource.isEmpty((String)s)) {
                value = null;
                continue;
            }
            String refStr = s.substring(1).replace("+", "");
            resName = ResName.qualifyResName((String)refStr, (ResName)resName);
            value = this.resourceTable.getValue(resName, qualifiers);
        }
        return resName;
    }

    private TypedResource resolveResourceValue(TypedResource value, String qualifiers, ResName resName) {
        while (value != null && value.isReference()) {
            String s = value.asString();
            if (AttributeResource.isNull((String)s) || AttributeResource.isEmpty((String)s)) {
                value = null;
                continue;
            }
            String refStr = s.substring(1).replace("+", "");
            resName = ResName.qualifyResName((String)refStr, (ResName)resName);
            value = this.resourceTable.getValue(resName, qualifiers);
        }
        return value;
    }

    public TypedResource resolveResourceValue(TypedResource value, String qualifiers, int resId) {
        ResName resName = this.getResName(resId);
        return this.resolveResourceValue(value, qualifiers, resName);
    }

    private TypedValue buildTypedValue(AttributeSet set, int resId, int defStyleAttr, Style themeStyleSet, int defStyleRes) {
        ResName defStyleName;
        AttributeResource defStyleAttribute;
        Style defStyleFromAttr = null;
        Style defStyleFromRes = null;
        Style styleAttrStyle = null;
        if (defStyleAttr != 0 && (defStyleAttribute = themeStyleSet.getAttrValue(defStyleName = this.getResName(defStyleAttr))) != null) {
            while (defStyleAttribute.isStyleReference()) {
                AttributeResource other = themeStyleSet.getAttrValue(defStyleAttribute.getStyleReference());
                if (other == null) {
                    throw new RuntimeException("couldn't dereference " + defStyleAttribute);
                }
                defStyleAttribute = other;
            }
            if (defStyleAttribute.isResourceReference()) {
                ResName defStyleResName = defStyleAttribute.getResourceReference();
                defStyleFromAttr = this.resolveStyle(defStyleResName, themeStyleSet);
            }
        }
        if (set != null && set.getStyleAttribute() != 0) {
            ResName styleAttributeResName = this.getResName(set.getStyleAttribute());
            while (styleAttributeResName.type.equals("attr")) {
                AttributeResource attrValue = themeStyleSet.getAttrValue(styleAttributeResName);
                if (attrValue == null) {
                    throw new RuntimeException("no value for " + styleAttributeResName.getFullyQualifiedName() + " in " + themeStyleSet);
                }
                if (attrValue.isResourceReference()) {
                    styleAttributeResName = attrValue.getResourceReference();
                    continue;
                }
                if (!attrValue.isStyleReference()) continue;
                styleAttributeResName = attrValue.getStyleReference();
            }
            styleAttrStyle = this.resolveStyle(styleAttributeResName, themeStyleSet);
        }
        if (defStyleRes != 0) {
            AttributeResource attributeValue;
            ResName resName = this.getResName(defStyleRes);
            if (resName.type.equals("attr") && (attributeValue = this.findAttributeValue(defStyleRes, set, styleAttrStyle, defStyleFromAttr, defStyleFromAttr, themeStyleSet)) != null) {
                if (attributeValue.isStyleReference()) {
                    resName = themeStyleSet.getAttrValue(attributeValue.getStyleReference()).getResourceReference();
                } else if (attributeValue.isResourceReference()) {
                    resName = attributeValue.getResourceReference();
                }
            }
            defStyleFromRes = this.resolveStyle(resName, themeStyleSet);
        }
        AttributeResource attribute = this.findAttributeValue(resId, set, styleAttrStyle, defStyleFromAttr, defStyleFromRes, themeStyleSet);
        while (attribute != null && attribute.isStyleReference()) {
            ResName otherAttrName = attribute.getStyleReference();
            if (attribute.resName.equals((Object)otherAttrName)) {
                Logger.info((String)"huh... circular reference for %s?", (Object[])new Object[]{attribute.resName.getFullyQualifiedName()});
                return null;
            }
            ResName resName = this.resourceTable.getResName(resId);
            AttributeResource otherAttr = themeStyleSet.getAttrValue(otherAttrName);
            if (otherAttr == null) {
                this.strictError("no such attr %s in %s while resolving value for %s", attribute.value, themeStyleSet, resName.getFullyQualifiedName());
                attribute = null;
                continue;
            }
            attribute = new AttributeResource(resName, otherAttr.value, otherAttr.contextPackageName);
        }
        if (attribute == null || attribute.isNull()) {
            return null;
        }
        TypedValue typedValue = new TypedValue();
        this.convertAndFill(attribute, typedValue, RuntimeEnvironment.getQualifiers(), true);
        return typedValue;
    }

    private void strictError(String message, Object ... args) {
        if (this.strictErrors) {
            throw new RuntimeException(String.format(message, args));
        }
        Logger.strict((String)message, (Object[])args);
    }

    TypedArray attrsToTypedArray(Resources resources, AttributeSet set, int[] attrs, int defStyleAttr, long nativeTheme, int defStyleRes) {
        CharSequence[] stringData = new CharSequence[attrs.length];
        int[] data = new int[attrs.length * 6];
        int[] indices = new int[attrs.length + 1];
        int nextIndex = 0;
        EmptyStyle themeStyleSet = nativeTheme == 0L ? new EmptyStyle() : ShadowAssetManager.getNativeTheme(nativeTheme).themeStyleSet;
        for (int i = 0; i < attrs.length; ++i) {
            int offset = i * 6;
            TypedValue typedValue = this.buildTypedValue(set, attrs[i], defStyleAttr, (Style)themeStyleSet, defStyleRes);
            if (typedValue == null) continue;
            data[offset + 0] = typedValue.type;
            data[offset + 1] = typedValue.type == 3 ? i : typedValue.data;
            data[offset + 2] = typedValue.assetCookie;
            data[offset + 3] = typedValue.resourceId;
            data[offset + 4] = typedValue.changingConfigurations;
            data[offset + 5] = typedValue.density;
            stringData[i] = typedValue.string;
            indices[nextIndex + 1] = i;
            ++nextIndex;
        }
        indices[0] = nextIndex;
        TypedArray typedArray = ShadowTypedArray.create(resources, attrs, data, indices, nextIndex, stringData);
        if (set != null) {
            Shadows.shadowOf((TypedArray)typedArray).positionDescription = set.getPositionDescription();
        }
        return typedArray;
    }

    private AttributeResource findAttributeValue(int resId, AttributeSet attributeSet, Style styleAttrStyle, Style defStyleFromAttr, Style defStyleFromRes, @NotNull Style themeStyleSet) {
        AttributeResource attribute;
        ResName attrName;
        if (attributeSet != null) {
            for (int i = 0; i < attributeSet.getAttributeCount(); ++i) {
                if (attributeSet.getAttributeNameResource(i) != resId || attributeSet.getAttributeValue(i) == null) continue;
                String defaultPackageName = ResourceIds.isFrameworkResource((int)resId) ? "android" : RuntimeEnvironment.application.getPackageName();
                ResName resName = ResName.qualifyResName((String)attributeSet.getAttributeName(i), (String)defaultPackageName, (String)"attr");
                Integer referenceResId = null;
                if (AttributeResource.isResourceReference((String)attributeSet.getAttributeValue(i))) {
                    referenceResId = attributeSet.getAttributeResourceValue(i, -1);
                }
                return new AttributeResource(resName, attributeSet.getAttributeValue(i), "fixme!!!", referenceResId);
            }
        }
        if ((attrName = this.resourceTable.getResName(resId)) == null) {
            return null;
        }
        if (styleAttrStyle != null && (attribute = styleAttrStyle.getAttrValue(attrName)) != null) {
            return attribute;
        }
        if (defStyleFromAttr != null && (attribute = defStyleFromAttr.getAttrValue(attrName)) != null) {
            return attribute;
        }
        if (defStyleFromRes != null && (attribute = defStyleFromRes.getAttrValue(attrName)) != null) {
            return attribute;
        }
        return themeStyleSet.getAttrValue(attrName);
    }

    @NotNull
    private ResName getResName(int id2) {
        ResName resName = this.resourceTable.getResName(id2);
        if (resName == null) {
            throw new Resources.NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(id2) + " in packages " + this.resourceTable);
        }
        return resName;
    }

    @Implementation
    public String getResourceName(int resid) {
        return this.getResName(resid).getFullyQualifiedName();
    }

    @Implementation
    public String getResourcePackageName(int resid) {
        return this.getResName((int)resid).packageName;
    }

    @Implementation
    public String getResourceTypeName(int resid) {
        return this.getResName((int)resid).type;
    }

    @Implementation
    public String getResourceEntryName(int resid) {
        return this.getResName((int)resid).name;
    }

    @Resetter
    public static void reset() {
        ReflectionHelpers.setStaticField(AssetManager.class, (String)"sSystem", null);
    }

    class NativeTheme {
        private ThemeStyleSet themeStyleSet;

        public NativeTheme(ThemeStyleSet themeStyleSet) {
            this.themeStyleSet = themeStyleSet;
        }

        public ShadowAssetManager getShadowAssetManager() {
            return ShadowAssetManager.this;
        }
    }
}

