/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.robolectric.res.Qualifiers;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceTable;
import org.robolectric.res.TypedResource;
import org.robolectric.res.XmlLoader;

public class ResBundle {
    private final ResMap valuesMap = new ResMap();

    public void put(String attrType, String name, TypedResource value) {
        XmlLoader.XmlContext xmlContext = value.getXmlContext();
        ResName resName = new ResName(xmlContext.getPackageName(), attrType, name);
        this.valuesMap.put(resName, value);
    }

    public TypedResource get(ResName resName, String qualifiers) {
        return this.valuesMap.pick(resName, qualifiers);
    }

    public void receive(ResourceTable.Visitor visitor) {
        for (Map.Entry entry : this.valuesMap.map.entrySet()) {
            visitor.visit((ResName)entry.getKey(), ((Map)entry.getValue()).values());
        }
    }

    static class ResMap {
        private final Map<ResName, Map<String, TypedResource>> map = new HashMap<ResName, Map<String, TypedResource>>();

        ResMap() {
        }

        public TypedResource pick(ResName resName, String qualifiersStr) {
            Map<String, TypedResource> values = this.map.get(resName);
            if (values == null || values.size() == 0) {
                return null;
            }
            TreeSet<TypedResource> typedResources = new TreeSet<TypedResource>(new QualifierSort());
            typedResources.addAll(values.values());
            Qualifiers toMatch = Qualifiers.parse(qualifiersStr);
            ArrayList<TypedResource> passesRequirements = new ArrayList<TypedResource>();
            for (TypedResource candidate : typedResources) {
                Qualifiers qualifiers = Qualifiers.parse(candidate.getQualifiers());
                if (!qualifiers.passesRequirements(toMatch)) continue;
                passesRequirements.add(candidate);
            }
            Qualifiers bestMatchQualifiers = null;
            TypedResource bestMatch = null;
            for (TypedResource candidate : passesRequirements) {
                Qualifiers qualifiers = Qualifiers.parse(candidate.getQualifiers());
                if (!qualifiers.matches(toMatch) || bestMatchQualifiers != null && !qualifiers.isBetterThan(bestMatchQualifiers, toMatch)) continue;
                bestMatchQualifiers = qualifiers;
                bestMatch = candidate;
            }
            if (bestMatch != null) {
                return bestMatch;
            }
            if (!passesRequirements.isEmpty()) {
                return (TypedResource)passesRequirements.get(0);
            }
            return null;
        }

        public void put(ResName resName, TypedResource value) {
            Map<String, TypedResource> values = this.map.get(resName);
            if (values == null) {
                values = new HashMap<String, TypedResource>();
                this.map.put(resName, values);
            }
            if (!values.containsKey(value.getQualifiers())) {
                values.put(value.getQualifiers(), value);
            }
        }

        public int size() {
            return this.map.size();
        }

        public static class QualifierSort
        implements Comparator<TypedResource> {
            @Override
            public int compare(TypedResource o1, TypedResource o2) {
                return o1.getQualifiers().compareTo(o2.getQualifiers());
            }
        }
    }
}

