/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import org.robolectric.res.FsFile;
import org.robolectric.res.ResBundle;
import org.robolectric.res.ResType;
import org.robolectric.res.ResourcePath;
import org.robolectric.res.StartsWithFilter;
import org.robolectric.res.TypedResource;
import org.robolectric.res.XmlLoader;

public class RawResourceLoader {
    private String packageName;
    private final ResourcePath resourcePath;

    public RawResourceLoader(String packageName, ResourcePath resourcePath) {
        this.packageName = packageName;
        this.resourcePath = resourcePath;
    }

    public void loadTo(ResBundle rawResourceFiles) {
        this.load(rawResourceFiles, "raw");
        this.load(rawResourceFiles, "drawable");
    }

    public void load(ResBundle rawResourceFiles, String folderBaseName) {
        FsFile resourceBase = this.resourcePath.getResourceBase();
        FsFile[] files = resourceBase.listFiles(new StartsWithFilter(folderBaseName));
        if (files == null) {
            throw new RuntimeException(resourceBase.join(folderBaseName) + " is not a directory");
        }
        for (FsFile dir : files) {
            this.loadRawFiles(rawResourceFiles, folderBaseName, dir);
        }
    }

    private void loadRawFiles(ResBundle rawResourceFiles, String resourceType, FsFile rawDir) {
        FsFile[] files = rawDir.listFiles();
        if (files != null) {
            for (FsFile file : files) {
                String fileBaseName = file.getBaseName();
                rawResourceFiles.put(resourceType, fileBaseName, new TypedResource<FsFile>(file, ResType.FILE, new XmlLoader.XmlContext(this.packageName, file)));
            }
        }
    }
}

