/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import org.robolectric.res.FileTypedResource;
import org.robolectric.res.FsFile;
import org.robolectric.res.ResBunch;
import org.robolectric.res.ResourcePath;
import org.robolectric.res.XmlLoader;

public class DrawableResourceLoader {
    private String packageName;
    private final ResBunch resBunch;

    public static boolean isStillHandledHere(String type) {
        return "drawable".equals(type) || "anim".equals(type) || "mipmap".equals(type);
    }

    DrawableResourceLoader(String packageName, ResBunch resBunch) {
        this.packageName = packageName;
        this.resBunch = resBunch;
    }

    void findDrawableResources(ResourcePath resourcePath) {
        FsFile[] files = resourcePath.getResourceBase().listFiles();
        if (files != null) {
            for (FsFile f : files) {
                if (f.isDirectory() && f.getName().startsWith("drawable")) {
                    this.listDrawableResources(f, "drawable");
                    continue;
                }
                if (!f.isDirectory() || !f.getName().startsWith("mipmap")) continue;
                this.listDrawableResources(f, "mipmap");
            }
        }
    }

    private void listDrawableResources(FsFile dir, String type) {
        FsFile[] files = dir.listFiles();
        if (files != null) {
            for (FsFile f : files) {
                boolean isNinePatch;
                String shortName;
                String name = f.getName();
                if (name.startsWith(".") || name.endsWith(".xml")) continue;
                if (name.endsWith(".9.png")) {
                    String[] tokens = name.split("\\.9\\.png$");
                    shortName = tokens[0];
                    isNinePatch = true;
                } else {
                    shortName = f.getBaseName();
                    isNinePatch = false;
                }
                XmlLoader.XmlContext fakeXmlContext = new XmlLoader.XmlContext(this.packageName, f);
                this.resBunch.put(type, shortName, new FileTypedResource.Image(f, isNinePatch, fakeXmlContext));
            }
        }
    }
}

