/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.art;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.Arrays;
import org.roaringbitmap.art.Node;
import org.roaringbitmap.art.Node16;
import org.roaringbitmap.art.Node256;
import org.roaringbitmap.art.NodeType;
import org.roaringbitmap.longlong.LongUtils;

public class Node48
extends Node {
    long[] childIndex = new long[32];
    Node[] children = new Node[48];
    static final byte EMPTY_VALUE = -1;
    static final long INIT_LONG_VALUE = -1L;

    public Node48(int compressedPrefixSize) {
        super(NodeType.NODE48, compressedPrefixSize);
        Arrays.fill(this.childIndex, -1L);
    }

    @Override
    public int getChildPos(byte k) {
        int unsignedIdx = Byte.toUnsignedInt(k);
        byte childIdx = Node48.childrenIdx(unsignedIdx, this.childIndex);
        if (childIdx != -1) {
            return unsignedIdx;
        }
        return -1;
    }

    @Override
    public byte getChildKey(int pos) {
        return (byte)pos;
    }

    @Override
    public Node getChild(int pos) {
        byte idx = Node48.childrenIdx(pos, this.childIndex);
        return this.children[idx];
    }

    @Override
    public void replaceNode(int pos, Node freshOne) {
        byte idx = Node48.childrenIdx(pos, this.childIndex);
        this.children[idx] = freshOne;
    }

    @Override
    public int getMinPos() {
        int pos = 0;
        for (int i = 0; i < 32; ++i) {
            long longv = this.childIndex[i];
            if (longv == -1L) {
                pos += 8;
                continue;
            }
            for (int j = 0; j <= 7; ++j) {
                byte v = (byte)(longv >>> (7 - j) * 8);
                if (v != -1) {
                    return pos;
                }
                ++pos;
            }
        }
        return -1;
    }

    @Override
    public int getNextLargerPos(int pos) {
        if (pos == -1) {
            pos = -1;
        }
        int offset = pos & 7;
        for (int i = ++pos >>> 3; i < 32; ++i) {
            long longv = this.childIndex[i];
            if (offset == 0 && longv == -1L) {
                pos += 8;
                continue;
            }
            for (int j = offset; j <= 7; ++j) {
                int shiftNum = (7 - j) * 8;
                byte v = (byte)(longv >>> shiftNum);
                if (v != -1) {
                    return pos;
                }
                ++pos;
            }
            offset = 0;
        }
        return -1;
    }

    @Override
    public int getMaxPos() {
        int pos = 255;
        for (int i = 31; i >= 0; --i) {
            long longv = this.childIndex[i];
            if (longv == -1L) {
                pos -= 8;
                continue;
            }
            for (int j = 0; j <= 7; ++j) {
                byte v = (byte)(longv >>> j * 8);
                if (v != -1) {
                    return pos;
                }
                --pos;
            }
        }
        return -1;
    }

    @Override
    public int getNextSmallerPos(int pos) {
        if (pos == -1) {
            pos = 256;
        }
        int offset = pos & 7;
        for (int i = --pos >>> 3; i < 32; ++i) {
            long longv = this.childIndex[i];
            if (offset == 0 && longv == -1L) {
                pos -= 8;
                continue;
            }
            for (int j = offset; j <= 7; ++j) {
                int shiftNum = j * 8;
                byte v = (byte)(longv >>> shiftNum);
                if (v != -1) {
                    return pos;
                }
                --pos;
            }
            offset = 0;
        }
        return -1;
    }

    public static Node insert(Node currentNode, Node child, byte key) {
        Node48 node48 = (Node48)currentNode;
        if (node48.count < 48) {
            int pos = node48.count;
            if (node48.children[pos] != null) {
                pos = 0;
                while (node48.children[pos] != null) {
                    ++pos;
                }
            }
            node48.children[pos] = child;
            int unsignedByte = Byte.toUnsignedInt(key);
            int longPosition = unsignedByte >>> 3;
            int bytePosition = unsignedByte & 7;
            long original = node48.childIndex[longPosition];
            byte[] bytes = LongUtils.toBDBytes(original);
            bytes[bytePosition] = (byte)pos;
            node48.childIndex[longPosition] = LongUtils.fromBDBytes(bytes);
            node48.count = (short)(node48.count + 1);
            return node48;
        }
        Node256 node256 = new Node256(node48.prefixLength);
        int currentPos = -1;
        while ((currentPos = node48.getNextLargerPos(currentPos)) != -1) {
            Node childNode;
            node256.children[currentPos] = childNode = node48.getChild(currentPos);
            Node256.setBit((byte)currentPos, node256.bitmapMask);
        }
        node256.count = node48.count;
        Node48.copyPrefix(node48, node256);
        Node256 freshOne = Node256.insert(node256, child, key);
        return freshOne;
    }

    @Override
    public Node remove(int pos) {
        long newLong;
        int longPos = pos >>> 3;
        int bytePos = pos & 7;
        long longVal = this.childIndex[longPos];
        byte idx = (byte)(longVal >>> (7 - bytePos) * 8);
        byte[] bytes = LongUtils.toBDBytes(longVal);
        bytes[bytePos] = -1;
        this.childIndex[longPos] = newLong = LongUtils.fromBDBytes(bytes);
        this.children[idx] = null;
        this.count = (short)(this.count - 1);
        if (this.count <= 12) {
            Node16 node16 = new Node16(this.prefixLength);
            int j = 0;
            ByteBuffer byteBuffer = ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN);
            int currentPos = -1;
            while ((currentPos = this.getNextLargerPos(currentPos)) != -1) {
                Node child = this.getChild(currentPos);
                byteBuffer.put(j, (byte)currentPos);
                node16.children[j] = child;
                ++j;
            }
            node16.firstV = byteBuffer.getLong(0);
            node16.secondV = byteBuffer.getLong(8);
            node16.count = (short)j;
            Node48.copyPrefix(this, node16);
            return node16;
        }
        return this;
    }

    @Override
    public void serializeNodeBody(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < 32; ++i) {
            long longv = this.childIndex[i];
            dataOutput.writeLong(Long.reverseBytes(longv));
        }
    }

    @Override
    public void serializeNodeBody(ByteBuffer byteBuffer) throws IOException {
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        longBuffer.put(this.childIndex);
        byteBuffer.position(byteBuffer.position() + 256);
    }

    @Override
    public void deserializeNodeBody(DataInput dataInput) throws IOException {
        for (int i = 0; i < 32; ++i) {
            this.childIndex[i] = Long.reverseBytes(dataInput.readLong());
        }
    }

    @Override
    public void deserializeNodeBody(ByteBuffer byteBuffer) throws IOException {
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        longBuffer.get(this.childIndex);
        byteBuffer.position(byteBuffer.position() + 256);
    }

    @Override
    public int serializeNodeBodySizeInBytes() {
        return 256;
    }

    @Override
    public void replaceChildren(Node[] children) {
        int step = 0;
        for (int i = 0; i < 32; ++i) {
            long longv = this.childIndex[i];
            for (int j = 7; j >= 0; --j) {
                byte bytePos = (byte)(longv >>> j * 8);
                int unsignedPos = Byte.toUnsignedInt(bytePos);
                if (bytePos == -1) continue;
                this.children[unsignedPos] = children[step];
                ++step;
            }
        }
    }

    private static byte childrenIdx(int pos, long[] childIndex) {
        int longPos = pos >>> 3;
        int bytePos = pos & 7;
        long longv = childIndex[longPos];
        byte idx = (byte)(longv >>> (7 - bytePos) * 8);
        return idx;
    }

    static void setOneByte(int pos, byte v, long[] childIndex) {
        int longPos = pos >>> 3;
        int bytePos = pos & 7;
        long preVal = childIndex[longPos];
        byte[] bytes = LongUtils.toBDBytes(preVal);
        bytes[bytePos] = v;
        childIndex[longPos] = LongUtils.fromBDBytes(bytes);
    }
}

