/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.revapi.Difference;
import org.revapi.Element;

public abstract class DifferenceMatchRecipe {
    final ModelNode config;
    final boolean regex;
    final String code;
    final Pattern codeRegex;
    final String oldElement;
    final Pattern oldElementRegex;
    final String newElement;
    final Pattern newElementRegex;
    final Map<String, String> attachments;
    final Map<String, Pattern> attachmentRegexes;

    protected DifferenceMatchRecipe(ModelNode config, String ... additionalReservedProperties) {
        if (!config.has("code")) {
            throw new IllegalArgumentException("Difference code has to be specified.");
        }
        HashSet<String> reservedProperties = new HashSet<String>(4 + additionalReservedProperties.length);
        reservedProperties.add("regex");
        reservedProperties.add("code");
        reservedProperties.add("old");
        reservedProperties.add("new");
        for (String p : additionalReservedProperties) {
            reservedProperties.add(p);
        }
        this.regex = config.has("regex") && config.get("regex").asBoolean();
        this.code = config.get("code").asString();
        this.codeRegex = this.regex ? Pattern.compile(this.code) : null;
        this.oldElement = DifferenceMatchRecipe.getElement(config.get("old"));
        this.oldElementRegex = this.regex && this.oldElement != null ? Pattern.compile(this.oldElement) : null;
        this.newElement = DifferenceMatchRecipe.getElement(config.get("new"));
        this.newElementRegex = this.regex && this.newElement != null ? Pattern.compile(this.newElement) : null;
        this.attachments = DifferenceMatchRecipe.getAttachments(config, reservedProperties);
        this.attachmentRegexes = this.regex ? this.attachments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Pattern.compile((String)e.getValue()))) : null;
        this.config = config;
    }

    public boolean matches(Difference difference, @Nullable Element oldElement, @Nullable Element newElement) {
        boolean baseMatch;
        if (this.regex) {
            boolean baseMatch2;
            boolean bl = baseMatch2 = this.codeRegex.matcher(difference.code).matches() && this.regexMatches(this.oldElementRegex, oldElement) && this.regexMatches(this.newElementRegex, newElement);
            if (!baseMatch2) {
                return false;
            }
            boolean allMatched = this.attachmentRegexes.isEmpty() || !difference.attachments.isEmpty();
            for (Map.Entry e : difference.attachments.entrySet()) {
                String key = (String)e.getKey();
                String val = (String)e.getValue();
                Pattern match = this.attachmentRegexes.get(key);
                if (match != null && !match.matcher(val).matches()) {
                    return false;
                }
                allMatched = true;
            }
            return allMatched;
        }
        boolean bl = baseMatch = this.code.equals(difference.code) && this.equalMatches(this.oldElement, oldElement) && this.equalMatches(this.newElement, newElement);
        if (!baseMatch) {
            return false;
        }
        boolean allMatched = this.attachments.isEmpty() || !difference.attachments.isEmpty();
        for (Map.Entry e : difference.attachments.entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            String match = this.attachments.get(key);
            if (match != null && !match.equals(val)) {
                return false;
            }
            allMatched = true;
        }
        return allMatched;
    }

    public abstract Difference transformMatching(Difference var1, Element var2, Element var3);

    private static String getElement(ModelNode elementRoot) {
        if (!elementRoot.isDefined()) {
            return null;
        }
        return elementRoot.getType() == ModelType.STRING ? elementRoot.asString() : null;
    }

    private static Map<String, String> getAttachments(ModelNode elementRoot, Set<String> reservedProperties) {
        if (!elementRoot.isDefined()) {
            return Collections.emptyMap();
        }
        if (elementRoot.getType() != ModelType.OBJECT) {
            return Collections.emptyMap();
        }
        Set keys = elementRoot.keys();
        HashMap<String, String> ret = new HashMap<String, String>(keys.size());
        for (String key : keys) {
            if (reservedProperties.contains(key)) continue;
            ret.put(key, elementRoot.get(key).asString());
        }
        return ret;
    }

    private boolean regexMatches(@Nullable Pattern regex, @Nullable Element element) {
        return regex == null || element != null && regex.matcher(element.getFullHumanReadableString()).matches();
    }

    private boolean equalMatches(@Nullable String blueprint, @Nullable Element element) {
        return blueprint == null || element != null && blueprint.equals(element.getFullHumanReadableString());
    }
}

