/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.resource;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.engine.resource.AnnotationInfo;
import org.restlet.engine.resource.MethodAnnotationInfo;
import org.restlet.engine.resource.ThrowableAnnotationInfo;
import org.restlet.representation.Representation;
import org.restlet.resource.ServerResource;
import org.restlet.resource.Status;
import org.restlet.service.ConverterService;
import org.restlet.service.MetadataService;

public class AnnotationUtils {
    private static final ConcurrentMap<Class<?>, List<AnnotationInfo>> cache = new ConcurrentHashMap();
    private static AnnotationUtils instance = new AnnotationUtils();

    public static AnnotationUtils getInstance() {
        return instance;
    }

    protected AnnotationUtils() {
    }

    private List<AnnotationInfo> addAnnotations(List<AnnotationInfo> descriptors, Class<?> clazz, Class<?> initialClass) {
        List<AnnotationInfo> result = descriptors;
        if (clazz != null && !ServerResource.class.equals(clazz)) {
            Class<?>[] interfaces;
            if (result == null) {
                result = new CopyOnWriteArrayList<AnnotationInfo>();
            }
            this.addThrowableAnnotationDescriptors(result, clazz, initialClass);
            if (clazz.isInterface()) {
                for (java.lang.reflect.Method javaMethod : clazz.getMethods()) {
                    this.addMethodAnnotationDescriptors(result, clazz, initialClass, javaMethod);
                }
            } else {
                for (java.lang.reflect.Method javaMethod : clazz.getDeclaredMethods()) {
                    this.addMethodAnnotationDescriptors(result, clazz, initialClass, javaMethod);
                }
            }
            if ((interfaces = clazz.getInterfaces()) != null) {
                for (Class<?> interfaceClass : interfaces) {
                    result = this.addAnnotations(result, interfaceClass, initialClass);
                }
            }
            this.addAnnotations(result, clazz.getSuperclass(), initialClass);
        }
        return result;
    }

    private List<AnnotationInfo> addMethodAnnotationDescriptors(List<AnnotationInfo> descriptors, Class<?> clazz, Class<?> initialClass, java.lang.reflect.Method javaMethod) {
        List<AnnotationInfo> result = descriptors;
        for (Annotation annotation : javaMethod.getAnnotations()) {
            org.restlet.engine.connector.Method methodAnnotation = annotation.annotationType().getAnnotation(org.restlet.engine.connector.Method.class);
            Method restletMethod = this.getRestletMethod(annotation, methodAnnotation);
            if (restletMethod == null) continue;
            if (result == null) {
                result = new CopyOnWriteArrayList<AnnotationInfo>();
            }
            try {
                java.lang.reflect.Method valueMethod = annotation.getClass().getDeclaredMethod("value", new Class[0]);
                String value = (String)valueMethod.invoke((Object)annotation, new Object[0]);
                result.add(new MethodAnnotationInfo(initialClass, restletMethod, javaMethod, value));
            }
            catch (Exception exception) {
                Context.getCurrentLogger().info("Cannot get value of Restlet annotation: " + annotation + " due to " + exception.getMessage());
            }
        }
        for (Class<?> exceptionClass : javaMethod.getExceptionTypes()) {
            for (Annotation annotation : exceptionClass.getAnnotations()) {
                Status statusAnnotation = annotation.annotationType().getAnnotation(Status.class);
                if (statusAnnotation == null) continue;
                int code = statusAnnotation.value();
                boolean serializable = statusAnnotation.serialize();
                if (result == null) {
                    result = new CopyOnWriteArrayList<AnnotationInfo>();
                }
                result.add(new ThrowableAnnotationInfo(initialClass, code, serializable));
            }
        }
        return result;
    }

    private List<AnnotationInfo> addThrowableAnnotationDescriptors(List<AnnotationInfo> descriptors, Class<?> clazz, Class<?> initialClass) {
        List<AnnotationInfo> result = descriptors;
        Status annotation = clazz.getAnnotation(Status.class);
        if (annotation != null) {
            Status status = annotation;
            result.add(new ThrowableAnnotationInfo(initialClass, status.value(), status.serialize()));
        }
        return result;
    }

    public void clearCache() {
        cache.clear();
    }

    public synchronized List<AnnotationInfo> getAnnotations(Class<?> clazz) {
        List<AnnotationInfo> prev;
        List<AnnotationInfo> result = (List<AnnotationInfo>)cache.get(clazz);
        if (result == null && (prev = cache.putIfAbsent(clazz, result = this.addAnnotations(result, clazz, clazz))) != null) {
            result = prev;
        }
        return result;
    }

    public List<AnnotationInfo> getAnnotations(Class<?> clazz, java.lang.reflect.Method javaMethod) {
        return this.addMethodAnnotationDescriptors(null, clazz, clazz, javaMethod);
    }

    public MethodAnnotationInfo getMethodAnnotation(List<AnnotationInfo> annotations, java.lang.reflect.Method javaMethod) {
        if (annotations != null) {
            for (AnnotationInfo annotationInfo : annotations) {
                if (!(annotationInfo instanceof MethodAnnotationInfo) || !annotationInfo.getJavaMethod().equals(javaMethod)) continue;
                return (MethodAnnotationInfo)annotationInfo;
            }
        }
        return null;
    }

    public MethodAnnotationInfo getMethodAnnotation(List<AnnotationInfo> annotations, Method restletMethod, Form query, Representation entity, MetadataService metadataService, ConverterService converterService) throws IOException {
        if (annotations != null) {
            for (AnnotationInfo annotationInfo : annotations) {
                if (!(annotationInfo instanceof MethodAnnotationInfo) || !((MethodAnnotationInfo)annotationInfo).isCompatible(restletMethod, query, entity, metadataService, converterService)) continue;
                return (MethodAnnotationInfo)annotationInfo;
            }
        }
        return null;
    }

    protected Method getRestletMethod(Annotation annotation, Annotation methodAnnotation) {
        return methodAnnotation == null ? null : Method.valueOf(((org.restlet.engine.connector.Method)methodAnnotation).value());
    }

    public ThrowableAnnotationInfo getThrowableAnnotationInfo(Class<?> clazz) {
        List<AnnotationInfo> annotationInfos = this.getAnnotations(clazz);
        for (AnnotationInfo annotationInfo : annotationInfos) {
            if (!(annotationInfo instanceof ThrowableAnnotationInfo)) continue;
            return (ThrowableAnnotationInfo)annotationInfo;
        }
        return null;
    }

    public ThrowableAnnotationInfo getThrowableAnnotationInfo(java.lang.reflect.Method javaMethod, int errorCode) {
        for (Class<?> clazz : javaMethod.getExceptionTypes()) {
            ThrowableAnnotationInfo tai = this.getThrowableAnnotationInfo(clazz);
            if (tai == null || tai.getStatus().getCode() != errorCode) continue;
            return tai;
        }
        return null;
    }

    public Class<?> getThrowableClass(java.lang.reflect.Method javaMethod, int errorCode) {
        for (Class<?> clazz : javaMethod.getExceptionTypes()) {
            ThrowableAnnotationInfo tai = this.getThrowableAnnotationInfo(clazz);
            if (tai == null || tai.getStatus().getCode() != errorCode) continue;
            return clazz;
        }
        return null;
    }
}

