/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.p2.resolver.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ArtifactResolutionRequest {
    private final String rootArtifactId;
    private final List<String> excludes;
    private final boolean resolveTransitive;
    private final boolean resolveSource;

    private ArtifactResolutionRequest(String rootArtifactId, List<String> excludes, boolean resolveTransitive, boolean resolveSource) {
        this.rootArtifactId = rootArtifactId;
        this.excludes = excludes;
        this.resolveTransitive = resolveTransitive;
        this.resolveSource = resolveSource;
    }

    public String getRootArtifactId() {
        return this.rootArtifactId;
    }

    public List<String> getExcludes() {
        return Collections.unmodifiableList(this.excludes);
    }

    public boolean isResolveTransitive() {
        return this.resolveTransitive;
    }

    public boolean isResolveSource() {
        return this.resolveSource;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String rootArtifactId;
        private List<String> excludes;
        private boolean resolveTransitive;
        private boolean resolveSource;

        public Builder rootArtifactId(String rootArtifactId) {
            this.rootArtifactId = rootArtifactId;
            return this;
        }

        public Builder excludes(List<String> excludes) {
            this.excludes = new ArrayList<String>(excludes);
            return this;
        }

        public Builder resolveTransitive(boolean resolveTransitive) {
            this.resolveTransitive = resolveTransitive;
            return this;
        }

        public Builder resolveSource(boolean resolveSource) {
            this.resolveSource = resolveSource;
            return this;
        }

        public ArtifactResolutionRequest build() {
            return new ArtifactResolutionRequest(this.rootArtifactId, this.excludes, this.resolveTransitive, this.resolveSource);
        }
    }
}

