/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.redisson.SlotCallback;
import org.redisson.api.RFuture;
import org.redisson.api.RScript;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.spring.data.connection.BinaryConvertor;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.data.redis.connection.ReactiveScriptingCommands;
import org.springframework.data.redis.connection.ReturnType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveScriptingCommands
extends RedissonBaseReactive
implements ReactiveScriptingCommands {
    RedissonReactiveScriptingCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    public Mono<String> scriptFlush() {
        return this.executorService.reactive(() -> {
            RFuture f = this.executorService.writeAllAsync((RedisCommand)RedisCommands.SCRIPT_FLUSH, new Object[0]);
            return this.toStringFuture((RFuture<Void>)f);
        });
    }

    public Mono<String> scriptKill() {
        throw new UnsupportedOperationException();
    }

    public Mono<String> scriptLoad(ByteBuffer script) {
        return this.executorService.reactive(() -> this.executorService.writeAllAsync((Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.SCRIPT_LOAD, (SlotCallback)new SlotCallback<String, String>(){
            volatile String result;

            public void onSlotResult(String result) {
                this.result = result;
            }

            public String onFinish() {
                return this.result;
            }
        }, new Object[]{RedissonReactiveScriptingCommands.toByteArray(script)}));
    }

    public Flux<Boolean> scriptExists(final List<String> scriptShas) {
        Mono m = this.executorService.reactive(() -> this.executorService.writeAllAsync((RedisCommand)RedisCommands.SCRIPT_EXISTS, (SlotCallback)new SlotCallback<List<Boolean>, List<Boolean>>(){
            List result;
            {
                this.result = new ArrayList(scriptShas.size());
            }

            public synchronized void onSlotResult(List<Boolean> result) {
                for (int i = 0; i < result.size(); ++i) {
                    if (this.result.size() == i) {
                        this.result.add(false);
                    }
                    this.result.set(i, (Boolean)this.result.get(i) | result.get(i));
                }
            }

            public List<Boolean> onFinish() {
                return this.result;
            }
        }, scriptShas.toArray()));
        return m.flatMapMany(v -> Flux.fromIterable((Iterable)v));
    }

    protected RedisCommand<?> toCommand(ReturnType returnType, String name) {
        RedisCommand c = null;
        if (returnType == ReturnType.BOOLEAN) {
            c = RScript.ReturnType.BOOLEAN.getCommand();
        } else if (returnType == ReturnType.INTEGER) {
            c = RScript.ReturnType.INTEGER.getCommand();
        } else {
            if (returnType == ReturnType.MULTI) {
                c = RScript.ReturnType.MULTI.getCommand();
                return new RedisCommand(c, name, (Convertor)new BinaryConvertor());
            }
            if (returnType == ReturnType.STATUS) {
                c = RScript.ReturnType.STATUS.getCommand();
            } else if (returnType == ReturnType.VALUE) {
                c = RScript.ReturnType.VALUE.getCommand();
                return new RedisCommand(c, name, (Convertor)new BinaryConvertor());
            }
        }
        return new RedisCommand(c, name);
    }

    public <T> Flux<T> eval(ByteBuffer script, ReturnType returnType, int numKeys, ByteBuffer ... keysAndArgs) {
        RedisCommand<?> c = this.toCommand(returnType, "EVAL");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(RedissonReactiveScriptingCommands.toByteArray(script));
        params.add(numKeys);
        params.addAll(Arrays.stream(keysAndArgs).map(m -> RedissonReactiveScriptingCommands.toByteArray(m)).collect(Collectors.toList()));
        Mono m2 = this.write(null, (Codec)ByteArrayCodec.INSTANCE, c, params.toArray());
        return this.convert(m2);
    }

    protected <T> Flux<T> convert(Mono<T> m) {
        return m.map(e -> {
            if (e.getClass().isArray()) {
                return ByteBuffer.wrap((byte[])e);
            }
            if (e instanceof List && ((List)e).get(0).getClass().isArray()) {
                return ((List)e).stream().map(v -> ByteBuffer.wrap(v)).collect(Collectors.toList());
            }
            return e;
        }).flux();
    }

    public <T> Flux<T> evalSha(String scriptSha, ReturnType returnType, int numKeys, ByteBuffer ... keysAndArgs) {
        RedisCommand<?> c = this.toCommand(returnType, "EVALSHA");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(scriptSha);
        params.add(numKeys);
        params.addAll(Arrays.stream(keysAndArgs).map(m -> RedissonReactiveScriptingCommands.toByteArray(m)).collect(Collectors.toList()));
        Mono m2 = this.write(null, (Codec)ByteArrayCodec.INSTANCE, c, params.toArray());
        return this.convert(m2);
    }
}

