/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket.codec;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.red5.net.websocket.WebSocketConnection;
import org.red5.net.websocket.model.HandshakeRequest;
import org.red5.net.websocket.model.HandshakeResponse;
import org.red5.net.websocket.model.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketEncoder
extends ProtocolEncoderAdapter {
    private static final Logger log = LoggerFactory.getLogger(WebSocketEncoder.class);

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        IoBuffer resultBuffer;
        WebSocketConnection conn = (WebSocketConnection)session.getAttribute((Object)"connection");
        if (message instanceof Packet) {
            Packet packet = (Packet)message;
            resultBuffer = conn.isWebConnection() ? WebSocketEncoder.encodeOutgoingData(packet) : packet.getData();
        } else if (message instanceof HandshakeResponse) {
            HandshakeResponse resp = (HandshakeResponse)message;
            resultBuffer = resp.getResponse();
        } else if (message instanceof HandshakeRequest) {
            HandshakeRequest req = (HandshakeRequest)message;
            resultBuffer = req.getRequest();
        } else {
            throw new Exception("message not a websocket type");
        }
        out.write((Object)resultBuffer);
    }

    public static IoBuffer encodeOutgoingData(Packet packet) {
        log.debug("encode outgoing: {}", (Object)packet);
        IoBuffer data = packet.getData();
        int frameLen = data.limit();
        IoBuffer buffer = IoBuffer.allocate((int)(frameLen + 2), (boolean)false);
        buffer.setAutoExpand(true);
        byte frameInfo = -128;
        switch (packet.getType()) {
            case TEXT: {
                if (log.isTraceEnabled()) {
                    log.trace("Encoding text frame  \r\n{}", (Object)new String(packet.getData().array()));
                }
                frameInfo = (byte)(frameInfo | 1);
                break;
            }
            case BINARY: {
                log.trace("Encoding binary frame");
                frameInfo = (byte)(frameInfo | 2);
                break;
            }
            case CLOSE: {
                frameInfo = (byte)(frameInfo | 8);
                break;
            }
            case CONTINUATION: {
                frameInfo = (byte)(frameInfo | 0);
                break;
            }
            case PING: {
                log.trace("ping out");
                frameInfo = (byte)(frameInfo | 9);
                break;
            }
            case PONG: {
                log.trace("pong out");
                frameInfo = (byte)(frameInfo | 0xA);
                break;
            }
        }
        buffer.put(frameInfo);
        log.trace("Frame length {} ", (Object)frameLen);
        if (frameLen <= 125) {
            buffer.put((byte)((byte)frameLen & 0x7F));
        } else if (frameLen > 125 && frameLen <= 65535) {
            buffer.put((byte)126);
            buffer.putShort((short)frameLen);
        } else {
            buffer.put((byte)127);
            buffer.putLong((long)frameLen);
        }
        buffer.put(data);
        buffer.flip();
        if (log.isTraceEnabled()) {
            log.trace("Encoded: {}", (Object)buffer);
        }
        return buffer;
    }
}

