/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket.codec;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.bouncycastle.util.encoders.Base64;
import org.red5.net.websocket.Constants;
import org.red5.net.websocket.WebSocketConnection;
import org.red5.net.websocket.WebSocketException;
import org.red5.net.websocket.WebSocketPlugin;
import org.red5.net.websocket.WebSocketScopeManager;
import org.red5.net.websocket.listener.IWebSocketDataListener;
import org.red5.net.websocket.model.ConnectionType;
import org.red5.net.websocket.model.HandshakeResponse;
import org.red5.net.websocket.model.MessageType;
import org.red5.net.websocket.model.WSMessage;
import org.red5.server.plugin.PluginRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketDecoder
extends CumulativeProtocolDecoder {
    private static final Logger log = LoggerFactory.getLogger(WebSocketDecoder.class);
    private static final String DECODER_STATE_KEY = "decoder-state";
    private static final String DECODED_MESSAGE_KEY = "decoded-message";
    private static final String DECODED_MESSAGE_TYPE_KEY = "decoded-message-type";
    private static final String DECODED_MESSAGE_FRAGMENTS_KEY = "decoded-message-fragments";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        WebSocketConnection conn = (WebSocketConnection)session.getAttribute((Object)"connection");
        if (conn == null) {
            if (this.doHandShake(session, in)) {
                in.position(in.limit());
                return true;
            }
            IoBuffer resultBuffer = IoBuffer.wrap((byte[])in.array(), (int)0, (int)in.limit());
            in.position(in.limit());
            out.write((Object)resultBuffer);
            return true;
        } else if (conn.isWebConnection()) {
            DecoderState decoderState = (DecoderState)session.getAttribute((Object)DECODER_STATE_KEY);
            if (decoderState == null) {
                decoderState = new DecoderState();
                session.setAttribute((Object)DECODER_STATE_KEY, (Object)decoderState);
            }
            WebSocketDecoder.decodeIncommingData(in, session);
            WSMessage message = (WSMessage)session.getAttribute((Object)DECODED_MESSAGE_KEY);
            if (log.isTraceEnabled()) {
                log.trace("State: {} message: {}", (Object)decoderState, (Object)message);
            }
            if (message == null) return false;
            message.setConnection(conn);
            out.write((Object)message);
            session.removeAttribute((Object)DECODED_MESSAGE_KEY);
            return true;
        } else {
            IoBuffer resultBuffer = IoBuffer.wrap((byte[])in.array(), (int)0, (int)in.limit());
            in.position(in.limit());
            out.write((Object)resultBuffer);
        }
        return true;
    }

    private boolean doHandShake(IoSession session, IoBuffer in) {
        WebSocketConnection conn = new WebSocketConnection(session);
        if (session.getFilterChain().contains("sslFilter")) {
            conn.setSecure(true);
        }
        try {
            Map<String, Object> headers = this.parseClientRequest(conn, new String(in.array()));
            if (log.isTraceEnabled()) {
                log.trace("Header map: {}", headers);
            }
            if (!headers.isEmpty() && headers.containsKey("Sec-WebSocket-Key")) {
                WebSocketScopeManager manager = ((WebSocketPlugin)PluginRegistry.getPlugin((String)"WebSocketPlugin")).getManager();
                conn.setHeaders(headers);
                if (headers.containsKey("querystring-parameters")) {
                    conn.setQuerystringParameters((Map)headers.remove("querystring-parameters"));
                }
                if (!"13".equals(headers.get("Sec-WebSocket-Version"))) {
                    log.info("Version 13 was not found in the request, communications may fail");
                }
                if (headers.containsKey("Sec-WebSocket-Protocol")) {
                    boolean protocolSupported = false;
                    String protocol = (String)headers.get("Sec-WebSocket-Protocol");
                    log.debug("Protocol '{}' found in the request", (Object)protocol);
                    conn.setProtocol(protocol);
                    Set<IWebSocketDataListener> listeners = manager.getScope(conn.getPath()).getListeners();
                    for (IWebSocketDataListener listener : listeners) {
                        if (!listener.getProtocol().equals(protocol)) continue;
                        protocolSupported = true;
                        break;
                    }
                    log.debug("Scope listener does{} support the '{}' protocol", (Object)(protocolSupported ? "" : "n't"), (Object)protocol);
                }
                session.setAttribute((Object)"connection", (Object)conn);
                conn.setConnected();
                manager.addConnection(conn);
                HandshakeResponse wsResponse = this.buildHandshakeResponse(conn, (String)headers.get("Sec-WebSocket-Key"));
                session.write((Object)wsResponse);
                log.debug("Handshake complete");
                return true;
            }
            conn.setType(ConnectionType.DIRECT);
        }
        catch (Exception e) {
            log.warn("Handshake failed", (Throwable)e);
        }
        return false;
    }

    private Map<String, Object> parseClientRequest(WebSocketConnection conn, String requestData) throws WebSocketException {
        Object[] request = requestData.split("\r\n");
        if (log.isTraceEnabled()) {
            log.trace("Request: {}", (Object)Arrays.toString(request));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < request.length; ++i) {
            log.trace("Request {}: {}", (Object)i, request[i]);
            if (((String)request[i]).startsWith("GET ") || ((String)request[i]).startsWith("POST ") || ((String)request[i]).startsWith("PUT ")) {
                WebSocketPlugin plugin;
                String requestPath = ((String)request[i]).split("\\s+")[1];
                int start = requestPath.indexOf(47);
                int end = requestPath.length();
                int ques = requestPath.indexOf(63);
                if (ques > 0) {
                    end = ques;
                }
                log.trace("Request path: {} to {} ques: {}", new Object[]{start, end, ques});
                String path = requestPath.substring(start, end).trim();
                log.trace("Client request path: {}", (Object)path);
                conn.setPath(path);
                if (ques > 0) {
                    String qs = requestPath.substring(ques).trim();
                    log.trace("Request querystring: {}", (Object)qs);
                    map.put("querystring-parameters", WebSocketDecoder.parseQuerystring(qs));
                }
                if ((plugin = (WebSocketPlugin)PluginRegistry.getPlugin((String)"WebSocketPlugin")) != null) {
                    log.trace("Found plugin");
                    WebSocketScopeManager manager = plugin.getManager();
                    log.trace("Manager was found? : {}", (Object)manager);
                    if (manager != null && manager.isEnabled(path)) {
                        log.trace("Path enabled: {}", (Object)path);
                        continue;
                    }
                    HandshakeResponse errResponse = this.build400Response(conn);
                    WriteFuture future = conn.getSession().write((Object)errResponse);
                    future.addListener((IoFutureListener)new IoFutureListener<IoFuture>(){

                        public void operationComplete(IoFuture future) {
                            future.getSession().closeOnFlush();
                        }
                    });
                    throw new WebSocketException("Handshake failed, path not enabled");
                }
                log.warn("Plugin lookup failed");
                HandshakeResponse errResponse = this.build400Response(conn);
                WriteFuture future = conn.getSession().write((Object)errResponse);
                future.addListener((IoFutureListener)new IoFutureListener<IoFuture>(){

                    public void operationComplete(IoFuture future) {
                        future.getSession().closeOnFlush();
                    }
                });
                throw new WebSocketException("Handshake failed, missing plugin");
            }
            if (((String)request[i]).contains("Sec-WebSocket-Key")) {
                map.put("Sec-WebSocket-Key", this.extractHeaderValue((String)request[i]));
                continue;
            }
            if (((String)request[i]).contains("Sec-WebSocket-Version")) {
                map.put("Sec-WebSocket-Version", this.extractHeaderValue((String)request[i]));
                continue;
            }
            if (((String)request[i]).contains("Sec-WebSocket-Extensions")) {
                map.put("Sec-WebSocket-Extensions", this.extractHeaderValue((String)request[i]));
                continue;
            }
            if (((String)request[i]).contains("Sec-WebSocket-Protocol")) {
                map.put("Sec-WebSocket-Protocol", this.extractHeaderValue((String)request[i]));
                continue;
            }
            if (((String)request[i]).contains("Host")) {
                conn.setHost(this.extractHeaderValue((String)request[i]));
                continue;
            }
            if (((String)request[i]).contains("Origin")) {
                conn.setOrigin(this.extractHeaderValue((String)request[i]));
                continue;
            }
            if (!((String)request[i]).contains("User-Agent")) continue;
            map.put("User-Agent", this.extractHeaderValue((String)request[i]));
        }
        return map;
    }

    private String extractHeaderValue(String requestHeader) {
        return requestHeader.substring(requestHeader.indexOf(58) + 1).trim();
    }

    private HandshakeResponse buildHandshakeResponse(WebSocketConnection conn, String clientKey) throws WebSocketException {
        byte[] accept;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            accept = Base64.encode((byte[])md.digest((clientKey + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new WebSocketException("Algorithm is missing");
        }
        IoBuffer buf = IoBuffer.allocate((int)308);
        buf.setAutoExpand(true);
        buf.put("HTTP/1.1 101 Switching Protocols".getBytes());
        buf.put(Constants.CRLF);
        buf.put("Upgrade: websocket".getBytes());
        buf.put(Constants.CRLF);
        buf.put("Connection: Upgrade".getBytes());
        buf.put(Constants.CRLF);
        buf.put("Server: Red5".getBytes());
        buf.put(Constants.CRLF);
        buf.put("Sec-WebSocket-Version-Server: 13".getBytes());
        buf.put(Constants.CRLF);
        buf.put(String.format("Sec-WebSocket-Origin: %s", conn.getOrigin()).getBytes());
        buf.put(Constants.CRLF);
        buf.put(String.format("Sec-WebSocket-Location: %s", conn.getHost()).getBytes());
        buf.put(Constants.CRLF);
        if (conn.hasExtensions()) {
            buf.put(String.format("Sec-WebSocket-Extensions: %s", conn.getExtensionsAsString()).getBytes());
            buf.put(Constants.CRLF);
        }
        if (conn.hasProtocol()) {
            buf.put(String.format("Sec-WebSocket-Protocol: %s", conn.getProtocol()).getBytes());
            buf.put(Constants.CRLF);
        }
        buf.put(String.format("Sec-WebSocket-Accept: %s", new String(accept)).getBytes());
        buf.put(Constants.CRLF);
        buf.put(Constants.CRLF);
        if (log.isTraceEnabled()) {
            log.trace("Handshake response size: {}", (Object)buf.limit());
        }
        return new HandshakeResponse(buf);
    }

    private HandshakeResponse build400Response(WebSocketConnection conn) throws WebSocketException {
        IoBuffer buf = IoBuffer.allocate((int)32);
        buf.setAutoExpand(true);
        buf.put("HTTP/1.1 400 Bad Request".getBytes());
        buf.put(Constants.CRLF);
        buf.put("Sec-WebSocket-Version-Server: 13".getBytes());
        buf.put(Constants.CRLF);
        buf.put(Constants.CRLF);
        if (log.isTraceEnabled()) {
            log.trace("Handshake error response size: {}", (Object)buf.limit());
        }
        return new HandshakeResponse(buf);
    }

    public static void decodeIncommingData(IoBuffer in, IoSession session) {
        log.trace("Decoding: {}", (Object)in);
        DecoderState decoderState = (DecoderState)session.getAttribute((Object)DECODER_STATE_KEY);
        if (decoderState.fin == -128) {
            byte frameInfo = in.get();
            decoderState.fin = (byte)(frameInfo >>> 7 & 1);
            log.trace("FIN: {}", (Object)decoderState.fin);
            decoderState.opCode = (byte)(frameInfo & 0xF);
            log.trace("Opcode: {}", (Object)decoderState.opCode);
        }
        if (decoderState.mask == -128) {
            byte frameInfo2 = in.get();
            decoderState.mask = (byte)(frameInfo2 >>> 7 & 1);
            log.trace("Mask: {}", (Object)decoderState.mask);
            decoderState.frameLen = frameInfo2 & 0x7F;
            log.trace("Payload length: {}", (Object)decoderState.frameLen);
            if (decoderState.frameLen == 126) {
                decoderState.frameLen = in.getShort();
                log.trace("Payload length updated: {}", (Object)decoderState.frameLen);
            } else if (decoderState.frameLen == 127) {
                long extendedLen = in.getLong();
                if (extendedLen >= Integer.MAX_VALUE) {
                    log.error("Data frame is too large for this implementation. Length: {}", (Object)extendedLen);
                } else {
                    decoderState.frameLen = (int)extendedLen;
                }
                log.trace("Payload length updated: {}", (Object)decoderState.frameLen);
            }
        }
        if (decoderState.frameLen + (decoderState.mask == 1 ? 4 : 0) > in.remaining()) {
            log.info("Not enough data available to decode, socket may be closed/closing");
        } else {
            if (decoderState.mask == 1) {
                int i;
                byte[] maskKey = new byte[4];
                for (i = 0; i < 4; ++i) {
                    maskKey[i] = in.get();
                }
                decoderState.payload = new byte[decoderState.frameLen];
                for (i = 0; i < decoderState.frameLen; ++i) {
                    byte maskedByte = in.get();
                    decoderState.payload[i] = (byte)(maskedByte ^ maskKey[i % 4]);
                }
            } else {
                decoderState.payload = new byte[decoderState.frameLen];
                in.get(decoderState.payload);
            }
            if (decoderState.fin == 0) {
                IoBuffer fragments = (IoBuffer)session.getAttribute((Object)DECODED_MESSAGE_FRAGMENTS_KEY);
                if (fragments == null) {
                    fragments = IoBuffer.allocate((int)decoderState.frameLen);
                    fragments.setAutoExpand(true);
                    session.setAttribute((Object)DECODED_MESSAGE_FRAGMENTS_KEY, (Object)fragments);
                    MessageType messageType = MessageType.CLOSE;
                    switch (decoderState.opCode) {
                        case 0: {
                            messageType = MessageType.CONTINUATION;
                            break;
                        }
                        case 1: {
                            messageType = MessageType.TEXT;
                            break;
                        }
                        case 2: {
                            messageType = MessageType.BINARY;
                            break;
                        }
                        case 9: {
                            messageType = MessageType.PING;
                            break;
                        }
                        case 10: {
                            messageType = MessageType.PONG;
                        }
                    }
                    session.setAttribute((Object)DECODED_MESSAGE_TYPE_KEY, (Object)messageType);
                }
                fragments.put(decoderState.payload);
                session.removeAttribute((Object)DECODER_STATE_KEY);
            } else {
                WSMessage message = new WSMessage();
                MessageType messageType = (MessageType)((Object)session.getAttribute((Object)DECODED_MESSAGE_TYPE_KEY));
                if (messageType == null) {
                    switch (decoderState.opCode) {
                        case 0: {
                            messageType = MessageType.CONTINUATION;
                            break;
                        }
                        case 1: {
                            messageType = MessageType.TEXT;
                            break;
                        }
                        case 2: {
                            messageType = MessageType.BINARY;
                            break;
                        }
                        case 9: {
                            messageType = MessageType.PING;
                            break;
                        }
                        case 10: {
                            messageType = MessageType.PONG;
                            break;
                        }
                        case 8: {
                            messageType = MessageType.CLOSE;
                            break;
                        }
                        default: {
                            log.info("Unhandled opcode: {}", (Object)decoderState.opCode);
                        }
                    }
                }
                message.setMessageType(messageType);
                IoBuffer fragments = (IoBuffer)session.removeAttribute((Object)DECODED_MESSAGE_FRAGMENTS_KEY);
                if (fragments != null) {
                    fragments.put(decoderState.payload);
                    fragments.flip();
                    message.setPayload(fragments);
                } else {
                    message.addPayload(decoderState.payload);
                }
                session.setAttribute((Object)DECODED_MESSAGE_KEY, (Object)message);
                session.removeAttribute((Object)DECODER_STATE_KEY);
                session.removeAttribute((Object)DECODED_MESSAGE_TYPE_KEY);
            }
        }
    }

    public static Map<String, Object> parseQuerystring(String query) {
        String[] params = query.split("&");
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }

    private final class DecoderState {
        byte fin = (byte)-128;
        byte opCode = (byte)-128;
        byte mask = (byte)-128;
        int frameLen = 0;
        byte[] payload;

        private DecoderState() {
        }

        public String toString() {
            return "DecoderState [fin=" + this.fin + ", opCode=" + this.opCode + ", mask=" + this.mask + ", frameLen=" + this.frameLen + "]";
        }
    }
}

