/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.red5.net.websocket.SecureWebSocketConfiguration;
import org.red5.net.websocket.WebSocketHandler;
import org.red5.net.websocket.codec.WebSocketCodecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class WebSocketTransport
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(WebSocketTransport.class);
    private int sendBufferSize = 2048;
    private int receiveBufferSize = 2048;
    private int connectionThreads = 8;
    private int ioThreads = 16;
    private int port = 80;
    private Set<String> addresses = new HashSet<String>();
    private IoHandlerAdapter ioHandler;
    private SocketAcceptor acceptor;
    private SecureWebSocketConfiguration secureConfig;

    public void afterPropertiesSet() throws Exception {
        this.acceptor = new NioSocketAcceptor(this.ioThreads);
        if (this.ioHandler == null) {
            this.ioHandler = new WebSocketHandler();
        }
        log.trace("I/O handler: {}", (Object)this.ioHandler);
        DefaultIoFilterChainBuilder chain = this.acceptor.getFilterChain();
        if (this.secureConfig != null) {
            SslFilter sslFilter = this.secureConfig.getSslFilter();
            chain.addFirst("sslFilter", (IoFilter)sslFilter);
        }
        if (log.isTraceEnabled()) {
            chain.addLast("logger", (IoFilter)new LoggingFilter());
        }
        chain.addLast("protocol", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new WebSocketCodecFactory()));
        this.acceptor.setCloseOnDeactivation(true);
        this.acceptor.setHandler((IoHandler)this.ioHandler);
        this.acceptor.setBacklog(64);
        SocketSessionConfig sessionConf = this.acceptor.getSessionConfig();
        sessionConf.setReuseAddress(true);
        sessionConf.setTcpNoDelay(true);
        sessionConf.setReceiveBufferSize(this.receiveBufferSize);
        sessionConf.setSendBufferSize(this.sendBufferSize);
        this.acceptor.setReuseAddress(true);
        if (this.addresses.isEmpty()) {
            if (this.secureConfig != null) {
                log.info("WebSocket (wss) will be bound to port {}", (Object)this.port);
            } else {
                log.info("WebSocket (ws) will be bound to port {}", (Object)this.port);
            }
            this.acceptor.bind((SocketAddress)new InetSocketAddress(this.port));
        } else {
            if (this.secureConfig != null) {
                log.info("WebSocket (wss) will be bound to {}", this.addresses);
            } else {
                log.info("WebSocket (ws) will be bound to {}", this.addresses);
            }
            try {
                HashSet<InetSocketAddress> socketAddresses = new HashSet<InetSocketAddress>();
                for (String addr : this.addresses) {
                    if (addr.indexOf(58) != -1) {
                        String[] parts = addr.split(":");
                        socketAddresses.add(new InetSocketAddress(parts[0], (int)Integer.valueOf(parts[1])));
                        continue;
                    }
                    socketAddresses.add(new InetSocketAddress(addr, this.port));
                }
                log.debug("Binding to {}", (Object)((Object)socketAddresses).toString());
                this.acceptor.bind(socketAddresses);
            }
            catch (Exception e) {
                log.error("Exception occurred during resolve / bind", (Throwable)e);
            }
        }
        log.info("started {} websocket transport", (Object)(this.isSecure() ? "secure" : ""));
    }

    public void destroy() throws Exception {
        log.info("stopped {} websocket transport", (Object)(this.isSecure() ? "secure" : ""));
        this.acceptor.unbind();
    }

    public void setAddresses(List<String> addrs) {
        for (String addr : addrs) {
            this.addresses.add(addr);
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public void setConnectionThreads(int connectionThreads) {
        this.connectionThreads = connectionThreads;
    }

    public void setIoThreads(int ioThreads) {
        this.ioThreads = ioThreads;
    }

    public boolean isSecure() {
        return this.secureConfig != null;
    }

    public void setIoHandler(IoHandlerAdapter ioHandler) {
        this.ioHandler = ioHandler;
    }

    public void setSecureConfig(SecureWebSocketConfiguration secureConfig) {
        this.secureConfig = secureConfig;
    }
}

