/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.red5.net.websocket.WebSocketConnection;
import org.red5.net.websocket.WebSocketScope;
import org.red5.net.websocket.listener.DefaultWebSocketDataListener;
import org.red5.net.websocket.listener.IWebSocketDataListener;
import org.red5.net.websocket.listener.IWebSocketScopeListener;
import org.red5.server.api.IContext;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketScopeManager {
    private static final Logger log = LoggerFactory.getLogger(WebSocketScopeManager.class);
    private CopyOnWriteArraySet<String> activeApplications = new CopyOnWriteArraySet();
    private static CopyOnWriteArraySet<IWebSocketScopeListener> scopeListners = new CopyOnWriteArraySet();
    private ConcurrentMap<String, WebSocketScope> scopes = new ConcurrentHashMap<String, WebSocketScope>();

    public static void addListener(IWebSocketScopeListener listner) {
        scopeListners.add(listner);
    }

    public static void removeListener(IWebSocketScopeListener listner) {
        scopeListners.remove(listner);
    }

    public boolean isEnabled(String application) {
        if (application.startsWith("/")) {
            int roomSlashPos = application.indexOf(47, 1);
            application = roomSlashPos == -1 ? application.substring(1) : application.substring(1, roomSlashPos);
        }
        boolean enabled = this.activeApplications.contains(application);
        log.debug("Enabled check on application: {} enabled: {}", (Object)application, (Object)enabled);
        return enabled;
    }

    public void addApplication(IScope scope) {
        String app = scope.getName();
        this.activeApplications.add(app);
        IContext ctx = scope.getContext();
        if (ctx != null && ctx.hasBean("webSocketScopeDefault")) {
            log.debug("WebSocket scope found in context");
            WebSocketScope wsScope = (WebSocketScope)scope.getContext().getBean("webSocketScopeDefault");
            if (wsScope != null) {
                log.trace("Default WebSocketScope has {} listeners", (Object)wsScope.getListeners().size());
            }
            this.scopes.put(String.format("/%s", app), wsScope);
        } else {
            log.debug("Creating a new scope");
            WebSocketScope wsScope = new WebSocketScope();
            wsScope.setScope(scope);
            wsScope.setPath(String.format("/%s", app));
            this.scopes.put(wsScope.getPath(), wsScope);
            WebSocketScopeManager.notifyListeners(wsScope);
            if (wsScope.getListeners().isEmpty()) {
                log.debug("adding default listener");
                wsScope.addListener(new DefaultWebSocketDataListener());
            }
        }
    }

    private static void notifyListeners(WebSocketScope wsScope) {
        for (IWebSocketScopeListener l : scopeListners) {
            l.scopeCreated(wsScope);
        }
    }

    public void removeApplication(IScope scope) {
        this.activeApplications.remove(scope.getName());
    }

    public void addWebSocketScope(WebSocketScope webSocketScope) {
        String path = webSocketScope.getPath();
        if (!this.scopes.containsKey(path)) {
            this.scopes.put(path, webSocketScope);
            log.info("addWebSocketScope: {}", (Object)webSocketScope);
        }
    }

    public void removeWebSocketScope(WebSocketScope webSocketScope) {
        log.info("removeWebSocketScope: {}", (Object)webSocketScope);
        this.scopes.remove(webSocketScope.getPath());
    }

    public void addConnection(WebSocketConnection conn) {
        WebSocketScope scope = this.getScope(conn);
        scope.addConnection(conn);
    }

    public void removeConnection(WebSocketConnection conn) {
        WebSocketScope scope;
        if (conn != null && (scope = this.getScope(conn)) != null) {
            scope.removeConnection(conn);
            if (!scope.isValid()) {
                this.scopes.remove(scope);
            }
        }
    }

    public void addListener(IWebSocketDataListener listener, String path) {
        log.trace("addListener: {}", (Object)listener);
        WebSocketScope scope = this.getScope(path);
        if (scope != null) {
            scope.addListener(listener);
        } else {
            log.info("Scope not found for path: {}", (Object)path);
        }
    }

    public void removeListener(IWebSocketDataListener listener, String path) {
        log.trace("removeListener: {}", (Object)listener);
        WebSocketScope scope = this.getScope(path);
        if (scope != null) {
            scope.removeListener(listener);
            if (!scope.isValid()) {
                this.scopes.remove(scope);
            }
        } else {
            log.info("Scope not found for path: {}", (Object)path);
        }
    }

    public WebSocketScope getScope(String path) {
        log.debug("getScope: {}", (Object)path);
        WebSocketScope scope = (WebSocketScope)this.scopes.get(path);
        if (scope == null) {
            scope = (WebSocketScope)this.scopes.get("default");
        }
        log.debug("Returning: {}", (Object)scope);
        return scope;
    }

    public void makeScope(String path) {
        log.debug("makeScope: {}", (Object)path);
        WebSocketScope scope = null;
        if (!this.scopes.containsKey(path)) {
            scope = new WebSocketScope();
            scope.setPath(path);
            this.scopes.put(path, scope);
            WebSocketScopeManager.notifyListeners(scope);
            log.debug("Use the IWebSocketScopeListener interface to be notified of new scopes");
        } else {
            log.debug("Scope already exists: {}", (Object)path);
        }
    }

    private WebSocketScope getScope(WebSocketConnection conn) {
        WebSocketScope scope;
        if (log.isTraceEnabled()) {
            log.trace("Scopes: {}", this.scopes);
        }
        log.debug("getScope: {}", (Object)conn);
        String path = conn.getPath();
        if (!this.scopes.containsKey(path)) {
            if (!this.scopes.containsKey("default")) {
                scope = new WebSocketScope();
                scope.setPath(path);
                this.scopes.put(path, scope);
                WebSocketScopeManager.notifyListeners(scope);
                log.debug("Use the IWebSocketScopeListener interface to be notified of new scopes");
            } else {
                path = "default";
            }
        }
        scope = (WebSocketScope)this.scopes.get(path);
        log.debug("Returning: {}", (Object)scope);
        return scope;
    }
}

