/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.red5.net.websocket.WebSocketConnection;
import org.red5.net.websocket.WebSocketPlugin;
import org.red5.net.websocket.WebSocketScopeManager;
import org.red5.net.websocket.listener.IWebSocketDataListener;
import org.red5.net.websocket.model.WSMessage;
import org.red5.server.api.scope.IScope;
import org.red5.server.plugin.PluginRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class WebSocketScope
implements InitializingBean,
DisposableBean {
    private Logger log = LoggerFactory.getLogger(WebSocketScope.class);
    private CopyOnWriteArraySet<WebSocketConnection> conns = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<IWebSocketDataListener> listeners = new CopyOnWriteArraySet();
    private IScope scope;
    private String path = "default";

    public void afterPropertiesSet() throws Exception {
        this.register();
    }

    public void destroy() throws Exception {
        this.unregister();
    }

    public void register() {
        this.log.info("Application scope: {}", (Object)this.scope);
        WebSocketScopeManager manager = ((WebSocketPlugin)PluginRegistry.getPlugin((String)"WebSocketPlugin")).getManager();
        manager.addWebSocketScope(this);
        this.log.info("WebSocket scope added");
        manager.addApplication(this.scope);
        this.log.info("WebSocket app added: {}", (Object)this.scope.getName());
    }

    public void unregister() {
        WebSocketScopeManager manager = ((WebSocketPlugin)PluginRegistry.getPlugin((String)"WebSocketPlugin")).getManager();
        manager.removeWebSocketScope(this);
        this.log.info("WebSocket scope removed");
        manager.removeApplication(this.scope);
        this.log.info("WebSocket app removed: {}", (Object)this.scope.getName());
    }

    public Set<WebSocketConnection> getConns() {
        return this.conns;
    }

    public IScope getScope() {
        return this.scope;
    }

    public void setScope(IScope scope) {
        this.scope = scope;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void addConnection(WebSocketConnection conn) {
        this.conns.add(conn);
        for (IWebSocketDataListener listener : this.listeners) {
            listener.onWSConnect(conn);
        }
    }

    public void removeConnection(WebSocketConnection conn) {
        this.conns.remove(conn);
        for (IWebSocketDataListener listener : this.listeners) {
            listener.onWSDisconnect(conn);
        }
    }

    public void addListener(IWebSocketDataListener listener) {
        this.log.info("addListener: {}", (Object)listener);
        this.listeners.add(listener);
    }

    public void removeListener(IWebSocketDataListener listener) {
        this.log.info("removeListener: {}", (Object)listener);
        this.listeners.remove(listener);
    }

    public void setListeners(Collection<IWebSocketDataListener> listeners) {
        this.log.trace("setListeners: {}", listeners);
        this.listeners.addAll(listeners);
    }

    public Set<IWebSocketDataListener> getListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    public boolean isValid() {
        return this.conns.size() + this.listeners.size() > 0;
    }

    public void onMessage(WSMessage message) {
        this.log.trace("Listeners: {}", (Object)this.listeners.size());
        for (IWebSocketDataListener listener : this.listeners) {
            try {
                listener.onWSMessage(message);
            }
            catch (Exception e) {
                this.log.warn("onMessage exception", (Throwable)e);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebSocketScope other = (WebSocketScope)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public String toString() {
        return "WebSocketScope [path=" + this.path + ", listeners=" + this.listeners.size() + ", connections=" + this.conns.size() + "]";
    }
}

