/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket;

import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.red5.net.websocket.WebSocketConnection;
import org.red5.net.websocket.WebSocketPlugin;
import org.red5.net.websocket.WebSocketScopeManager;
import org.red5.net.websocket.model.WSMessage;
import org.red5.server.plugin.PluginRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketHandler
extends IoHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(WebSocketHandler.class);

    public void messageReceived(IoSession session, Object message) throws Exception {
        WebSocketConnection conn;
        log.trace("Message received on session: {}  {}", (Object)session.getId(), message);
        if (message instanceof WSMessage && (conn = (WebSocketConnection)session.getAttribute((Object)"connection")) != null) {
            conn.receive((WSMessage)message);
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        log.trace("Message sent on session: {}  {}", (Object)session.getId(), (Object)String.valueOf(message));
        log.trace("Session read: {} write: {}", (Object)session.getReadBytes(), (Object)session.getWrittenBytes());
    }

    public void sessionClosed(IoSession session) throws Exception {
        log.trace("Session closed");
        WebSocketConnection conn = (WebSocketConnection)session.getAttribute((Object)"connection");
        WebSocketPlugin plugin = (WebSocketPlugin)PluginRegistry.getPlugin((String)"WebSocketPlugin");
        if (plugin != null) {
            WebSocketScopeManager manager = plugin.getManager();
            if (manager != null) {
                manager.removeConnection(conn);
            } else {
                log.debug("WebSocket manager was not found");
            }
        } else {
            log.debug("WebSocket plugin was not found");
        }
        super.sessionClosed(session);
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        log.error("exception", cause);
    }
}

