/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Map;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.session.IoSession;
import org.red5.net.websocket.WebSocketPlugin;
import org.red5.net.websocket.WebSocketScope;
import org.red5.net.websocket.WebSocketScopeManager;
import org.red5.net.websocket.model.ConnectionType;
import org.red5.net.websocket.model.MessageType;
import org.red5.net.websocket.model.Packet;
import org.red5.net.websocket.model.WSMessage;
import org.red5.net.websocket.util.IdGenerator;
import org.red5.server.plugin.PluginRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnection {
    private static final Logger log = LoggerFactory.getLogger(WebSocketConnection.class);
    private final long id = IdGenerator.generateId();
    private ConnectionType type = ConnectionType.WEB;
    private boolean connected;
    private IoSession session;
    private String host;
    private String path;
    private String origin;
    private boolean secure;
    private Map<String, Object> headers;
    private Map<String, Object> querystringParameters;
    private Map<String, Object> extensions;
    private String protocol;

    public WebSocketConnection(IoSession session) {
        this.session = session;
    }

    public void receive(WSMessage message) {
        log.trace("receive message");
        if (this.isConnected()) {
            WebSocketPlugin plugin = (WebSocketPlugin)PluginRegistry.getPlugin((String)"WebSocketPlugin");
            WebSocketScopeManager manager = plugin.getManager();
            WebSocketScope scope = manager.getScope(this.getPath());
            scope.onMessage(message);
        } else {
            log.warn("Not connected");
        }
    }

    public void send(String data) throws UnsupportedEncodingException {
        log.trace("send message: {}", (Object)data);
        Packet packet = Packet.build(data.getBytes("UTF8"), MessageType.TEXT);
        this.session.write((Object)packet);
    }

    public void send(byte[] buf) {
        log.trace("send binary: {}", (Object)Arrays.toString(buf));
        Packet packet = Packet.build(buf);
        this.session.write((Object)packet);
    }

    public void sendPong(byte[] buf) {
        log.trace("send pong: {}", (Object)buf);
        Packet packet = Packet.build(buf, MessageType.PONG);
        this.session.write((Object)packet);
    }

    public void close() {
        CloseFuture future = this.session.closeNow();
        future.addListener((IoFutureListener)new IoFutureListener<CloseFuture>(){

            public void operationComplete(CloseFuture future) {
                if (future.isClosed()) {
                    log.debug("Connection is closed");
                } else {
                    log.debug("Connection is not yet closed");
                }
                future.removeListener((IoFutureListener)this);
                WebSocketConnection.this.connected = false;
            }
        });
    }

    public ConnectionType getType() {
        return this.type;
    }

    public void setType(ConnectionType type) {
        this.type = type;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected() {
        this.connected = true;
    }

    public String getHost() {
        return String.format("%s://%s%s", this.secure ? "wss" : "ws", this.host, this.path);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public IoSession getSession() {
        return this.session;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path.charAt(path.length() - 1) == '/' ? path.substring(0, path.length() - 1) : path;
    }

    public long getId() {
        return this.id;
    }

    public boolean isWebConnection() {
        return this.type == ConnectionType.WEB;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getQuerystringParameters() {
        return this.querystringParameters;
    }

    public void setQuerystringParameters(Map<String, Object> querystringParameters) {
        this.querystringParameters = querystringParameters;
    }

    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
    }

    public String getExtensionsAsString() {
        String extensionsList = null;
        if (this.extensions != null) {
            StringBuilder sb = new StringBuilder();
            for (String key : this.extensions.keySet()) {
                sb.append(key);
                sb.append("; ");
            }
            extensionsList = sb.toString().trim();
        }
        return extensionsList;
    }

    public boolean hasProtocol() {
        return this.protocol != null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String toString() {
        return "WebSocketConnection [id=" + this.id + ", type=" + (Object)((Object)this.type) + ", host=" + this.host + ", origin=" + this.origin + ", path=" + this.path + ", secure=" + this.secure + ", connected=" + this.connected + ", remote=" + (this.session != null ? this.session.getRemoteAddress().toString() : "unk") + "]";
    }
}

