/*
 * Decompiled with CFR 0.152.
 */
package org.red5.net.websocket;

import java.io.File;
import java.io.NotActiveException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.mina.filter.ssl.KeyStoreFactory;
import org.apache.mina.filter.ssl.SslContextFactory;
import org.apache.mina.filter.ssl.SslFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureWebSocketConfiguration {
    private static Logger log = LoggerFactory.getLogger(SecureWebSocketConfiguration.class);
    private String keystorePassword;
    private String truststorePassword;
    private String keystoreFile;
    private String truststoreFile;
    private String keystoreType = "JKS";

    public SslFilter getSslFilter() throws Exception {
        if (this.keystoreFile == null || this.truststoreFile == null) {
            throw new NotActiveException("Keystore or truststore are null");
        }
        SSLContext context = this.getSslContext();
        SslFilter sslFilter = new SslFilter(context);
        return sslFilter;
    }

    private SSLContext getSslContext() {
        SSLContext sslContext = null;
        try {
            log.debug("Keystore: {}", (Object)this.keystoreFile);
            File keyStore = new File(this.keystoreFile);
            log.trace("Keystore - read: {} path: {}", (Object)keyStore.canRead(), (Object)keyStore.getCanonicalPath());
            log.debug("Truststore: {}", (Object)this.truststoreFile);
            File trustStore = new File(this.truststoreFile);
            log.trace("Truststore - read: {} path: {}", (Object)trustStore.canRead(), (Object)trustStore.getCanonicalPath());
            if (keyStore.exists() && trustStore.exists()) {
                String[] supportedProtocols;
                KeyStoreFactory keyStoreFactory = new KeyStoreFactory();
                keyStoreFactory.setDataFile(keyStore);
                keyStoreFactory.setPassword(this.keystorePassword);
                KeyStoreFactory trustStoreFactory = new KeyStoreFactory();
                trustStoreFactory.setDataFile(trustStore);
                trustStoreFactory.setPassword(this.truststorePassword);
                SslContextFactory sslContextFactory = new SslContextFactory();
                KeyStore ks = keyStoreFactory.newInstance();
                sslContextFactory.setKeyManagerFactoryKeyStore(ks);
                KeyStore ts = trustStoreFactory.newInstance();
                sslContextFactory.setTrustManagerFactoryKeyStore(ts);
                sslContextFactory.setKeyManagerFactoryKeyStorePassword(this.keystorePassword);
                sslContext = sslContextFactory.newInstance();
                log.debug("SSL provider is: {}", (Object)sslContext.getProvider());
                SSLParameters params = sslContext.getDefaultSSLParameters();
                log.debug("SSL context params - need client auth: {} want client auth: {} endpoint id algorithm: {}", new Object[]{params.getNeedClientAuth(), params.getWantClientAuth(), params.getEndpointIdentificationAlgorithm()});
                for (String protocol : supportedProtocols = params.getProtocols()) {
                    log.debug("SSL context supported protocol: {}", (Object)protocol);
                }
            } else {
                log.warn("Keystore or Truststore file does not exist");
            }
        }
        catch (Exception ex) {
            log.error("Exception getting SSL context", (Throwable)ex);
        }
        return sslContext;
    }

    public void setKeystorePassword(String password) {
        this.keystorePassword = password;
    }

    public void setTruststorePassword(String password) {
        this.truststorePassword = password;
    }

    public void setKeystoreFile(String path) {
        this.keystoreFile = path;
    }

    public void setTruststoreFile(String path) {
        this.truststoreFile = path;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }
}

