/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.rapidoid.RapidoidThing;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Prop;
import org.rapidoid.commons.StringRewriter;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.util.TUUID;
import org.rapidoid.util.WebData;

public class JdbcUtil
extends RapidoidThing {
    private static final StringRewriter NAMED_PARAMS_REWRITER = new StringRewriter(StringRewriter.ALL_QUOTES, "\\$(\\w+)\\b");

    public static PreparedStatement prepare(Connection conn, String sql, Map<String, ?> namedArgs, Object[] args) {
        try {
            if (namedArgs != null) {
                U.must((args == null ? 1 : 0) != 0);
                List arguments = U.list();
                sql = JdbcUtil.substituteNamedParams(sql, namedArgs, arguments);
                args = arguments.toArray();
            }
            PreparedStatement stmt = conn.prepareStatement(sql, 1003, 1007);
            JdbcUtil.bind(stmt, args);
            return stmt;
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot create prepared statement!", e);
        }
    }

    private static String substituteNamedParams(String sql, final Map<String, ?> namedArgs, final List<Object> arguments) {
        return NAMED_PARAMS_REWRITER.rewrite(sql, (Mapper)new Mapper<String[], String>(){

            public String map(String[] groups) throws Exception {
                String name = groups[1];
                if (namedArgs.containsKey(name)) {
                    Object value = namedArgs.get(name);
                    arguments.add(value);
                    return "?";
                }
                return groups[0];
            }
        });
    }

    public static void bind(PreparedStatement stmt, Object[] args) throws SQLException {
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg instanceof WebData) {
                arg = ((WebData)arg).unwrap();
            }
            if (arg instanceof byte[]) {
                byte[] bytes = (byte[])arg;
                stmt.setBytes(i + 1, bytes);
                continue;
            }
            if (arg instanceof UUID) {
                UUID uuid = (UUID)arg;
                byte[] bytes = Msc.uuidToBytes((UUID)uuid);
                stmt.setBytes(i + 1, bytes);
                continue;
            }
            if (arg instanceof TUUID) {
                TUUID tuuid = (TUUID)arg;
                stmt.setBytes(i + 1, tuuid.toBytes());
                continue;
            }
            stmt.setObject(i + 1, arg);
        }
    }

    public static <T> List<T> rows(Mapper<ResultSet, T> resultMapper, ResultSet rs) throws Exception {
        List rows = U.list();
        while (rs.next()) {
            rows.add(resultMapper.map((Object)rs));
        }
        return rows;
    }

    public static <T> List<T> rows(Class<T> resultType, ResultSet rs) throws Exception {
        List rows = U.list();
        ResultSetMetaData meta = rs.getMetaData();
        int columnsN = meta.getColumnCount();
        Prop[] props = new Prop[columnsN];
        for (int i = 0; i < props.length; ++i) {
            String name = meta.getColumnLabel(i + 1);
            props[i] = Beany.property(resultType, (String)name, (boolean)false);
        }
        while (rs.next()) {
            T row = resultType.newInstance();
            for (int i = 0; i < columnsN; ++i) {
                if (props[i] == null) continue;
                Object value = rs.getObject(i + 1);
                props[i].set(row, value);
            }
            rows.add(row);
        }
        return rows;
    }

    private static Object convertResultValue(String type, Object value) {
        switch (type) {
            case "TUUID": {
                U.must((boolean)(value instanceof byte[]), (String)"Expecting byte[] value to convert to TUUID!");
                byte[] bytes = (byte[])value;
                return TUUID.fromBytes((byte[])bytes);
            }
            case "UUID": {
                U.must((boolean)(value instanceof byte[]), (String)"Expecting byte[] value to convert to UUID!");
                byte[] bytes = (byte[])value;
                return Msc.bytesToUUID((byte[])bytes);
            }
        }
        throw U.rte((String)"Unknown type: '%s'", (Object[])new Object[]{type});
    }

    public static List<Map<String, Object>> rows(ResultSet rs) throws SQLException {
        List rows = U.list();
        while (rs.next()) {
            rows.add(JdbcUtil.row(rs));
        }
        return rows;
    }

    public static Map<String, Object> row(ResultSet rs) throws SQLException {
        Map row = U.map();
        ResultSetMetaData meta = rs.getMetaData();
        int columnsNumber = meta.getColumnCount();
        for (int i = 1; i <= columnsNumber; ++i) {
            String name = meta.getColumnLabel(i);
            Object value = rs.getObject(i);
            String[] nameParts = name.split("__");
            if (nameParts.length == 2) {
                name = nameParts[0];
                value = JdbcUtil.convertResultValue(nameParts[1], value);
            }
            row.put(name, value);
        }
        return row;
    }
}

