/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import org.rapidoid.collection.Coll;
import org.rapidoid.datamodel.Results;
import org.rapidoid.jdbc.JdbcClient;
import org.rapidoid.jdbc.JdbcUtil;
import org.rapidoid.lambda.Mapper;

public class JDBC
extends JdbcUtil {
    private static final Map<String, JdbcClient> APIS = Coll.autoExpandingMap(String.class, JdbcClient.class);

    public static synchronized void reset() {
        APIS.clear();
    }

    @Deprecated
    public static JdbcClient newApi() {
        return JDBC.api(UUID.randomUUID().toString());
    }

    public static synchronized JdbcClient api() {
        return APIS.get("default");
    }

    public static synchronized JdbcClient api(String name) {
        return APIS.get(name);
    }

    @Deprecated
    public static synchronized JdbcClient defaultApi() {
        return JDBC.api();
    }

    public static JdbcClient username(String username) {
        return JDBC.api().username(username);
    }

    public static JdbcClient password(String password) {
        return JDBC.api().password(password);
    }

    public static JdbcClient driver(String driver) {
        return JDBC.api().driver(driver);
    }

    public static JdbcClient url(String url) {
        return JDBC.api().url(url);
    }

    public static JdbcClient mysql(String host, int port, String databaseName) {
        return JDBC.api().mysql(host, port, databaseName);
    }

    public static JdbcClient h2(String databaseName) {
        return JDBC.api().h2(databaseName);
    }

    public static JdbcClient hsql(String databaseName) {
        return JDBC.api().hsql(databaseName);
    }

    public static int execute(String sql, Object ... args) {
        return JDBC.api().execute(sql, args);
    }

    public static int execute(String sql, Map<String, ?> namedArgs) {
        return JDBC.api().execute(sql, namedArgs);
    }

    public static int tryToExecute(String sql, Object ... args) {
        return JDBC.api().tryToExecute(sql, args);
    }

    public static int tryToExecute(String sql, Map<String, ?> namedArgs) {
        return JDBC.api().tryToExecute(sql, namedArgs);
    }

    public static <T> Results<T> query(Class<T> resultType, String sql, Object ... args) {
        return JDBC.api().query(resultType, sql, args);
    }

    public static <T> Results<T> query(Class<T> resultType, String sql, Map<String, ?> namedArgs) {
        return JDBC.api().query(resultType, sql, namedArgs);
    }

    public static <T> Results<T> query(Mapper<ResultSet, T> resultMapper, String sql, Object ... args) {
        return JDBC.api().query(resultMapper, sql, args);
    }

    public static <T> Results<T> query(Mapper<ResultSet, T> resultMapper, String sql, Map<String, ?> namedArgs) {
        return JDBC.api().query(resultMapper, sql, namedArgs);
    }

    public static Results<Map<String, Object>> query(String sql, Object ... args) {
        return JDBC.api().query(sql, args);
    }

    public static Results<Map<String, Object>> query(String sql, Map<String, ?> namedArgs) {
        return JDBC.api().query(sql, namedArgs);
    }

    public static Connection getConnection() {
        return JDBC.api().getConnection();
    }

    public static void release(Connection connection) {
        JDBC.api().release(connection);
    }

    public static DataSource bootstrapDatasource() {
        return JDBC.api().bootstrapDatasource();
    }
}

