/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.security;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Metadata;
import org.rapidoid.config.Conf;
import org.rapidoid.ctx.Roles;
import org.rapidoid.security.DataPermissions;
import org.rapidoid.security.annotation.Admin;
import org.rapidoid.security.annotation.HasRole;
import org.rapidoid.security.annotation.LoggedIn;
import org.rapidoid.security.annotation.Manager;
import org.rapidoid.security.annotation.Moderator;
import org.rapidoid.security.annotation.Role;
import org.rapidoid.u.U;
import org.rapidoid.util.Constants;

public class AppSecurity
implements Constants {
    public String[] getRolesAllowed(Map<Class<?>, Annotation> annotations) {
        Set roles = U.set();
        for (Map.Entry<Class<?>, Annotation> e : annotations.entrySet()) {
            Annotation ann = e.getValue();
            Class<? extends Annotation> type = ann.annotationType();
            if (type.equals(Admin.class)) {
                roles.add("admin");
                continue;
            }
            if (type.equals(Manager.class)) {
                roles.add("manager");
                continue;
            }
            if (type.equals(Moderator.class)) {
                roles.add("moderator");
                continue;
            }
            if (type.equals(LoggedIn.class)) {
                roles.add("logged_in");
                continue;
            }
            if (!type.equals(HasRole.class)) continue;
            Role[] values = ((HasRole)ann).value();
            U.must((values.length > 0 ? 1 : 0) != 0, (String)"At least one role must be specified in @Roles annotation!");
            for (Role r : values) {
                roles.add(r.value().toLowerCase());
            }
        }
        return roles.toArray(new String[roles.size()]);
    }

    public String[] getRolesAllowed(Class<?> clazz) {
        Map annotations = Metadata.classAnnotations(clazz);
        return this.getRolesAllowed(annotations);
    }

    public String[] getRolesAllowed(Method method) {
        Map annotations = Metadata.methodAnnotations((Method)method);
        return this.getRolesAllowed(annotations);
    }

    public boolean canAccessClass(String username, Class<?> clazz) {
        return true;
    }

    public boolean hasRole(String username, String role, Class<?> clazz, Object record) {
        if ("anybody".equalsIgnoreCase(role)) {
            return true;
        }
        if (U.isEmpty((String)username) || U.isEmpty((String)role)) {
            return false;
        }
        if (record != null) {
            if (role.equalsIgnoreCase("owner")) {
                return this.isOwnerOf(username, record);
            }
            if (role.equalsIgnoreCase("shared_with")) {
                return this.isSharedWith(username, record);
            }
        }
        return this.hasRole(username, role);
    }

    protected boolean hasRoleInDevMode(String username, String role) {
        return Conf.dev() && (role.toLowerCase() + "@debug").equals(username);
    }

    protected boolean hasRole(String username, String role) {
        if (this.hasRoleInDevMode(username, role)) {
            return true;
        }
        if (role.equalsIgnoreCase("logged_in")) {
            return !U.isEmpty((String)username);
        }
        return Roles.getRolesFor((String)username).contains(role.toLowerCase());
    }

    public boolean isAdmin(String username) {
        return this.hasRole(username, "admin", null, null);
    }

    public boolean isManager(String username) {
        return this.hasRole(username, "manager", null, null);
    }

    public boolean isModerator(String username) {
        return this.hasRole(username, "moderator", null, null);
    }

    public DataPermissions classPermissions(String username, Class<?> clazz) {
        return DataPermissions.ALL;
    }

    public DataPermissions recordPermissions(String username, Object record) {
        return DataPermissions.ALL;
    }

    public DataPermissions propertyPermissions(String username, Object record, String propertyName) {
        return DataPermissions.ALL;
    }

    public boolean isOwnerOf(String username, Object record) {
        if (U.isEmpty((String)username) || record == null) {
            return false;
        }
        Object owner = Beany.getPropValue((Object)record, (String)"createdBy", null);
        return owner instanceof String && username.equalsIgnoreCase((String)owner);
    }

    public boolean isSharedWith(String username, Object record) {
        if (U.isEmpty((String)username) || record == null) {
            return false;
        }
        Object sharedWith = Beany.getPropValue((Object)record, (String)"sharedWith", null);
        if (sharedWith != null && sharedWith instanceof Collection) {
            for (Object user : (Collection)sharedWith) {
                if (!username.equalsIgnoreCase((String)Beany.getPropValue(user, (String)"username", (Object)""))) continue;
                return true;
            }
        }
        return false;
    }
}

