/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.log;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.rapidoid.log.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public class Log {
    public static final LogLevel LEVEL_TRACE = LogLevel.TRACE;
    public static final LogLevel LEVEL_DEBUG = LogLevel.DEBUG;
    public static final LogLevel LEVEL_INFO = LogLevel.INFO;
    public static final LogLevel LEVEL_WARN = LogLevel.WARN;
    public static final LogLevel LEVEL_ERROR = LogLevel.ERROR;
    protected static LogLevel LOG_LEVEL = LEVEL_INFO;

    private Log() {
    }

    public static synchronized void args(String ... args) {
        for (String arg : args) {
            for (LogLevel level : LogLevel.values()) {
                if (!arg.equalsIgnoreCase(level.name())) continue;
                Log.setLogLevel(level);
            }
        }
    }

    public static synchronized void setLogLevel(LogLevel logLevel) {
        Log.info("Setting log level", "from", (Object)LOG_LEVEL, "to", (Object)logLevel);
        LOG_LEVEL = logLevel;
    }

    public static synchronized LogLevel getLogLevel() {
        return LOG_LEVEL;
    }

    public static void debugging() {
        Log.setLogLevel(LEVEL_DEBUG);
    }

    private static String getCallingClass() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        for (int i = 2; i < trace.length; ++i) {
            String cls = trace[i].getClassName();
            if (cls.equals(Log.class.getCanonicalName())) continue;
            return cls;
        }
        return Log.class.getCanonicalName();
    }

    private static void formatLogMsg(Appendable out, String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, int paramsN) {
        try {
            out.append(msg);
            switch (paramsN) {
                case 0: {
                    break;
                }
                case 1: {
                    Log.printKeyValue(out, key1, value1);
                    break;
                }
                case 2: {
                    Log.printKeyValue(out, key1, value1);
                    Log.printKeyValue(out, key2, value2);
                    break;
                }
                case 3: {
                    Log.printKeyValue(out, key1, value1);
                    Log.printKeyValue(out, key2, value2);
                    Log.printKeyValue(out, key3, value3);
                    break;
                }
                case 4: {
                    Log.printKeyValue(out, key1, value1);
                    Log.printKeyValue(out, key2, value2);
                    Log.printKeyValue(out, key3, value3);
                    Log.printKeyValue(out, key4, value4);
                    break;
                }
                case 5: {
                    Log.printKeyValue(out, key1, value1);
                    Log.printKeyValue(out, key2, value2);
                    Log.printKeyValue(out, key3, value3);
                    Log.printKeyValue(out, key4, value4);
                    Log.printKeyValue(out, key5, value5);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot render log message!", e);
        }
    }

    private static void printKeyValue(Appendable out, String key, Object value) throws IOException {
        out.append(" | ");
        out.append(key);
        out.append("=");
        out.append(Log.printable(value));
        if (value instanceof Throwable) {
            Throwable err = (Throwable)value;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            err.printStackTrace(new PrintStream(stream));
            out.append("\n");
            out.append(stream.toString());
        }
    }

    private static String printable(Object value) {
        return String.valueOf(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(LogLevel level, String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, int paramsN) {
        if (!Log.isEnabled(level)) {
            return;
        }
        Logger logger = Log.logger();
        if (logger == null || logger instanceof NOPLogger) {
            StringBuilder sb = new StringBuilder();
            sb.append(level.name());
            sb.append(" | ");
            sb.append(Thread.currentThread().getName());
            sb.append(" | ");
            sb.append(Log.getCallingClass());
            sb.append(" | ");
            Log.formatLogMsg(sb, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, paramsN);
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.println(sb.toString());
            }
            return;
        }
        switch (level) {
            case TRACE: {
                if (!logger.isTraceEnabled()) break;
                StringBuilder sb = new StringBuilder();
                Log.formatLogMsg(sb, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, paramsN);
                logger.trace(sb.toString());
                break;
            }
            case DEBUG: {
                if (!logger.isDebugEnabled()) break;
                StringBuilder sb = new StringBuilder();
                Log.formatLogMsg(sb, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, paramsN);
                logger.debug(sb.toString());
                break;
            }
            case INFO: {
                if (!logger.isInfoEnabled()) break;
                StringBuilder sb = new StringBuilder();
                Log.formatLogMsg(sb, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, paramsN);
                logger.info(sb.toString());
                break;
            }
            case WARN: {
                if (!logger.isWarnEnabled()) break;
                StringBuilder sb = new StringBuilder();
                Log.formatLogMsg(sb, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, paramsN);
                logger.warn(sb.toString());
                break;
            }
            case ERROR: {
                if (!logger.isErrorEnabled()) break;
                StringBuilder sb = new StringBuilder();
                Log.formatLogMsg(sb, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, paramsN);
                logger.error(sb.toString());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public static Logger logger() {
        return LoggerFactory.getLogger((String)Log.getCallingClass());
    }

    public static boolean isTraceEnabled() {
        return Log.isEnabled(LEVEL_TRACE);
    }

    public static boolean isDebugEnabled() {
        return Log.isEnabled(LEVEL_DEBUG);
    }

    public static boolean isInfoEnabled() {
        return Log.isEnabled(LEVEL_INFO);
    }

    public static boolean isWarnEnabled() {
        return Log.isEnabled(LEVEL_WARN);
    }

    public static boolean isErrorEnabled() {
        return Log.isEnabled(LEVEL_ERROR);
    }

    public static boolean isEnabled(LogLevel level) {
        return level.ordinal() >= LOG_LEVEL.ordinal();
    }

    public static void warn(String msg, Throwable error) {
        Log.warn(msg, "error", error.getMessage());
    }

    public static void error(String msg, Throwable error) {
        Log.error(msg, "error", error.getMessage());
        error.printStackTrace();
    }

    public static void trace(String msg) {
        Log.log(LEVEL_TRACE, msg, null, null, null, null, null, null, null, null, null, null, 0);
    }

    public static void trace(String msg, String key, Object value) {
        Log.log(LEVEL_TRACE, msg, key, value, null, null, null, null, null, null, null, null, 1);
    }

    public static void trace(String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(LEVEL_TRACE, msg, key1, value1, key2, value2, null, null, null, null, null, null, 2);
    }

    public static void trace(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(LEVEL_TRACE, msg, key1, value1, key2, value2, key3, value3, null, null, null, null, 3);
    }

    public static void trace(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        Log.log(LEVEL_TRACE, msg, key1, value1, key2, value2, key3, value3, key4, value4, null, null, 4);
    }

    public static void trace(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5) {
        Log.log(LEVEL_TRACE, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, 5);
    }

    public static void debug(String msg) {
        Log.log(LEVEL_DEBUG, msg, null, null, null, null, null, null, null, null, null, null, 0);
    }

    public static void debug(String msg, String key, Object value) {
        Log.log(LEVEL_DEBUG, msg, key, value, null, null, null, null, null, null, null, null, 1);
    }

    public static void debug(String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(LEVEL_DEBUG, msg, key1, value1, key2, value2, null, null, null, null, null, null, 2);
    }

    public static void debug(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(LEVEL_DEBUG, msg, key1, value1, key2, value2, key3, value3, null, null, null, null, 3);
    }

    public static void debug(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        Log.log(LEVEL_DEBUG, msg, key1, value1, key2, value2, key3, value3, key4, value4, null, null, 4);
    }

    public static void debug(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5) {
        Log.log(LEVEL_DEBUG, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, 5);
    }

    public static void info(String msg) {
        Log.log(LEVEL_INFO, msg, null, null, null, null, null, null, null, null, null, null, 0);
    }

    public static void info(String msg, String key, Object value) {
        Log.log(LEVEL_INFO, msg, key, value, null, null, null, null, null, null, null, null, 1);
    }

    public static void info(String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(LEVEL_INFO, msg, key1, value1, key2, value2, null, null, null, null, null, null, 2);
    }

    public static void info(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(LEVEL_INFO, msg, key1, value1, key2, value2, key3, value3, null, null, null, null, 3);
    }

    public static void info(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        Log.log(LEVEL_INFO, msg, key1, value1, key2, value2, key3, value3, key4, value4, null, null, 4);
    }

    public static void info(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5) {
        Log.log(LEVEL_INFO, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, 5);
    }

    public static void warn(String msg) {
        Log.log(LEVEL_WARN, msg, null, null, null, null, null, null, null, null, null, null, 0);
    }

    public static void warn(String msg, String key, Object value) {
        Log.log(LEVEL_WARN, msg, key, value, null, null, null, null, null, null, null, null, 1);
    }

    public static void warn(String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(LEVEL_WARN, msg, key1, value1, key2, value2, null, null, null, null, null, null, 2);
    }

    public static void warn(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(LEVEL_WARN, msg, key1, value1, key2, value2, key3, value3, null, null, null, null, 3);
    }

    public static void warn(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        Log.log(LEVEL_WARN, msg, key1, value1, key2, value2, key3, value3, key4, value4, null, null, 4);
    }

    public static void warn(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5) {
        Log.log(LEVEL_WARN, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, 5);
    }

    public static void error(String msg) {
        Log.log(LEVEL_ERROR, msg, null, null, null, null, null, null, null, null, null, null, 0);
    }

    public static void error(String msg, String key, Object value) {
        Log.log(LEVEL_ERROR, msg, key, value, null, null, null, null, null, null, null, null, 1);
    }

    public static void error(String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(LEVEL_ERROR, msg, key1, value1, key2, value2, null, null, null, null, null, null, 2);
    }

    public static void error(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(LEVEL_ERROR, msg, key1, value1, key2, value2, key3, value3, null, null, null, null, 3);
    }

    public static void error(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        Log.log(LEVEL_ERROR, msg, key1, value1, key2, value2, key3, value3, key4, value4, null, null, 4);
    }

    public static void error(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5) {
        Log.log(LEVEL_ERROR, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, 5);
    }
}

