/*
 * Decompiled with CFR 0.152.
 */
package org.python.sizeof;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.python.sizeof.RamUsageEstimator;

public class ObjectTree {
    public static void dump(PrintWriter pw, Object root) {
        Node nodeTree = Node.create(root);
        ObjectTree.printTree(new StringBuilder(), new StringBuilder(), pw, nodeTree);
    }

    public static String dump(Object root) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ObjectTree.dump(pw, root);
        pw.flush();
        return sw.toString();
    }

    private static void printTree(StringBuilder prefix, StringBuilder line, PrintWriter pw, Node node) {
        line.append(node.getName());
        pw.println(String.format(Locale.ENGLISH, "%,8d %,8d  %s", node.deepSize, node.shallowSize, line.toString()));
        line.setLength(0);
        if (node.hasChildren()) {
            int pLen = prefix.length();
            Iterator<Node> i = node.getChildren().iterator();
            while (i.hasNext()) {
                Node next = i.next();
                line.append(prefix.toString());
                line.append("+- ");
                prefix.append(i.hasNext() ? "|  " : "   ");
                ObjectTree.printTree(prefix, line, pw, next);
                prefix.setLength(pLen);
            }
        }
    }

    private static class Node {
        private String name;
        private List<Node> children;
        private long shallowSize;
        private long deepSize;

        public Node(String name, Object delegate) {
            this.name = name;
            if (delegate != null) {
                this.deepSize = this.shallowSize = RamUsageEstimator.shallowSizeOf(delegate);
            }
        }

        private void addChild(Node node) {
            if (this.children == null) {
                this.children = new ArrayList<Node>();
            }
            this.children.add(node);
            this.deepSize += node.deepSize;
        }

        public static Node create(Object delegate) {
            return Node.create("root", delegate, new IdentityHashMap<Object, Integer>());
        }

        public static Node create(String prefix, Object delegate, IdentityHashMap<Object, Integer> seen) {
            if (delegate == null) {
                throw new IllegalArgumentException();
            }
            if (seen.containsKey(delegate)) {
                return new Node("[seen " + Node.uniqueName(delegate, seen) + "]", null);
            }
            seen.put(delegate, seen.size());
            Class<?> clazz = delegate.getClass();
            if (clazz.isArray()) {
                Node parent = new Node(prefix + " => " + clazz.getSimpleName(), delegate);
                if (clazz.getComponentType().isPrimitive()) {
                    return parent;
                }
                int length = Array.getLength(delegate);
                for (int i = 0; i < length; ++i) {
                    Object object = Array.get(delegate, i);
                    if (object == null) continue;
                    parent.addChild(Node.create("[" + i + "]", object, seen));
                }
                return parent;
            }
            ArrayList<AccessibleObject> declaredFields = new ArrayList<AccessibleObject>();
            for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
                AccessibleObject[] fields = c.getDeclaredFields();
                AccessibleObject.setAccessible(fields, true);
                declaredFields.addAll(Arrays.asList(fields));
            }
            Collections.sort(declaredFields, new Comparator<Field>(){

                @Override
                public int compare(Field o1, Field o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            Node parent = new Node(prefix + " => " + Node.uniqueName(delegate, seen), delegate);
            for (Field field : declaredFields) {
                try {
                    if (Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive()) continue;
                    Object fValue = field.get(delegate);
                    if (fValue != null) {
                        parent.addChild(Node.create(field.getType().getSimpleName() + " " + field.getName(), fValue, seen));
                        continue;
                    }
                    parent.addChild(new Node(field.getType().getSimpleName() + " " + field.getName() + " => null", null));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return parent;
        }

        private static String uniqueName(Object t, IdentityHashMap<Object, Integer> seen) {
            return "<" + t.getClass().getSimpleName() + "#" + seen.get(t) + ">";
        }

        public String getName() {
            return this.name;
        }

        public boolean hasChildren() {
            return this.children != null && !this.children.isEmpty();
        }

        public List<Node> getChildren() {
            return this.children;
        }
    }
}

