/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.core.PySystemStateRef;
import org.python.core.TraceFunction;

public class ThreadState {
    public PyFrame frame;
    public PyException exception;
    public int call_depth;
    public boolean tracing;
    public PyList reprStack;
    public int compareStateNesting;
    public TraceFunction tracefunc;
    public TraceFunction profilefunc;
    private PyDictionary compareStateDict;
    private PySystemStateRef systemStateRef;

    public ThreadState(PySystemState systemState) {
        this.setSystemState(systemState);
    }

    public void setSystemState(PySystemState systemState) {
        if (systemState == null) {
            systemState = Py.defaultSystemState;
        }
        if (this.systemStateRef == null || this.systemStateRef.get() != systemState) {
            this.systemStateRef = new PySystemStateRef(systemState, this);
        }
    }

    public PySystemState getSystemState() {
        PySystemState systemState = this.systemStateRef == null ? null : (PySystemState)this.systemStateRef.get();
        return systemState == null ? Py.defaultSystemState : systemState;
    }

    public boolean enterRepr(PyObject obj) {
        if (this.reprStack == null) {
            this.reprStack = new PyList(new PyObject[]{obj});
            return true;
        }
        for (int i = this.reprStack.size() - 1; i >= 0; --i) {
            if (obj != this.reprStack.pyget(i)) continue;
            return false;
        }
        this.reprStack.append(obj);
        return true;
    }

    public void exitRepr(PyObject obj) {
        if (this.reprStack == null) {
            return;
        }
        for (int i = this.reprStack.size() - 1; i >= 0; --i) {
            if (this.reprStack.pyget(i) != obj) continue;
            this.reprStack.delRange(i, this.reprStack.size());
        }
    }

    public PyDictionary getCompareStateDict() {
        if (this.compareStateDict == null) {
            this.compareStateDict = new PyDictionary();
        }
        return this.compareStateDict;
    }
}

