/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.util.Map;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.client.auth.oauth2.AccessToken;
import org.projectnessie.client.auth.oauth2.ImmutableAccessToken;
import org.projectnessie.client.auth.oauth2.ImmutableRefreshToken;
import org.projectnessie.client.auth.oauth2.JacksonSerializers;
import org.projectnessie.client.auth.oauth2.RefreshToken;
import org.projectnessie.client.auth.oauth2.Tokens;

interface TokensResponseBase
extends Tokens {
    @Override
    @JsonIgnore
    @Value.Lazy
    default public AccessToken getAccessToken() {
        return ImmutableAccessToken.builder().tokenType(this.getTokenType()).payload(this.getAccessTokenPayload()).expirationTime(this.getAccessTokenExpirationTime()).build();
    }

    @Override
    @Nullable
    @JsonIgnore
    @Value.Lazy
    default public RefreshToken getRefreshToken() {
        if (this.getRefreshTokenPayload() != null) {
            return ImmutableRefreshToken.builder().payload(this.getRefreshTokenPayload()).expirationTime(this.getRefreshTokenExpirationTime()).build();
        }
        return null;
    }

    @JsonProperty(value="token_type")
    public String getTokenType();

    @JsonProperty(value="access_token")
    public String getAccessTokenPayload();

    @Nullable
    @JsonProperty(value="expires_in")
    @JsonUnwrapped
    @JsonSerialize(using=JacksonSerializers.InstantToSecondsSerializer.class)
    @JsonDeserialize(using=JacksonSerializers.SecondsToInstantDeserializer.class)
    public Instant getAccessTokenExpirationTime();

    @Nullable
    @JsonProperty(value="refresh_token")
    public String getRefreshTokenPayload();

    @Nullable
    @JsonProperty(value="refresh_expires_in")
    @JsonSerialize(using=JacksonSerializers.InstantToSecondsSerializer.class)
    @JsonDeserialize(using=JacksonSerializers.SecondsToInstantDeserializer.class)
    public Instant getRefreshTokenExpirationTime();

    @Nullable
    @JsonProperty(value="scope")
    public String getScope();

    @JsonAnyGetter
    public Map<String, Object> getExtraParameters();
}

